/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.AgentAnalyzer;
import org.eclipse.oomph.p2.internal.ui.AdditionalURIPrompterDialog;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.ProfileDetailsDialog;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.SubMonitor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AgentAnalyzerComposite
extends Composite {
    private static final int TABLE_STYLE = 0x10010A10;
    private static final String SHOW_ALL = "Show All";
    private static final String SHOW_UNUSED = "Unused";
    private static final String SHOW_DAMAGED = "Damaged";
    private static final String SHOW_BY_ARTIFACT = "By Artifact";
    private final Set<ISelectionProvider> changingSelection = new HashSet<ISelectionProvider>();
    private final Agent agent;
    private boolean initializingAnalyzer;
    private AgentAnalyzer analyzer;
    private AgentAnalyzer.AnalyzedBundlePool currentBundlePool;
    private TableViewer bundlePoolViewer;
    private BundlePoolContentProvider bundlePoolContentProvider;
    private Button deleteUnusedProfilesButton;
    private Button deleteUnusedArtifactsButton;
    private Button repairAllArtifactsButton;
    private TableViewer profileViewer;
    private ProfileContentProvider profileContentProvider;
    private String profileFilter = "Show All";
    private Button selectAllProfilesButton;
    private Button deleteProfilesButton;
    private Button showDetailsButton;
    private TableViewer artifactViewer;
    private ArtifactContentProvider artifactContentProvider;
    private Button selectAllArtifactsButton;
    private Button repairArtifactsButton;
    private Button deleteArtifactsButton;
    private boolean deletingArtifacts;

    public AgentAnalyzerComposite(Composite parent, int margin, int style, Agent agent) throws InvocationTargetException, InterruptedException {
        super(parent, style);
        this.agent = agent;
        this.setBackground(this.getDisplay().getSystemColor(37));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = margin;
        gridLayout.marginHeight = margin;
        this.setLayout((Layout)gridLayout);
        this.createBundlePoolViewer();
        SashForm verticalSashForm = new SashForm((Composite)this, 66048);
        verticalSashForm.setLayoutData((Object)new GridData(1808));
        this.createProfileViewer((Composite)verticalSashForm);
        this.createArtifactViewer((Composite)verticalSashForm);
        verticalSashForm.setWeights(new int[]{2, 3});
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AgentAnalyzerComposite.this.analyzer != null) {
                    AgentAnalyzerComposite.this.analyzer.dispose();
                }
            }
        });
        this.initAnalyzer();
        this.bundlePoolContentProvider.setInput(this.bundlePoolViewer, this.analyzer);
    }

    private void createBundlePoolViewer() {
        Composite bundlePoolComposite = new Composite((Composite)this, 0);
        GridLayout bundlePoolLayout = new GridLayout();
        bundlePoolLayout.marginWidth = 0;
        bundlePoolLayout.marginHeight = 0;
        bundlePoolComposite.setLayout((Layout)bundlePoolLayout);
        bundlePoolComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.bundlePoolViewer = new TableViewer(bundlePoolComposite, 0x10010A10);
        Table bundlePoolTable = this.bundlePoolViewer.getTable();
        bundlePoolTable.setHeaderVisible(true);
        GridData bundlePoolData = new GridData(4, 4, true, false);
        bundlePoolData.heightHint = 84;
        bundlePoolTable.setLayoutData((Object)bundlePoolData);
        TableColumn bundlePoolColumn = new TableViewerColumn(this.bundlePoolViewer, 0).getColumn();
        bundlePoolColumn.setText("Bundle Pool");
        bundlePoolColumn.setWidth(305);
        bundlePoolColumn.setResizable(false);
        TableColumn profilesColumn = new TableViewerColumn(this.bundlePoolViewer, 0).getColumn();
        profilesColumn.setText("Profiles");
        profilesColumn.setAlignment(131072);
        profilesColumn.setWidth(55);
        TableColumn unusedProfilesColumn = new TableViewerColumn(this.bundlePoolViewer, 0).getColumn();
        unusedProfilesColumn.setText("Unused Profiles");
        unusedProfilesColumn.setAlignment(131072);
        unusedProfilesColumn.setWidth(97);
        TableColumn artifactsColumn = new TableViewerColumn(this.bundlePoolViewer, 0).getColumn();
        artifactsColumn.setText("Artifacts");
        artifactsColumn.setAlignment(131072);
        artifactsColumn.setWidth(63);
        TableColumn unusedArtifactsColumn = new TableViewerColumn(this.bundlePoolViewer, 0).getColumn();
        unusedArtifactsColumn.setText("Unused Artifacts");
        unusedArtifactsColumn.setAlignment(131072);
        unusedArtifactsColumn.setWidth(105);
        TableColumn damagedArtifactsColumn = new TableViewerColumn(this.bundlePoolViewer, 0).getColumn();
        damagedArtifactsColumn.setText("Damaged Artifacts");
        damagedArtifactsColumn.setAlignment(131072);
        damagedArtifactsColumn.setWidth(125);
        this.bundlePoolContentProvider = new BundlePoolContentProvider();
        this.bundlePoolViewer.setContentProvider((IContentProvider)this.bundlePoolContentProvider);
        this.bundlePoolViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(this.getDisplay()));
        this.bundlePoolViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener(this){

            protected void doSelectionChanged(SelectionChangedEvent event) {
                currentBundlePool = (AgentAnalyzer.AnalyzedBundlePool)((IStructuredSelection)event.getSelection()).getFirstElement();
                profileViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                profileContentProvider.setInput(profileViewer, currentBundlePool);
                artifactViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                artifactContentProvider.setInput(artifactViewer, currentBundlePool);
                this.updateBundlePoolButtons();
            }
        });
        Composite bundlePoolButtonBar = new Composite(bundlePoolComposite, 0);
        bundlePoolButtonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout bundlePoolButtonBarLayout = new GridLayout(4, false);
        bundlePoolButtonBarLayout.marginWidth = 0;
        bundlePoolButtonBarLayout.marginHeight = 0;
        bundlePoolButtonBar.setLayout((Layout)bundlePoolButtonBarLayout);
        new Label(bundlePoolButtonBar, 0).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.deleteUnusedProfilesButton = new Button(bundlePoolButtonBar, 0);
        this.deleteUnusedProfilesButton.setText("Delete Unused Profiles");
        this.deleteUnusedProfilesButton.setEnabled(false);
        this.deleteUnusedProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzer.AnalyzedProfile[] profiles = AgentAnalyzerComposite.this.currentBundlePool.getUnusedProfiles();
                AgentAnalyzerComposite.this.deleteProfiles(profiles);
                AgentAnalyzerComposite.this.updateBundlePoolButtons();
            }
        });
        this.deleteUnusedArtifactsButton = new Button(bundlePoolButtonBar, 0);
        this.deleteUnusedArtifactsButton.setText("Delete Unused Artifacts");
        this.deleteUnusedArtifactsButton.setEnabled(false);
        this.deleteUnusedArtifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzer.AnalyzedArtifact[] artifacts = AgentAnalyzerComposite.this.currentBundlePool.getUnusedArtifacts();
                AgentAnalyzerComposite.this.deleteArtifacts(artifacts);
                AgentAnalyzerComposite.this.updateBundlePoolButtons();
            }
        });
        this.repairAllArtifactsButton = new Button(bundlePoolButtonBar, 0);
        this.repairAllArtifactsButton.setText("Repair Damaged Artifacts");
        this.repairAllArtifactsButton.setEnabled(false);
        this.repairAllArtifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzer.AnalyzedArtifact[] artifacts = AgentAnalyzerComposite.this.currentBundlePool.getDamagedArtifacts();
                AgentAnalyzerComposite.this.repairArtifacts(artifacts);
                AgentAnalyzerComposite.this.updateBundlePoolButtons();
            }
        });
        new Label(bundlePoolComposite, 0);
        this.bundlePoolContentProvider.setInput(this.bundlePoolViewer, null);
    }

    private void createProfileViewer(Composite parent) {
        Composite profileComposite = new Composite(parent, 0);
        GridLayout profileLayout = new GridLayout();
        profileLayout.marginWidth = 0;
        profileLayout.marginHeight = 0;
        profileComposite.setLayout((Layout)profileLayout);
        this.profileViewer = new TableViewer(profileComposite, 268503570);
        Table profileTable = this.profileViewer.getTable();
        profileTable.setHeaderVisible(true);
        profileTable.setLayoutData((Object)new GridData(1808));
        new SelectAllAdapter((StructuredViewer)this.profileViewer);
        TableColumn profileColumn = new TableViewerColumn(this.profileViewer, 0).getColumn();
        profileColumn.setText("Profile");
        profileColumn.setWidth(447);
        profileColumn.setResizable(false);
        TableColumn artifactsColumn = new TableViewerColumn(this.profileViewer, 0).getColumn();
        artifactsColumn.setText("Artifacts");
        artifactsColumn.setAlignment(131072);
        artifactsColumn.setWidth(62);
        TableColumn damagedArtifactsColumn = new TableViewerColumn(this.profileViewer, 0).getColumn();
        damagedArtifactsColumn.setText("Damaged Artifacts");
        damagedArtifactsColumn.setAlignment(131072);
        damagedArtifactsColumn.setWidth(120);
        TableColumn rootsColumn = new TableViewerColumn(this.profileViewer, 0).getColumn();
        rootsColumn.setText("Roots");
        rootsColumn.setAlignment(131072);
        rootsColumn.setWidth(50);
        TableColumn repositoriesColumn = new TableViewerColumn(this.profileViewer, 0).getColumn();
        repositoriesColumn.setText("Repositories");
        repositoriesColumn.setAlignment(131072);
        repositoriesColumn.setWidth(82);
        this.profileContentProvider = new ProfileContentProvider();
        this.profileViewer.setContentProvider((IContentProvider)this.profileContentProvider);
        this.profileViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(this.getDisplay()));
        this.profileViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener(this){

            protected void doSelectionChanged(SelectionChangedEvent event) {
                this.updateProfileButtons();
            }

            protected void triggerOtherSelections(SelectionChangedEvent event) {
                if (!changingSelection.contains(artifactViewer)) {
                    HashSet artifacts = new HashSet();
                    AgentAnalyzer.AnalyzedProfile[] analyzedProfileArray = this.getSelectedProfiles();
                    int n = analyzedProfileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AgentAnalyzer.AnalyzedProfile profile = analyzedProfileArray[n2];
                        artifacts.addAll(profile.getArtifacts());
                        ++n2;
                    }
                    artifactViewer.setSelection((ISelection)new StructuredSelection(new ArrayList(artifacts)));
                }
            }
        });
        profileTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AgentAnalyzerComposite.this.showProfileDetails();
            }
        });
        Composite profileButtonBar = new Composite(profileComposite, 0);
        profileButtonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        profileButtonBar.setLayout((Layout)UIUtil.createGridLayout((int)5));
        final Combo filterCombo = new Combo(profileButtonBar, 8);
        filterCombo.add(SHOW_ALL);
        filterCombo.add(SHOW_UNUSED);
        filterCombo.add(SHOW_BY_ARTIFACT);
        filterCombo.select(0);
        filterCombo.pack();
        filterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzerComposite.this.profileFilter = filterCombo.getText();
                AgentAnalyzerComposite.this.profileContentProvider.setFilter(AgentAnalyzerComposite.this.profileFilter);
            }
        });
        this.selectAllProfilesButton = new Button(profileButtonBar, 0);
        this.selectAllProfilesButton.setText("Select All");
        this.selectAllProfilesButton.setEnabled(false);
        this.selectAllProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzerComposite.this.profileViewer.setSelection((ISelection)new StructuredSelection((Object[])AgentAnalyzerComposite.this.currentBundlePool.getProfiles()));
            }
        });
        new Label(profileButtonBar, 0).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.deleteProfilesButton = new Button(profileButtonBar, 0);
        this.deleteProfilesButton.setText("Delete Selected...");
        this.deleteProfilesButton.setEnabled(false);
        this.deleteProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzer.AnalyzedProfile[] profiles = AgentAnalyzerComposite.this.getSelectedProfiles();
                AgentAnalyzerComposite.this.deleteProfiles(profiles);
            }
        });
        this.showDetailsButton = new Button(profileButtonBar, 0);
        this.showDetailsButton.setText("Details...");
        this.showDetailsButton.setEnabled(false);
        this.showDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzerComposite.this.showProfileDetails();
            }
        });
        new Label(profileComposite, 0);
        this.profileContentProvider.setInput(this.profileViewer, null);
    }

    private void createArtifactViewer(Composite parent) {
        Composite artifactComposite = new Composite(parent, 0);
        GridLayout artifactLayout = new GridLayout();
        artifactLayout.marginWidth = 0;
        artifactLayout.marginHeight = 0;
        artifactComposite.setLayout((Layout)artifactLayout);
        this.artifactViewer = new TableViewer(artifactComposite, 268503570);
        Table artifactTable = this.artifactViewer.getTable();
        artifactTable.setHeaderVisible(true);
        artifactTable.setLayoutData((Object)new GridData(1808));
        new SelectAllAdapter((StructuredViewer)this.artifactViewer);
        TableColumn artifactColumn = new TableViewerColumn(this.artifactViewer, 0).getColumn();
        artifactColumn.setText("Artifact");
        artifactColumn.setWidth(365);
        artifactColumn.setResizable(false);
        TableColumn versionVersion = new TableViewerColumn(this.artifactViewer, 0).getColumn();
        versionVersion.setText("Version");
        versionVersion.setWidth(205);
        TableColumn profilesColumn = new TableViewerColumn(this.artifactViewer, 0).getColumn();
        profilesColumn.setText("Profiles");
        profilesColumn.setAlignment(131072);
        profilesColumn.setWidth(56);
        this.artifactContentProvider = new ArtifactContentProvider();
        this.artifactViewer.setContentProvider((IContentProvider)this.artifactContentProvider);
        this.artifactViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(this.getDisplay()));
        this.artifactViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener(this){

            protected void doSelectionChanged(SelectionChangedEvent event) {
                this.updateArtifactButtons();
                if (AgentAnalyzerComposite.SHOW_BY_ARTIFACT.equals(profileFilter)) {
                    profileContentProvider.refresh();
                }
            }

            protected void triggerOtherSelections(SelectionChangedEvent event) {
                if (!AgentAnalyzerComposite.SHOW_BY_ARTIFACT.equals(profileFilter) && !changingSelection.contains(profileViewer)) {
                    HashSet profiles = new HashSet();
                    AgentAnalyzer.AnalyzedArtifact[] analyzedArtifactArray = this.getSelectedArtifacts();
                    int n = analyzedArtifactArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AgentAnalyzer.AnalyzedArtifact artifact = analyzedArtifactArray[n2];
                        profiles.addAll(artifact.getProfiles());
                        ++n2;
                    }
                    profileViewer.setSelection((ISelection)new StructuredSelection(profiles.toArray()));
                }
            }
        });
        Composite artifactButtonBar = new Composite(artifactComposite, 0);
        artifactButtonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout artifactButtonBarLayout = new GridLayout(5, false);
        artifactButtonBarLayout.marginWidth = 0;
        artifactButtonBarLayout.marginHeight = 0;
        artifactButtonBar.setLayout((Layout)artifactButtonBarLayout);
        final Combo filterCombo = new Combo(artifactButtonBar, 8);
        filterCombo.add(SHOW_ALL);
        filterCombo.add(SHOW_UNUSED);
        filterCombo.add(SHOW_DAMAGED);
        filterCombo.select(0);
        filterCombo.pack();
        filterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = filterCombo.getText();
                AgentAnalyzerComposite.this.artifactContentProvider.setFilter(selection);
            }
        });
        this.selectAllArtifactsButton = new Button(artifactButtonBar, 0);
        this.selectAllArtifactsButton.setText("Select All");
        this.selectAllArtifactsButton.setEnabled(false);
        this.selectAllArtifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzerComposite.this.artifactViewer.setSelection((ISelection)new StructuredSelection((Object[])AgentAnalyzerComposite.this.currentBundlePool.getArtifacts()));
            }
        });
        new Label(artifactButtonBar, 0).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.deleteArtifactsButton = new Button(artifactButtonBar, 0);
        this.deleteArtifactsButton.setText("Delete Selected...");
        this.deleteArtifactsButton.setEnabled(false);
        this.deleteArtifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzer.AnalyzedArtifact[] artifacts = AgentAnalyzerComposite.this.getSelectedArtifacts();
                AgentAnalyzerComposite.this.deleteArtifacts(artifacts);
            }
        });
        this.repairArtifactsButton = new Button(artifactButtonBar, 0);
        this.repairArtifactsButton.setText("Repair Selected");
        this.repairArtifactsButton.setEnabled(false);
        this.repairArtifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentAnalyzer.AnalyzedArtifact[] artifacts = AgentAnalyzerComposite.this.getSelectedArtifacts();
                AgentAnalyzerComposite.this.repairArtifacts(artifacts);
            }
        });
        this.artifactContentProvider.setInput(this.artifactViewer, null);
    }

    private void initAnalyzer() throws InvocationTargetException, InterruptedException {
        this.initializingAnalyzer = true;
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AgentAnalyzerComposite.this.analyzer = new AgentAnalyzer(AgentAnalyzerComposite.this.agent, true, new AgentAnalyzer.Handler(){

                        public void analyzerChanged(final AgentAnalyzer analyzer) {
                            if (analyzer == AgentAnalyzerComposite.this.analyzer) {
                                AgentAnalyzerComposite.this.asyncExec(new Runnable(){

                                    public void run() {
                                        AgentAnalyzerComposite.this.bundlePoolContentProvider.refresh();
                                        if (!AgentAnalyzerComposite.this.deletingArtifacts) {
                                            AgentAnalyzerComposite.this.artifactContentProvider.refresh();
                                            AgentAnalyzerComposite.this.profileContentProvider.refresh();
                                        }
                                        AgentAnalyzerComposite.this.getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                Object[] elements = AgentAnalyzerComposite.this.bundlePoolContentProvider.getElements(analyzer);
                                                if (elements.length != 0) {
                                                    AgentAnalyzerComposite.this.bundlePoolViewer.setSelection((ISelection)new StructuredSelection(elements[0]));
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }

                        public void bundlePoolChanged(final AgentAnalyzer.AnalyzedBundlePool bundlePool, final boolean artifacts, final boolean profiles) {
                            AgentAnalyzerComposite.this.asyncExec(new Runnable(){

                                public void run() {
                                    AgentAnalyzerComposite.this.bundlePoolViewer.update((Object)bundlePool, null);
                                    if (bundlePool == AgentAnalyzerComposite.this.currentBundlePool) {
                                        if (!artifacts && !profiles) {
                                            AgentAnalyzerComposite.this.updateBundlePoolButtons();
                                        } else {
                                            if (artifacts) {
                                                AgentAnalyzerComposite.this.artifactContentProvider.refresh();
                                            }
                                            if (profiles) {
                                                AgentAnalyzerComposite.this.profileContentProvider.refresh();
                                            }
                                        }
                                    }
                                }
                            });
                        }

                        public void profileChanged(final AgentAnalyzer.AnalyzedProfile profile) {
                            if (AgentAnalyzerComposite.this.deletingArtifacts) {
                                return;
                            }
                            if (profile.getBundlePool() == AgentAnalyzerComposite.this.currentBundlePool) {
                                AgentAnalyzerComposite.this.asyncExec(new Runnable(){

                                    public void run() {
                                        AgentAnalyzerComposite.this.profileViewer.update((Object)profile, null);
                                    }
                                });
                            }
                        }

                        public void artifactChanged(final AgentAnalyzer.AnalyzedArtifact artifact) {
                            if (AgentAnalyzerComposite.this.deletingArtifacts) {
                                return;
                            }
                            if (artifact == null || artifact.getBundlePool() == AgentAnalyzerComposite.this.currentBundlePool) {
                                AgentAnalyzerComposite.this.asyncExec(new Runnable(){

                                    public void run() {
                                        if (artifact != null && ObjectUtil.equals((Object)AgentAnalyzerComposite.this.artifactContentProvider.getFilter(), (Object)AgentAnalyzerComposite.SHOW_ALL)) {
                                            AgentAnalyzerComposite.this.artifactViewer.update((Object)artifact, null);
                                        } else {
                                            AgentAnalyzerComposite.this.artifactContentProvider.refresh();
                                        }
                                    }
                                });
                            }
                        }
                    }, monitor);
                }
            });
        }
        finally {
            this.initializingAnalyzer = false;
        }
    }

    private void asyncExec(Runnable runnable) {
        if (!this.isDisposed()) {
            Display display = this.getDisplay();
            UIUtil.asyncExec((Display)display, (Runnable)runnable);
        }
    }

    private AgentAnalyzer.AnalyzedProfile[] getSelectedProfiles() {
        IStructuredSelection selection = (IStructuredSelection)this.profileViewer.getSelection();
        List profiles = selection.toList();
        return profiles.toArray(new AgentAnalyzer.AnalyzedProfile[profiles.size()]);
    }

    private AgentAnalyzer.AnalyzedArtifact[] getSelectedArtifacts() {
        IStructuredSelection selection = (IStructuredSelection)this.artifactViewer.getSelection();
        List artifacts = selection.toList();
        return artifacts.toArray(new AgentAnalyzer.AnalyzedArtifact[artifacts.size()]);
    }

    private boolean updateButton(Button button, String text, int count, String suffix) {
        button.setEnabled(count != 0);
        if (count != 0) {
            text = String.valueOf(text) + " " + count;
        }
        text = String.valueOf(text) + suffix;
        if (!button.getText().equals(text)) {
            button.setText(text);
            return true;
        }
        return false;
    }

    private void updateBundlePoolButtons() {
        boolean changed = false;
        if (this.currentBundlePool != null) {
            changed |= this.updateButton(this.deleteUnusedProfilesButton, "Delete", this.currentBundlePool.getUnusedProfilesCount(), " Unused Profiles...");
            if (this.initializingAnalyzer && this.deleteUnusedProfilesButton.isEnabled()) {
                this.deleteUnusedProfilesButton.setEnabled(false);
            }
            changed |= this.updateButton(this.deleteUnusedArtifactsButton, "Delete", this.currentBundlePool.getUnusedArtifactsCount(), " Unused Artifacts...");
            if (this.initializingAnalyzer && this.deleteUnusedArtifactsButton.isEnabled()) {
                this.deleteUnusedArtifactsButton.setEnabled(false);
            }
            changed |= this.updateButton(this.repairAllArtifactsButton, "Repair", this.currentBundlePool.getDamagedArtifactsCount(), " Damaged Artifacts");
            if (this.currentBundlePool.isAnalyzingDamage() && this.repairAllArtifactsButton.isEnabled()) {
                this.repairAllArtifactsButton.setEnabled(false);
            }
        }
        if (changed) {
            Composite parent = this.deleteUnusedProfilesButton.getParent();
            parent.pack();
            parent.getParent().layout();
        }
    }

    private void updateProfileButtons() {
        boolean changed = false;
        if (this.currentBundlePool != null) {
            Object[] elements = this.profileContentProvider.getElements(this.currentBundlePool);
            changed |= this.updateButton(this.selectAllProfilesButton, "Select All", elements.length, "");
        }
        AgentAnalyzer.AnalyzedProfile[] profiles = this.getSelectedProfiles();
        int count = profiles.length;
        changed |= this.updateButton(this.deleteProfilesButton, "Delete", count, " Selected...");
        this.showDetailsButton.setEnabled(count == 1);
        if (count != 0) {
            boolean enabled = true;
            int i = 0;
            while (i < count) {
                AgentAnalyzer.AnalyzedProfile profile = profiles[i];
                if (!profile.isUnused()) {
                    enabled = false;
                    break;
                }
                ++i;
            }
            this.deleteProfilesButton.setEnabled(enabled);
        }
        if (changed) {
            Composite parent = this.deleteProfilesButton.getParent();
            parent.pack();
            parent.getParent().layout();
        }
    }

    private void updateArtifactButtons() {
        boolean changed = false;
        if (this.currentBundlePool != null) {
            Object[] elements = this.artifactContentProvider.getElements(this.currentBundlePool);
            changed |= this.updateButton(this.selectAllArtifactsButton, "Select All", elements.length, "");
        }
        AgentAnalyzer.AnalyzedArtifact[] artifacts = this.getSelectedArtifacts();
        int count = artifacts.length;
        changed |= this.updateButton(this.repairArtifactsButton, "Repair", count, " Selected");
        if (changed |= this.updateButton(this.deleteArtifactsButton, "Delete", count, " Selected...")) {
            Composite parent = this.repairArtifactsButton.getParent();
            parent.pack();
            parent.getParent().layout();
        }
    }

    private void deleteProfiles(final AgentAnalyzer.AnalyzedProfile[] profiles) {
        int len = profiles.length;
        String message = "Do you really want to delete " + len + " profile" + (len == 1 ? "" : "s") + "?";
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Bundle Pool Analysis", (String)message)) {
            try {
                UIUtil.runInProgressDialog((Shell)this.getShell(), (IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Deleting profiles", (int)profiles.length).detectCancelation();
                        AgentAnalyzer.AnalyzedProfile[] analyzedProfileArray = profiles;
                        int n = profiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AgentAnalyzer.AnalyzedProfile profile = analyzedProfileArray[n2];
                            profile.delete((IProgressMonitor)progress.newChild());
                            ++n2;
                        }
                    }
                });
                this.profileContentProvider.refresh();
                this.profileViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            catch (InvocationTargetException ex) {
                ErrorDialog.open((Throwable)ex);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void showProfileDetails() {
        AgentAnalyzer.AnalyzedProfile[] selectedProfiles = this.getSelectedProfiles();
        if (selectedProfiles.length == 1) {
            Profile profile = selectedProfiles[0].getP2Profile();
            ProfileDetailsDialog dialog = new ProfileDetailsDialog(this.getShell(), profile);
            dialog.open();
        }
    }

    private void deleteArtifacts(final AgentAnalyzer.AnalyzedArtifact[] artifacts) {
        int len = artifacts.length;
        String message = "Do you really want to delete " + len + " artifact" + (len == 1 ? "" : "s") + "?\n\n" + "Note 1: Unused artifacts can always safely be deleted. " + "They will be deleted physically from your disk and logically from your bundle pool.\n\n" + "Note 2: Artifacts used in your profiles will be deleted only physically from your disk. " + "Repairing them is possible if they are still available for download from a p2 repository.";
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Bundle Pool Analysis", (String)message)) {
            try {
                try {
                    this.deletingArtifacts = true;
                    UIUtil.runInProgressDialog((Shell)this.getShell(), (IRunnableWithProgress)new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Deleting artifacts...", (int)artifacts.length).detectCancelation();
                            AgentAnalyzer.AnalyzedArtifact[] analyzedArtifactArray = artifacts;
                            int n = artifacts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                AgentAnalyzer.AnalyzedArtifact artifact = analyzedArtifactArray[n2];
                                artifact.delete((IProgressMonitor)progress.newChild());
                                ++n2;
                            }
                        }
                    });
                    this.profileViewer.refresh();
                    this.profileViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    this.artifactContentProvider.refresh();
                    this.artifactViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                catch (InvocationTargetException ex) {
                    ErrorDialog.open((Throwable)ex);
                    this.deletingArtifacts = false;
                }
                catch (InterruptedException interruptedException) {
                    this.deletingArtifacts = false;
                }
            }
            finally {
                this.deletingArtifacts = false;
            }
        }
    }

    private void repairArtifacts(final AgentAnalyzer.AnalyzedArtifact[] artifacts) {
        try {
            final ArrayList<AgentAnalyzer.AnalyzedArtifact> remainingArtifacts = new ArrayList<AgentAnalyzer.AnalyzedArtifact>();
            UIUtil.runInProgressDialog((Shell)this.getShell(), (IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Repairing artifacts", (int)artifacts.length).detectCancelation();
                    AgentAnalyzer.AnalyzedArtifact[] analyzedArtifactArray = artifacts;
                    int n = artifacts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AgentAnalyzer.AnalyzedArtifact artifact = analyzedArtifactArray[n2];
                        if (!artifact.repair(null, (IProgressMonitor)progress.newChild())) {
                            remainingArtifacts.add(artifact);
                        }
                        ++n2;
                    }
                }
            });
            this.artifactContentProvider.refresh();
            this.artifactViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            boolean firstTime = true;
            HashSet<URI> repositories = new HashSet<URI>(this.analyzer.getRepositoryURIs());
            while (!remainingArtifacts.isEmpty()) {
                AdditionalURIPrompterDialog dialog = new AdditionalURIPrompterDialog(this.getShell(), firstTime, remainingArtifacts, repositories);
                if (dialog.open() != 1) {
                    firstTime = false;
                    this.analyzer.getRepositoryURIs().addAll(repositories);
                    final Set<URI> checkedRepositories = dialog.getCheckedRepositories();
                    UIUtil.runInProgressDialog((Shell)this.getShell(), (IRunnableWithProgress)new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Repairing artifacts", (int)artifacts.length).detectCancelation();
                            Iterator it = remainingArtifacts.iterator();
                            while (it.hasNext()) {
                                AgentAnalyzer.AnalyzedArtifact artifact = (AgentAnalyzer.AnalyzedArtifact)it.next();
                                if (!artifact.repair(checkedRepositories, (IProgressMonitor)progress.newChild())) continue;
                                it.remove();
                            }
                        }
                    });
                    repositories.removeAll(checkedRepositories);
                    this.artifactContentProvider.refresh();
                    continue;
                }
                break;
            }
        }
        catch (InvocationTargetException ex) {
            ErrorDialog.open((Throwable)ex);
        }
        catch (InterruptedException interruptedException) {}
    }

    private final class ArtifactContentProvider
    extends TableContentProvider {
        private ArtifactContentProvider() {
        }

        public Object[] getElements(Object input) {
            String filter = this.getFilter();
            if (ObjectUtil.equals((Object)filter, (Object)AgentAnalyzerComposite.SHOW_UNUSED)) {
                return ((AgentAnalyzer.AnalyzedBundlePool)input).getUnusedArtifacts();
            }
            if (ObjectUtil.equals((Object)filter, (Object)AgentAnalyzerComposite.SHOW_DAMAGED)) {
                return ((AgentAnalyzer.AnalyzedBundlePool)input).getDamagedArtifacts();
            }
            return ((AgentAnalyzer.AnalyzedBundlePool)input).getArtifacts();
        }

        public void refresh() {
            super.refresh();
            AgentAnalyzerComposite.this.updateArtifactButtons();
        }
    }

    private final class BundlePoolContentProvider
    extends TableContentProvider {
        private BundlePoolContentProvider() {
        }

        public Object[] getElements(Object input) {
            Map map = ((AgentAnalyzer)input).getBundlePools();
            Object[] bundlePools = map.values().toArray(new AgentAnalyzer.AnalyzedBundlePool[map.size()]);
            Arrays.sort(bundlePools);
            return bundlePools;
        }

        public void refresh() {
            super.refresh();
            AgentAnalyzerComposite.this.updateBundlePoolButtons();
        }
    }

    private final class ProfileContentProvider
    extends TableContentProvider {
        private ProfileContentProvider() {
        }

        public Object[] getElements(Object input) {
            String filter = this.getFilter();
            if (ObjectUtil.equals((Object)filter, (Object)AgentAnalyzerComposite.SHOW_UNUSED)) {
                return ((AgentAnalyzer.AnalyzedBundlePool)input).getUnusedProfiles();
            }
            if (ObjectUtil.equals((Object)filter, (Object)AgentAnalyzerComposite.SHOW_BY_ARTIFACT)) {
                HashSet profiles = new HashSet();
                AgentAnalyzer.AnalyzedArtifact[] analyzedArtifactArray = AgentAnalyzerComposite.this.getSelectedArtifacts();
                int n = analyzedArtifactArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentAnalyzer.AnalyzedArtifact artifact = analyzedArtifactArray[n2];
                    profiles.addAll(artifact.getProfiles());
                    ++n2;
                }
                Object[] array = profiles.toArray(new AgentAnalyzer.AnalyzedProfile[profiles.size()]);
                Arrays.sort(array);
                return array;
            }
            return ((AgentAnalyzer.AnalyzedBundlePool)input).getProfiles();
        }

        public void refresh() {
            super.refresh();
            AgentAnalyzerComposite.this.updateProfileButtons();
        }
    }

    private static final class SelectAllAdapter
    extends KeyAdapter {
        private final StructuredViewer viewer;

        public SelectAllAdapter(StructuredViewer viewer) {
            this.viewer = viewer;
            viewer.getControl().addKeyListener((KeyListener)this);
        }

        public void keyPressed(KeyEvent e) {
            if ((e.stateMask & 0x40000) != 0 && e.keyCode == 97) {
                IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.viewer.getContentProvider();
                this.viewer.setSelection((ISelection)new StructuredSelection(contentProvider.getElements(this.viewer.getInput())));
            }
        }
    }

    private abstract class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public final void selectionChanged(SelectionChangedEvent event) {
            this.doSelectionChanged(event);
            if (AgentAnalyzerComposite.this.changingSelection.add(event.getSelectionProvider())) {
                try {
                    this.triggerOtherSelections(event);
                }
                finally {
                    AgentAnalyzerComposite.this.changingSelection.remove(event.getSelectionProvider());
                }
            }
        }

        protected abstract void doSelectionChanged(SelectionChangedEvent var1);

        protected void triggerOtherSelections(SelectionChangedEvent event) {
        }
    }

    private static abstract class TableContentProvider
    extends ControlAdapter
    implements IStructuredContentProvider,
    ILazyContentProvider {
        private static final int FIRST_TIME = -1;
        private final ControlListener columnListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableContentProvider.this.resizeColumns(true);
            }
        };
        private TableViewer tableViewer;
        private Object input;
        private String filter = "Show All";
        private int lastWidth = -1;

        private TableContentProvider() {
        }

        public void setInput(TableViewer viewer, Object input) {
            ScrollBar verticalBar;
            if (this.tableViewer == null) {
                this.tableViewer = viewer;
                this.tableViewer.getTable().addControlListener((ControlListener)this);
            }
            if (input != null) {
                this.tableViewer.setInput(input);
                this.refresh();
            }
            if ((verticalBar = this.tableViewer.getTable().getVerticalBar()) != null) {
                verticalBar.setSelection(verticalBar.getMinimum());
            }
            this.resizeColumns();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
        }

        public void dispose() {
            this.input = null;
            this.tableViewer = null;
        }

        public void updateElement(int index) {
            Object[] elements = this.getElements(this.input);
            Object element = index < elements.length ? elements[index] : null;
            this.tableViewer.replace(element, index);
        }

        public void refresh() {
            if (this.tableViewer != null && this.input != null) {
                this.tableViewer.refresh();
                this.tableViewer.setItemCount(this.getElements(this.input).length);
            }
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
            UIUtil.asyncExec((Display)this.tableViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    TableContentProvider.this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    TableContentProvider.this.refresh();
                    TableContentProvider.this.resizeColumns();
                }
            });
        }

        public void controlResized(ControlEvent e) {
            this.resizeColumns(false);
        }

        public void resizeColumns() {
            Table table = this.tableViewer.getTable();
            if (!table.isDisposed()) {
                UIUtil.asyncExec((Display)table.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        TableContentProvider.this.resizeColumns(true);
                    }
                });
            }
        }

        private void resizeColumns(boolean force) {
            Table table = this.tableViewer.getTable();
            int tableWidth = table.getSize().x;
            if (force || tableWidth != this.lastWidth) {
                boolean firstTime = this.lastWidth == -1;
                this.lastWidth = tableWidth;
                ScrollBar bar = table.getVerticalBar();
                if (bar != null && bar.isVisible()) {
                    tableWidth -= bar.getSize().x;
                }
                TableColumn[] columns = table.getColumns();
                int i = 1;
                while (i < columns.length) {
                    TableColumn column = columns[i];
                    tableWidth -= column.getWidth();
                    if (firstTime) {
                        column.addControlListener(this.columnListener);
                    }
                    ++i;
                }
                columns[0].setWidth(tableWidth);
            }
        }
    }

    public static final class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private final Color gray;
        private boolean singleColumn;
        static Set<String> keys = new HashSet<String>();

        public TableLabelProvider(Display display, boolean singleColumn) {
            this.singleColumn = singleColumn;
            this.gray = display.getSystemColor(16);
        }

        public TableLabelProvider(Display display) {
            this(display, false);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AgentAnalyzer.AnalyzedBundlePool) {
                AgentAnalyzer.AnalyzedBundlePool bundlePool = (AgentAnalyzer.AnalyzedBundlePool)element;
                switch (columnIndex) {
                    case 0: {
                        return bundlePool.getLocation().getAbsolutePath();
                    }
                    case 1: {
                        return Integer.toString(bundlePool.getProfilesCount());
                    }
                    case 2: {
                        return Integer.toString(bundlePool.getUnusedProfilesCount());
                    }
                    case 3: {
                        return Integer.toString(bundlePool.getArtifactCount());
                    }
                    case 4: {
                        return Integer.toString(bundlePool.getUnusedArtifactsCount());
                    }
                    case 5: {
                        int percent = bundlePool.getDamagedArtifactsPercent();
                        return String.valueOf(Integer.toString(bundlePool.getDamagedArtifactsCount())) + (percent == 100 ? "" : " (" + percent + "%)");
                    }
                }
            } else if (element instanceof AgentAnalyzer.AnalyzedProfile) {
                AgentAnalyzer.AnalyzedProfile profile = (AgentAnalyzer.AnalyzedProfile)element;
                switch (columnIndex) {
                    case 0: {
                        return profile.getID();
                    }
                    case 1: {
                        return Integer.toString(profile.getArtifacts().size());
                    }
                    case 2: {
                        return Integer.toString(profile.getDamagedArtifactsCount());
                    }
                    case 3: {
                        return Integer.toString(profile.getRoots());
                    }
                    case 4: {
                        return Integer.toString(profile.getRepositoryURIs().size());
                    }
                }
            } else if (element instanceof AgentAnalyzer.AnalyzedArtifact) {
                AgentAnalyzer.AnalyzedArtifact artifact = (AgentAnalyzer.AnalyzedArtifact)element;
                switch (columnIndex) {
                    case 0: {
                        if (this.singleColumn) {
                            return String.valueOf(artifact.getID()) + " " + artifact.getVersion();
                        }
                        return artifact.getID();
                    }
                    case 1: {
                        return artifact.getVersion();
                    }
                    case 2: {
                        return Integer.toString(artifact.getProfiles().size());
                    }
                }
            }
            return String.valueOf(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof AgentAnalyzer.AnalyzedBundlePool) {
                    AgentAnalyzer.AnalyzedBundlePool bundlePool = (AgentAnalyzer.AnalyzedBundlePool)element;
                    String key = "bundlePool";
                    if (bundlePool.getDamagedArtifactsCount() != 0) {
                        key = String.valueOf(key) + AgentAnalyzerComposite.SHOW_DAMAGED;
                    }
                    return TableLabelProvider.getPluginImage(key);
                }
                if (element instanceof AgentAnalyzer.AnalyzedArtifact) {
                    AgentAnalyzer.AnalyzedArtifact artifact = (AgentAnalyzer.AnalyzedArtifact)element;
                    String key = "artifact" + artifact.getType();
                    if (artifact.isDamaged()) {
                        key = String.valueOf(key) + AgentAnalyzerComposite.SHOW_DAMAGED;
                    }
                    return TableLabelProvider.getPluginImage(key);
                }
                if (element instanceof AgentAnalyzer.AnalyzedProfile) {
                    AgentAnalyzer.AnalyzedProfile profile = (AgentAnalyzer.AnalyzedProfile)element;
                    String key = "profile" + profile.getType();
                    if (profile.isDamaged()) {
                        key = String.valueOf(key) + AgentAnalyzerComposite.SHOW_DAMAGED;
                    }
                    return TableLabelProvider.getPluginImage(key);
                }
                if (element instanceof URI) {
                    return TableLabelProvider.getPluginImage("repository");
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            AgentAnalyzer.AnalyzedProfile profile;
            AgentAnalyzer.AnalyzedArtifact artifact;
            if (element instanceof AgentAnalyzer.AnalyzedArtifact && (artifact = (AgentAnalyzer.AnalyzedArtifact)element).isUnused()) {
                return this.gray;
            }
            if (element instanceof AgentAnalyzer.AnalyzedProfile && (profile = (AgentAnalyzer.AnalyzedProfile)element).isUnused()) {
                return this.gray;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        private static Image getPluginImage(String key) {
            return P2UIPlugin.INSTANCE.getSWTImage("obj16/" + key);
        }
    }
}

