/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.PreferenceElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class PreferenceProvider
extends QuickAccessProvider {
    private QuickAccessElement[] cachedElements;
    private Map<String, PreferenceElement> idToElement = new HashMap<String, PreferenceElement>();

    @Override
    public String getId() {
        return "org.eclipse.ui.preferences";
    }

    @Override
    public QuickAccessElement findElement(String id, String filterText) {
        this.getElements();
        return this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.cachedElements == null) {
            ArrayList<PreferenceElement> list = new ArrayList<PreferenceElement>();
            this.collectElements("", PlatformUI.getWorkbench().getPreferenceManager().getRootSubNodes(), list);
            this.cachedElements = new PreferenceElement[list.size()];
            int i = 0;
            while (i < list.size()) {
                PreferenceElement preferenceElement = (PreferenceElement)list.get(i);
                this.cachedElements[i] = preferenceElement;
                this.idToElement.put(preferenceElement.getId(), preferenceElement);
                ++i;
            }
        }
        return this.cachedElements;
    }

    private void collectElements(String prefix, IPreferenceNode[] subNodes, List<PreferenceElement> result) {
        IPreferenceNode[] iPreferenceNodeArray = subNodes;
        int n = subNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode subNode = iPreferenceNodeArray[n2];
            if (!WorkbenchActivityHelper.filterItem(subNode)) {
                PreferenceElement preferenceElement = new PreferenceElement(subNode, prefix);
                result.add(preferenceElement);
                String nestedPrefix = prefix.length() == 0 ? subNode.getLabelText() : String.valueOf(prefix) + "/" + subNode.getLabelText();
                this.collectElements(nestedPrefix, subNode.getSubNodes(), result);
            }
            ++n2;
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Preferences;
    }

    @Override
    protected void doReset() {
        this.cachedElements = null;
        this.idToElement.clear();
    }

    @Override
    public boolean requiresUiAccess() {
        return true;
    }
}

