/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.oomph.setup.internal.sync.RemoteDataProvider;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.spi.ICredentialsProvider;

public class SynchronizerJob
extends Job {
    private final Synchronizer synchronizer;
    private final boolean deferLocal;
    private IStorageService service;
    private ICredentialsProvider credentialsProvider;
    private Throwable exception;
    private Synchronization synchronization;
    private FinishHandler finishHandler;
    private boolean finished;
    private boolean awaitCanceled;

    public SynchronizerJob(Synchronizer synchronizer, boolean deferLocal) {
        super("Synchronizing");
        this.synchronizer = synchronizer;
        this.deferLocal = deferLocal;
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public boolean isDeferLocal() {
        return this.deferLocal;
    }

    public IStorageService getService() {
        return this.service;
    }

    public void setService(IStorageService service) {
        this.service = service;
    }

    public ICredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(ICredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public FinishHandler getFinishHandler() {
        return this.finishHandler;
    }

    public void setFinishHandler(FinishHandler finishHandler) {
        this.finishHandler = finishHandler;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Synchronization getSynchronization() {
        return this.synchronization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synchronization awaitSynchronization(IProgressMonitor monitor) {
        while (!this.finished && this.exception == null) {
            if (monitor.isCanceled()) {
                this.awaitCanceled = true;
                break;
            }
            SynchronizerJob synchronizerJob = this;
            synchronized (synchronizerJob) {
                try {
                    ((Object)((Object)this)).wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
        return this.synchronization;
    }

    public void stopSynchronization() {
        this.cancel();
        SynchronizerJob.disposeSynchronization(this.synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        RemoteDataProvider remoteDataProvider = (RemoteDataProvider)this.synchronizer.getRemoteSnapshot().getDataProvider();
        IStorage storage = remoteDataProvider.getStorage();
        ICredentialsProvider oldCredentialsProvider = storage.getCredentialsProvider();
        if (this.credentialsProvider != null) {
            storage.setCredentialsProvider(this.credentialsProvider);
        }
        try {
            try {
                Synchronization result = this.synchronizer.synchronize(this.deferLocal);
                if (Boolean.getBoolean("org.eclipse.oomph.setup.sync.SynchronizerJob.testDelay")) {
                    int i = 0;
                    while (i < 150 && !monitor.isCanceled() && !this.awaitCanceled) {
                        Thread.sleep(100L);
                        ++i;
                    }
                }
                if (monitor.isCanceled()) {
                    SynchronizerJob.disposeSynchronization(result);
                    throw new OperationCanceledException();
                }
                this.handleFinish(null);
                SynchronizerJob synchronizerJob = this;
                synchronized (synchronizerJob) {
                    this.synchronization = result;
                    this.finished = true;
                    ((Object)((Object)this)).notifyAll();
                }
            }
            catch (Throwable t) {
                this.handleFinish(t);
                SynchronizerJob synchronizerJob = this;
                synchronized (synchronizerJob) {
                    this.exception = t;
                    ((Object)((Object)this)).notifyAll();
                }
                if (this.credentialsProvider != null) {
                    storage.setCredentialsProvider(oldCredentialsProvider);
                }
            }
        }
        finally {
            if (this.credentialsProvider != null) {
                storage.setCredentialsProvider(oldCredentialsProvider);
            }
        }
        return Status.OK_STATUS;
    }

    private void handleFinish(Throwable ex) {
        if (this.finishHandler != null) {
            try {
                this.finishHandler.handleFinish(ex);
            }
            catch (Throwable t) {
                SetupSyncPlugin.INSTANCE.log(t);
            }
        }
    }

    private static void disposeSynchronization(Synchronization synchronization) {
        if (synchronization != null) {
            try {
                synchronization.dispose();
            }
            catch (Throwable t) {
                SetupSyncPlugin.INSTANCE.log(t);
            }
        }
    }

    public static interface FinishHandler {
        public void handleFinish(Throwable var1) throws Exception;
    }
}

