/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.function.Supplier;
import org.eclipse.core.internal.databinding.BindingMessages;

public class StringToNumberParser {
    private static final BigDecimal FLOAT_MAX_BIG_DECIMAL = BigDecimal.valueOf(3.4028234663852886E38);
    private static final BigDecimal FLOAT_MIN_BIG_DECIMAL = BigDecimal.valueOf(-3.4028234663852886E38);
    private static final BigDecimal DOUBLE_MAX_BIG_DECIMAL = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final BigDecimal DOUBLE_MIN_BIG_DECIMAL = BigDecimal.valueOf(-1.7976931348623157E308);
    private static final Supplier<Format> GET_INSTANCE = StringToNumberParser.findMethod(NumberFormat::getInstance, "getInstance");
    private static final Supplier<Format> GET_NUMBER_INSTANCE = StringToNumberParser.findMethod(NumberFormat::getNumberInstance, "getNumberInstance");
    private static final Supplier<Format> GET_INTEGER_INSTANCE = StringToNumberParser.findMethod(NumberFormat::getIntegerInstance, "getIntegerInstance");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult parse(Object value, Format numberFormat, boolean primitive) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Value to convert is not a String");
        }
        String source = (String)value;
        ParseResult result = new ParseResult();
        if (!primitive && source.trim().isEmpty()) {
            return result;
        }
        Format format = numberFormat;
        synchronized (format) {
            ParsePosition position = new ParsePosition(0);
            Number parseResult = null;
            parseResult = (Number)numberFormat.parseObject(source, position);
            if (position.getIndex() != source.length() || position.getErrorIndex() > -1) {
                result.position = position;
            } else {
                result.number = parseResult;
            }
        }
        return result;
    }

    public static String createParseErrorMessage(String value, ParsePosition position) {
        int errorIndex;
        int n = errorIndex = position.getErrorIndex() > -1 ? position.getErrorIndex() : position.getIndex();
        if (errorIndex < value.length()) {
            return BindingMessages.formatString("Validate_NumberParseError", new Object[]{value, errorIndex + 1, Character.valueOf(value.charAt(errorIndex))});
        }
        return BindingMessages.formatString("Validate_NumberParseErrorNoCharacter", new Object[]{value, errorIndex + 1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createOutOfRangeMessage(Number minValue, Number maxValue, Format numberFormat) {
        String min = null;
        String max = null;
        Format format = numberFormat;
        synchronized (format) {
            min = numberFormat.format(minValue);
            max = numberFormat.format(maxValue);
        }
        return BindingMessages.formatString("Validate_NumberOutOfRangeError", new Object[]{min, max});
    }

    public static boolean inIntegerRange(Number number) {
        return StringToNumberParser.checkInteger(number, 31);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkInteger(Number number, int bitLength) {
        BigInteger bigInteger = null;
        if (number instanceof Integer || number instanceof Long) {
            bigInteger = BigInteger.valueOf(number.longValue());
        } else if (number instanceof Float || number instanceof Double) {
            double doubleValue = number.doubleValue();
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) return false;
            bigInteger = BigDecimal.valueOf(doubleValue).toBigInteger();
        } else {
            bigInteger = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigDecimal.valueOf(number.doubleValue()).toBigInteger());
        }
        if (bigInteger == null) throw new IllegalArgumentException("Number of type [" + number.getClass().getName() + "] is not supported.");
        return bigInteger.bitLength() <= bitLength;
    }

    public static boolean inLongRange(Number number) {
        return StringToNumberParser.checkInteger(number, 63);
    }

    public static boolean inFloatRange(Number number) {
        return StringToNumberParser.checkDecimal(number, FLOAT_MIN_BIG_DECIMAL, FLOAT_MAX_BIG_DECIMAL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkDecimal(Number number, BigDecimal min, BigDecimal max) {
        BigDecimal bigDecimal = null;
        if (number instanceof Integer || number instanceof Long) {
            bigDecimal = BigDecimal.valueOf(number.doubleValue());
            return max.compareTo(bigDecimal) >= 0 && min.compareTo(bigDecimal) <= 0;
        } else if (number instanceof Float || number instanceof Double) {
            double doubleValue = number.doubleValue();
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) return false;
            bigDecimal = BigDecimal.valueOf(doubleValue);
            return max.compareTo(bigDecimal) >= 0 && min.compareTo(bigDecimal) <= 0;
        } else if (number instanceof BigInteger) {
            bigDecimal = new BigDecimal((BigInteger)number);
            return max.compareTo(bigDecimal) >= 0 && min.compareTo(bigDecimal) <= 0;
        } else if (number instanceof BigDecimal) {
            bigDecimal = (BigDecimal)number;
            return max.compareTo(bigDecimal) >= 0 && min.compareTo(bigDecimal) <= 0;
        } else {
            double doubleValue = number.doubleValue();
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) return false;
            bigDecimal = BigDecimal.valueOf(doubleValue);
        }
        return max.compareTo(bigDecimal) >= 0 && min.compareTo(bigDecimal) <= 0;
    }

    public static boolean inDoubleRange(Number number) {
        return StringToNumberParser.checkDecimal(number, DOUBLE_MIN_BIG_DECIMAL, DOUBLE_MAX_BIG_DECIMAL);
    }

    public static boolean inShortRange(Number number) {
        return StringToNumberParser.checkInteger(number, 15);
    }

    public static boolean inByteRange(Number number) {
        return StringToNumberParser.checkInteger(number, 7);
    }

    public static Format getDefaultFormat() {
        return GET_INSTANCE.get();
    }

    public static Format getDefaultBigDecimalFormat() {
        Format format = GET_NUMBER_INSTANCE.get();
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).setParseBigDecimal(true);
        }
        return format;
    }

    public static Format getDefaultNumberFormat() {
        return GET_NUMBER_INSTANCE.get();
    }

    public static Format getDefaultIntegerFormat() {
        return GET_INTEGER_INSTANCE.get();
    }

    public static Format getDefaultIntegerBigDecimalFormat() {
        Format format = GET_INTEGER_INSTANCE.get();
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).setParseBigDecimal(true);
        }
        return format;
    }

    private static Supplier<Format> findMethod(Supplier<Format> javaTextMethod, String methodName) {
        try {
            Method method = Class.forName("com.ibm.icu.text.NumberFormat").getMethod(methodName, new Class[0]);
            return () -> {
                try {
                    return (Format)method.invoke(null, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (ClassNotFoundException | SecurityException exception) {
            return javaTextMethod;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ParseResult {
        Number number;
        ParsePosition position;

        public Number getNumber() {
            return this.number;
        }

        public ParsePosition getPosition() {
            return this.position;
        }
    }
}

