/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.ui.ResourceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoadResourceCommand
extends ResourceCommand {
    private static final Pattern AUTO_LAUNCHER_WEBSITE = Pattern.compile("^https?://www\\.eclipse\\.org/setups/installer/\\?");
    private static final Pattern SETUP_URL_PARAMETER = Pattern.compile("url=([^&]+)");

    private static URI extractSetupURLIfAutoLauncherURL(URI uri) {
        Matcher matcher;
        if (AUTO_LAUNCHER_WEBSITE.matcher(uri.toString()).find() && uri.hasQuery() && (matcher = SETUP_URL_PARAMETER.matcher(uri.query())).find()) {
            String setupURL = matcher.group(1);
            return URI.createURI((String)setupURL);
        }
        return uri;
    }

    private static Collection<?> extractSetupURLsIfAutoLauncherURLs(Collection<?> collection) {
        if (collection == null) {
            return collection;
        }
        ArrayList copy = new ArrayList(collection.size());
        for (Object object : collection) {
            copy.add(object instanceof URI ? LoadResourceCommand.extractSetupURLIfAutoLauncherURL((URI)object) : object);
        }
        return copy;
    }

    protected LoadResourceCommand(EditingDomain domain, Collection<?> collection) {
        super(domain, LoadResourceCommand.extractSetupURLsIfAutoLauncherURLs(collection));
    }

    @Override
    protected boolean prepare() {
        for (Object object : this.collection) {
            if (!(object instanceof URI)) {
                return false;
            }
            URI uri = (URI)object;
            String fileExtension = uri.fileExtension();
            if ("setup".equals(fileExtension) || "zip".equals(fileExtension) || MarketPlaceListing.getMarketPlaceListing((URI)uri, (URIConverter)this.domain.getResourceSet().getURIConverter()) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void doExecute() {
        this.resources = new ArrayList();
        ResourceSet resourceSet = this.domain.getResourceSet();
        for (Object object : this.collection) {
            Resource resource;
            URI uri = (URI)object;
            MarketPlaceListing marketPlaceListing = MarketPlaceListing.getMarketPlaceListing((URI)uri, (URIConverter)resourceSet.getURIConverter());
            if (marketPlaceListing != null) {
                uri = marketPlaceListing.getListing();
            }
            if ((resource = resourceSet.getResource(uri, marketPlaceListing != null)) == null) {
                resource = resourceSet.createResource(uri);
            }
            this.resources.add(resource);
        }
    }
}

