/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.util.table;

import java.text.Format;
import java.util.List;
import java.util.Set;
import org.eclipse.oomph.internal.util.table.Cell;
import org.eclipse.oomph.internal.util.table.Coordinate;
import org.eclipse.oomph.internal.util.table.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Range
extends Iterable<Cell> {
    public Table table();

    public Set<Cell> set();

    public List<Cell> list();

    public int accept(Cell.Visitor var1) throws Exception;

    public boolean contains(int var1, int var2);

    public boolean contains(Coordinate var1);

    public boolean contains(Cell var1);

    public boolean contains(Range var1);

    public Range offset(int var1, int var2);

    public Range addRange(Coordinate var1, Coordinate var2);

    public Range addRange(int var1, int var2, int var3, int var4);

    public Range addRanges(Range ... var1);

    public Range subtractRange(Coordinate var1, Coordinate var2);

    public Range subtractRange(int var1, int var2, int var3, int var4);

    public Range subtractRanges(Range ... var1);

    public Range value(Object var1);

    public Range format(Format var1);

    public Range alignment(Alignment var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;


        public String apply(String value, int width) {
            int length = value.length();
            int pad = width - length;
            if (pad == 0) {
                return value;
            }
            int padLeft = 0;
            int padRight = 0;
            switch (this) {
                case LEFT: {
                    padRight = pad;
                    break;
                }
                case CENTER: {
                    padLeft = pad / 2;
                    padRight = pad - padLeft;
                    break;
                }
                case RIGHT: {
                    padLeft = pad;
                }
            }
            StringBuilder builder = new StringBuilder(width);
            if (padLeft > 0) {
                Alignment.pad(builder, padLeft);
            }
            builder.append(value);
            if (padRight > 0) {
                Alignment.pad(builder, padRight);
            }
            return builder.toString();
        }

        private static void pad(StringBuilder builder, int spaces) {
            int i = 0;
            while (i < spaces) {
                builder.append(' ');
                ++i;
            }
        }
    }
}

