/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.URLDropAdapter;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;

public class RepositoryManipulatorDropTarget
extends URLDropAdapter {
    ProvisioningUI ui;
    RepositoryTracker tracker;
    Control control;

    public RepositoryManipulatorDropTarget(ProvisioningUI ui, Control control) {
        super(true);
        Assert.isNotNull((Object)ui);
        this.ui = ui;
        this.tracker = ui.getRepositoryTracker();
        this.control = control;
    }

    @Override
    protected void handleDrop(String urlText, final DropTargetEvent event) {
        event.detail = 0;
        final URI[] location = new URI[1];
        try {
            location[0] = URIUtil.fromString((String)urlText);
        }
        catch (URISyntaxException uRISyntaxException) {
            ProvUI.reportStatus(this.tracker.getInvalidLocationStatus(urlText), 3);
            return;
        }
        if (location[0] == null) {
            return;
        }
        UIJob job = new UIJob(ProvUIMessages.RepositoryManipulatorDropTarget_DragAndDropJobLabel){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStatus status = RepositoryManipulatorDropTarget.this.tracker.validateRepositoryLocation(RepositoryManipulatorDropTarget.this.ui.getSession(), location[0], false, monitor);
                if (status.isOK()) {
                    RepositoryManipulatorDropTarget.this.tracker.addRepository(location[0], null, RepositoryManipulatorDropTarget.this.ui.getSession());
                    event.detail = 4;
                } else if (status.getSeverity() == 8) {
                    event.detail = 0;
                } else {
                    status = new MultiStatus("org.eclipse.equinox.p2.ui", 0, new IStatus[]{status}, NLS.bind((String)ProvUIMessages.RepositoryManipulatorDropTarget_DragSourceNotValid, (Object)URIUtil.toUnencodedString((URI)location[0])), null);
                    event.detail = 0;
                }
                return status;
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }
}

