/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ui.dialogs.IStyledStringHighlighter;

public class StyledStringHighlighter
implements IStyledStringHighlighter {
    private static final String QUOTE_START = "(\\Q";
    private static final String QUOTE_END = "\\E)";
    private static final String DOT_STAR_LAZY = ".*?";
    private static final String DOT = ".";
    private static final String QMARK = "?";
    private static final String STAR = "*";
    private static final char TERMINATOR = '<';

    @Override
    public StyledString highlight(String text, String pattern, StyledString.Styler styler) {
        if (text == null || text.isEmpty()) {
            return new StyledString();
        }
        StyledString styledString = new StyledString(text);
        if (pattern == null || pattern.isEmpty() || STAR.equals(pattern) || QMARK.equals(pattern)) {
            return styledString;
        }
        pattern = StyledStringHighlighter.transformWildcardToRegex(pattern);
        try {
            this.highlight(text, pattern, styledString, styler);
        }
        catch (Exception exception) {}
        return styledString;
    }

    private static final String transformWildcardToRegex(String pattern) {
        char[] chars = pattern.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder();
        boolean quoting = false;
        boolean prevStar = false;
        boolean prevChar = false;
        int i = 0;
        while (i < len) {
            block9: {
                boolean isWild;
                char c;
                block11: {
                    block7: {
                        block10: {
                            block8: {
                                c = chars[i];
                                isWild = StyledStringHighlighter.isWildcard(c);
                                if (!isWild) break block7;
                                if (quoting) {
                                    sb.append(QUOTE_END);
                                    quoting = false;
                                }
                                if (c != '*') break block8;
                                if (prevStar) break block9;
                                sb.append(DOT_STAR_LAZY);
                                break block10;
                            }
                            sb.append(DOT);
                        }
                        if (i < len - 1 && !StyledStringHighlighter.isWildcard(chars[i + 1])) {
                            sb.append(QUOTE_START);
                            quoting = true;
                        }
                        break block11;
                    }
                    if (!quoting) {
                        sb.append(QUOTE_START);
                        quoting = true;
                    }
                    if (prevChar && Character.isUpperCase(c)) {
                        sb.append(QUOTE_END);
                        sb.append(DOT_STAR_LAZY);
                        sb.append(QUOTE_START);
                    }
                    if (c != '<') {
                        sb.append(c);
                    }
                    if (i == len - 1) {
                        sb.append(QUOTE_END);
                        quoting = false;
                    }
                }
                prevChar = !isWild;
                prevStar = c == '*';
            }
            ++i;
        }
        return sb.toString();
    }

    private static final boolean isWildcard(char c) {
        return c == '?' || c == '*';
    }

    private void highlight(String text, String filterPattern, StyledString styledString, StyledString.Styler boldStyler) {
        Pattern pattern = Pattern.compile(filterPattern, 2);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                styledString.setStyle(matcher.start(), matcher.end() - matcher.start(), boldStyler);
                continue;
            }
            int i = 1;
            while (i <= groupCount) {
                styledString.setStyle(matcher.start(i), matcher.end(i) - matcher.start(i), boldStyler);
                ++i;
            }
        }
    }
}

