/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.Services;
import org.eclipse.e4.ui.progress.internal.legacy.StatusUtil;
import org.eclipse.e4.ui.workbench.swt.DisplayUISynchronize;
import org.eclipse.swt.widgets.Display;

public abstract class UIJob
extends Job {
    private Display cachedDisplay;

    public static UIJob create(String name, final IJobFunction function) {
        return new UIJob(name){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                return function.run(monitor);
            }
        };
    }

    public static UIJob create(String name, final ICoreRunnable runnable) {
        return new UIJob(name){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    runnable.run(monitor);
                }
                catch (CoreException e) {
                    IStatus st = e.getStatus();
                    return new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public UIJob(String name) {
        super(name);
    }

    public UIJob(Display jobDisplay, String name) {
        this(name);
        this.setDisplay(jobDisplay);
    }

    public static IStatus errorStatus(Throwable exception) {
        return UIJob.getStatus(exception);
    }

    public final IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        UISynchronize uiSynchronize = this.getUiSynchronize();
        if (uiSynchronize == null) {
            return Status.CANCEL_STATUS;
        }
        uiSynchronize.asyncExec(() -> {
            IStatus result = null;
            Throwable throwable = null;
            try {
                try {
                    this.setThread(Thread.currentThread());
                    result = monitor.isCanceled() ? Status.CANCEL_STATUS : this.runInUIThread(monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    result = Status.CANCEL_STATUS;
                    if (result == null) {
                        result = Status.error((String)ProgressMessages.InternalError, (Throwable)throwable);
                    }
                    this.done(result);
                }
                catch (Throwable t) {
                    block10: {
                        throwable = t;
                        if (result != null) break block10;
                        result = Status.error((String)ProgressMessages.InternalError, (Throwable)throwable);
                    }
                    this.done(result);
                }
            }
            finally {
                if (result == null) {
                    result = Status.error((String)ProgressMessages.InternalError, (Throwable)throwable);
                }
                this.done(result);
            }
        });
        return Job.ASYNC_FINISH;
    }

    public abstract IStatus runInUIThread(IProgressMonitor var1);

    public void setDisplay(Display runDisplay) {
        Assert.isNotNull((Object)runDisplay);
        this.cachedDisplay = runDisplay;
    }

    public Display getDisplay() {
        Services instance;
        if (this.cachedDisplay == null && (instance = Services.getInstance()) != null) {
            this.cachedDisplay = instance.getDisplay();
        }
        if (this.cachedDisplay == null) {
            this.cachedDisplay = Display.getCurrent();
        }
        if (this.cachedDisplay == null) {
            this.cachedDisplay = Display.getDefault();
        }
        return this.cachedDisplay;
    }

    public static IStatus getStatus(Throwable t) {
        String message = StatusUtil.getLocalizedMessage(t);
        return UIJob.newError(message, t);
    }

    public static IStatus newError(String message, Throwable t) {
        String pluginId = "org.eclipse.e4.ui.progress";
        int errorCode = 0;
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            pluginId = ce.getStatus().getPlugin();
            errorCode = ce.getStatus().getCode();
        }
        return new Status(4, pluginId, errorCode, message, StatusUtil.getCause(t));
    }

    protected UISynchronize getUiSynchronize() {
        Services instance = Services.getInstance();
        if (instance == null) {
            return new DisplayUISynchronize(this.getDisplay());
        }
        return instance.getUISynchronize();
    }
}

