/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.concurrent.future;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.concurrent.future.AbstractExecutor;
import org.eclipse.equinox.concurrent.future.AbstractFuture;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ISafeProgressRunner;
import org.eclipse.equinox.concurrent.future.SingleOperationListenableFuture;

public class ThreadsExecutor
extends AbstractExecutor {
    protected String createThreadName(IProgressRunnable<?> runnable) {
        return "ThreadsExecutor(" + runnable + ")";
    }

    protected Runnable createRunnable(final ISafeProgressRunner runner, final IProgressRunnable<?> progressRunnable) {
        return new Runnable(){

            @Override
            public void run() {
                runner.runWithProgress(progressRunnable);
            }
        };
    }

    protected void configureThreadForExecution(Thread thread) {
        thread.setDaemon(true);
    }

    @Override
    protected AbstractFuture<?> createFuture(IProgressMonitor monitor) {
        return new SingleOperationListenableFuture(monitor);
    }

    @Override
    public synchronized <ResultType> IFuture<ResultType> execute(IProgressRunnable<? extends ResultType> runnable, IProgressMonitor monitor) throws IllegalThreadStateException {
        Assert.isNotNull(runnable);
        AbstractFuture<?> sof = this.createFuture(monitor);
        Thread thread = new Thread(this.createRunnable(sof, runnable), this.createThreadName(runnable));
        this.configureThreadForExecution(thread);
        thread.start();
        return sof;
    }
}

