/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.net.NetUIMessages;

public class ProxyEntryDialog
extends StatusDialog {
    private ProxyData data;
    private final String[] addedTypes;
    private Label typeLabel;
    private Text typeText;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Button requiresAuthentificationButton;
    private Label userIdLabel;
    private Text userIdText;
    private Label passwordLabel;
    private Text passwordText;
    private static final String PLUGIN_ID = "org.eclipse.ui.net";

    public ProxyEntryDialog(Shell parent, ProxyData data, String[] addedArray, String title) {
        super(parent);
        this.data = data == null ? new ProxyData("", "", 0, false, "") : data;
        this.addedTypes = addedArray;
        this.setTitle(title);
    }

    public ProxyData getValue() {
        return this.data;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.typeLabel = new Label(composite, 0);
        this.typeLabel.setText(NetUIMessages.ProxyEntryDialog_2);
        this.typeLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.typeText = new Text(composite, 2048);
        this.typeText.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        this.typeText.setEditable(false);
        this.hostLabel = new Label(composite, 0);
        this.hostLabel.setText(NetUIMessages.ProxyEntryDialog_3);
        this.hostLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.hostText = new Text(composite, 2048);
        GridData gdata = new GridData(4, 128, true, false);
        gdata.widthHint = 250;
        this.hostText.setLayoutData((Object)gdata);
        this.portLabel = new Label(composite, 0);
        this.portLabel.setText(NetUIMessages.ProxyEntryDialog_4);
        this.portText = new Text(composite, 2048);
        gdata = new GridData();
        gdata.widthHint = 25;
        this.portText.setLayoutData((Object)gdata);
        this.requiresAuthentificationButton = new Button(composite, 32);
        this.requiresAuthentificationButton.setText(NetUIMessages.ProxyEntryDialog_6);
        this.requiresAuthentificationButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.userIdLabel = new Label(composite, 0);
        this.userIdLabel.setText(NetUIMessages.ProxyEntryDialog_7);
        this.userIdLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.userIdText = new Text(composite, 2048);
        this.userIdText.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.passwordLabel = new Label(composite, 0);
        this.passwordLabel.setLayoutData((Object)new GridData(16384, 128, false, true, 1, 1));
        this.passwordLabel.setText(NetUIMessages.ProxyEntryDialog_8);
        this.passwordText = new Text(composite, 2048);
        this.passwordText.setEchoChar('*');
        this.passwordText.setLayoutData((Object)new GridData(4, 128, true, true, 3, 1));
        ModifyListener validationListener = e -> this.updateStatus();
        this.typeText.addModifyListener(validationListener);
        this.hostText.addModifyListener(validationListener);
        this.portText.addModifyListener(validationListener);
        this.userIdText.addModifyListener(validationListener);
        this.passwordText.addModifyListener(validationListener);
        this.requiresAuthentificationButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ProxyEntryDialog.this.enableButtons();
                ProxyEntryDialog.this.updateStatus();
            }

            public void widgetSelected(SelectionEvent e) {
                ProxyEntryDialog.this.enableButtons();
                ProxyEntryDialog.this.updateStatus();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.applyData();
        this.enableButtons();
        this.hostText.setFocus();
        return composite;
    }

    public void create() {
        super.create();
        this.validateHostName();
    }

    public boolean isHelpAvailable() {
        return false;
    }

    public boolean isResizable() {
        return true;
    }

    private String toString(String str) {
        return str == null ? "" : str;
    }

    private void applyData() {
        this.typeText.setText(this.toString(this.data.getType()));
        this.hostText.setText(this.toString(this.data.getHost()));
        if (this.data.getPort() != -1) {
            this.portText.setText(this.toString(Integer.toString(this.data.getPort())));
        } else {
            this.portText.setText("");
        }
        boolean auth = this.data.isRequiresAuthentication();
        this.requiresAuthentificationButton.setSelection(auth);
        this.userIdText.setText(this.toString(this.data.getUserId()));
        this.passwordText.setText(this.toString(this.data.getPassword()));
    }

    private boolean validateHostName() {
        String scheme = null;
        try {
            URI uri = new URI(this.hostText.getText());
            scheme = uri.getScheme();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.updateStatus((IStatus)new Status(4, PLUGIN_ID, 0, NetUIMessages.ProxyEntryDialog_10, null));
            return false;
        }
        if (scheme != null) {
            this.updateStatus((IStatus)new Status(4, PLUGIN_ID, 0, NetUIMessages.ProxyEntryDialog_13, null));
            return false;
        }
        return true;
    }

    protected void okPressed() {
        this.data.setType(this.typeText.getText());
        this.data.setHost(this.hostText.getText());
        this.data.setPort(Integer.parseInt(this.portText.getText()));
        if (this.requiresAuthentificationButton.getSelection()) {
            this.data.setUserid(this.userIdText.getText());
            this.data.setPassword(this.passwordText.getText());
        } else {
            this.data.setUserid(null);
            this.data.setPassword(null);
        }
        super.okPressed();
    }

    protected void enableButtons() {
        boolean auth = this.requiresAuthentificationButton.getSelection();
        this.userIdText.setEnabled(auth);
        this.passwordText.setEnabled(auth);
    }

    protected void updateStatus() {
        String type = this.typeText.getText();
        String[] stringArray = this.addedTypes;
        int n = this.addedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String addedType = stringArray[n2];
            if (addedType.equalsIgnoreCase(type)) {
                this.updateStatus((IStatus)new Status(4, PLUGIN_ID, 0, NetUIMessages.ProxyEntryDialog_9, null));
                return;
            }
            ++n2;
        }
        if (!this.validateHostName()) {
            return;
        }
        if (this.hostText.getText().length() == 0) {
            this.updateStatus((IStatus)new Status(4, PLUGIN_ID, 0, NetUIMessages.ProxyEntryDialog_10, null));
            return;
        }
        try {
            int port = Integer.parseInt(this.portText.getText());
            if (port < 0) {
                this.updateStatus((IStatus)new Status(4, PLUGIN_ID, 0, NetUIMessages.ProxyEntryDialog_11, null));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.updateStatus((IStatus)new Status(4, PLUGIN_ID, 0, NetUIMessages.ProxyEntryDialog_11, null));
            return;
        }
        if (this.requiresAuthentificationButton.getSelection() && this.userIdText.getText().length() == 0) {
            this.updateStatus((IStatus)new Status(4, PLUGIN_ID, 0, NetUIMessages.ProxyEntryDialog_12, null));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

