/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.resources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.resources.AbstractResourcesRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SWTResourcesRegistry
extends AbstractResourcesRegistry {
    public SWTResourcesRegistry(Display display) {
        if (display == null) {
            return;
        }
        display.addListener(12, event -> this.dispose());
    }

    public Object getResource(Object type, Object key) {
        Object resource = super.getResource(type, key);
        if (resource != null && this.isDisposed(resource)) {
            super.unregisterResource(resource);
            return null;
        }
        return resource;
    }

    public void registerResource(Object type, Object key, Object resource) {
        if (resource == null) {
            return;
        }
        super.registerResource(type, key, resource);
    }

    public void disposeResource(Object type, Object key, Object resource) {
        if (resource instanceof Cursor) {
            ((Cursor)resource).dispose();
        } else if (resource instanceof Font) {
            ((Font)resource).dispose();
        } else if (resource instanceof Image) {
            ((Image)resource).dispose();
        }
    }

    protected boolean isDisposed(Object resource) {
        if (resource instanceof Color) {
            return ((Color)resource).isDisposed();
        }
        if (resource instanceof Font) {
            return ((Font)resource).isDisposed();
        }
        if (resource instanceof Image) {
            return ((Image)resource).isDisposed();
        }
        if (resource instanceof Cursor) {
            return ((Cursor)resource).isDisposed();
        }
        return false;
    }

    public List<Object> removeResourcesByKeyTypeAndType(Class<?> keyType, Class<?> ... types) {
        ArrayList<Object> removedResources = new ArrayList<Object>();
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            Iterator iter = this.getCacheByType(cls).entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!keyType.isAssignableFrom(entry.getKey().getClass())) continue;
                removedResources.add(entry.getValue());
                iter.remove();
            }
            ++n2;
        }
        return removedResources;
    }
}

