/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.internal.sync.Messages;
import org.eclipse.oomph.setup.sync.SyncPackage;
import org.eclipse.osgi.util.NLS;

public interface DataProvider {
    public static final File[] NO_FILES = new File[0];

    public Location getLocation();

    public File[] getExtraFiles();

    public boolean retrieve(File var1) throws IOException, NotFoundException;

    public void update(File var1, File var2) throws IOException, NotCurrentException;

    public boolean delete() throws IOException;

    public static enum Location {
        LOCAL{

            @Override
            public <T> T pick(T local, T remote) {
                return local;
            }
        }
        ,
        REMOTE{

            @Override
            public <T> T pick(T local, T remote) {
                return remote;
            }
        };


        public EClass getDataType() {
            return this.pick(SetupPackage.Literals.USER, SyncPackage.Literals.REMOTE_DATA);
        }

        public abstract <T> T pick(T var1, T var2);
    }

    public static class NotCurrentException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public NotCurrentException(URI uri) {
            super(NLS.bind((String)Messages.DataProvider_NotCurrent_exception, (Object)uri));
        }
    }

    public static class NotFoundException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public NotFoundException(URI uri) {
            super(NLS.bind((String)Messages.DataProvider_NotFound_exception, (Object)uri));
        }
    }
}

