/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.core;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.RepositoryType;

public abstract class RepositoryProvider<M extends IRepositoryManager<T>, R extends IRepository<T>, T> {
    private final M repositoryManager;
    private final URI location;
    private R repository;
    private boolean existing;

    public RepositoryProvider(M repositoryManager, URI location) {
        this.repositoryManager = repositoryManager;
        this.location = location;
    }

    public final M getRepositoryManager() {
        return this.repositoryManager;
    }

    public final URI getLocation() {
        return this.location;
    }

    public final R getRepository() {
        return this.getRepository(null);
    }

    public final synchronized R getRepository(IProgressMonitor monitor) {
        if (this.repository == null) {
            try {
                this.existing = this.repositoryManager.contains(this.location);
                this.repository = this.loadRepository(this.repositoryManager, this.location, monitor);
            }
            catch (ProvisionException ex) {
                throw new P2Exception((Throwable)ex);
            }
        }
        return this.repository;
    }

    public final synchronized R createRepository(String name, String type, Map<String, String> properties) {
        try {
            this.existing = this.repositoryManager.contains(this.location);
            this.repository = this.createRepository(this.repositoryManager, this.location, name, type, properties);
        }
        catch (ProvisionException ex) {
            throw new P2Exception((Throwable)ex);
        }
        return this.repository;
    }

    public void removeAllContent(IProgressMonitor monitor) {
        R repository = null;
        try {
            repository = this.getRepository();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (repository != null) {
            this.removeAllContent(repository, monitor);
        }
    }

    public final boolean isExisting() {
        return this.existing;
    }

    public final boolean hasChild(URI childURI) {
        R repository = this.getRepository();
        if (repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            List children = compositeRepository.getChildren();
            if (children.contains(childURI)) {
                return true;
            }
            URI absolute = URIUtil.makeAbsolute((URI)childURI, (URI)this.getLocation());
            if (children.contains(absolute)) {
                return true;
            }
        }
        return false;
    }

    public final void dispose() {
        if (this.repository != null && !this.existing) {
            this.repositoryManager.removeRepository(this.location);
        }
    }

    public abstract RepositoryType getRepositoryType();

    protected abstract R loadRepository(M var1, URI var2, IProgressMonitor var3) throws ProvisionException, OperationCanceledException;

    protected abstract R createRepository(M var1, URI var2, String var3, String var4, Map<String, String> var5) throws ProvisionException, OperationCanceledException;

    protected abstract void removeAllContent(R var1, IProgressMonitor var2);

    public static final class Artifact
    extends RepositoryProvider<IArtifactRepositoryManager, IArtifactRepository, IArtifactKey> {
        public Artifact(IArtifactRepositoryManager repositoryManager, URI location) {
            super(repositoryManager, location);
        }

        @Override
        public RepositoryType getRepositoryType() {
            return RepositoryType.ARTIFACT;
        }

        @Override
        protected IArtifactRepository loadRepository(IArtifactRepositoryManager repositoryManager, URI location, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
            return repositoryManager.loadRepository(location, monitor);
        }

        @Override
        protected IArtifactRepository createRepository(IArtifactRepositoryManager repositoryManager, URI location, String name, String type, Map<String, String> properties) throws ProvisionException, OperationCanceledException {
            return repositoryManager.createRepository(location, name, type, properties);
        }

        @Override
        protected void removeAllContent(IArtifactRepository repository, IProgressMonitor monitor) {
            repository.removeAll(monitor);
        }
    }

    public static final class Metadata
    extends RepositoryProvider<IMetadataRepositoryManager, IMetadataRepository, IInstallableUnit> {
        public Metadata(IMetadataRepositoryManager repositoryManager, URI location) {
            super(repositoryManager, location);
        }

        @Override
        public RepositoryType getRepositoryType() {
            return RepositoryType.METADATA;
        }

        @Override
        protected IMetadataRepository loadRepository(IMetadataRepositoryManager repositoryManager, URI location, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
            return repositoryManager.loadRepository(location, monitor);
        }

        @Override
        protected IMetadataRepository createRepository(IMetadataRepositoryManager repositoryManager, URI location, String name, String type, Map<String, String> properties) throws ProvisionException, OperationCanceledException {
            return repositoryManager.createRepository(location, name, type, properties);
        }

        @Override
        protected void removeAllContent(IMetadataRepository repository, IProgressMonitor monitor) {
            repository.removeAll();
        }
    }
}

