/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.url;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.url.MultiplexingFactory;
import org.eclipse.osgi.internal.url.MultiplexingURLStreamHandler;
import org.eclipse.osgi.internal.url.URLStreamHandlerProxy;
import org.eclipse.osgi.storage.url.reference.Handler;
import org.osgi.framework.BundleContext;

public class URLStreamHandlerFactoryImpl
extends MultiplexingFactory
implements URLStreamHandlerFactory {
    protected static final String URLSTREAMHANDLERCLASS = "org.osgi.service.url.URLStreamHandlerService";
    protected static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    public static final String PROTOCOL_REFERENCE = "reference";
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private static final List<Class<?>> ignoredClasses = Arrays.asList(MultiplexingURLStreamHandler.class, URLStreamHandlerFactoryImpl.class, URL.class);
    private Map<String, URLStreamHandlerProxy> proxies;
    private URLStreamHandlerFactory parentFactory;
    private ThreadLocal<List<String>> creatingProtocols = new ThreadLocal();

    public URLStreamHandlerFactoryImpl(BundleContext context, EquinoxContainer container) {
        super(context, container);
        this.proxies = new ConcurrentHashMap<String, URLStreamHandlerProxy>();
    }

    private Class<?> getBuiltIn(String protocol, String builtInHandlers) {
        if (builtInHandlers == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
        while (tok.hasMoreElements()) {
            StringBuilder name = new StringBuilder();
            name.append(tok.nextToken());
            name.append(".");
            name.append(protocol);
            name.append(".Handler");
            try {
                Class<?> clazz = secureAction.loadSystemClass(name.toString());
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.isRecursive(protocol)) {
            return null;
        }
        try {
            String builtInHandlers = secureAction.getProperty(PROTOCOL_HANDLER_PKGS);
            Class<?> clazz = this.getBuiltIn(protocol, builtInHandlers);
            if (clazz != null) {
                return null;
            }
            URLStreamHandler result = null;
            if (this.isMultiplexing()) {
                URLStreamHandler authorized = this.findAuthorizedURLStreamHandler(protocol);
                if (authorized != null) {
                    result = new MultiplexingURLStreamHandler(protocol, this, authorized);
                }
            } else {
                result = this.createInternalURLStreamHandler(protocol);
            }
            if (result == null && this.parentFactory != null) {
                result = this.parentFactory.createURLStreamHandler(protocol);
            }
            URLStreamHandler uRLStreamHandler = result;
            return uRLStreamHandler;
        }
        catch (Throwable t) {
            this.container.getLogServices().log(URLStreamHandlerFactoryImpl.class.getName(), 4, "Unexpected error in factory.", t);
            return null;
        }
        finally {
            this.releaseRecursive(protocol);
        }
    }

    private boolean isRecursive(String protocol) {
        List<String> protocols = this.creatingProtocols.get();
        if (protocols == null) {
            protocols = new ArrayList<String>(1);
            this.creatingProtocols.set(protocols);
        }
        if (protocols.contains(protocol)) {
            return true;
        }
        protocols.add(protocol);
        return false;
    }

    private void releaseRecursive(String protocol) {
        List<String> protocols = this.creatingProtocols.get();
        protocols.remove(protocol);
    }

    private URLStreamHandler getFrameworkHandler(String protocol) {
        if ("bundleentry".equals(protocol)) {
            return new org.eclipse.osgi.storage.url.bundleentry.Handler(this.container.getStorage().getModuleContainer(), null);
        }
        if ("bundleresource".equals(protocol)) {
            return new org.eclipse.osgi.storage.url.bundleresource.Handler(this.container.getStorage().getModuleContainer(), null);
        }
        if (PROTOCOL_REFERENCE.equals(protocol)) {
            return new Handler(this.container.getConfiguration().getConfiguration("osgi.install.area"));
        }
        return null;
    }

    public URLStreamHandler createInternalURLStreamHandler(String protocol) {
        URLStreamHandler frameworkHandler = this.getFrameworkHandler(protocol);
        if (frameworkHandler != null) {
            return frameworkHandler;
        }
        URLStreamHandlerProxy handler = this.proxies.computeIfAbsent(protocol, p -> new URLStreamHandlerProxy((String)p, this.context));
        if (handler.isActive()) {
            return handler;
        }
        return null;
    }

    protected URLStreamHandler findAuthorizedURLStreamHandler(String protocol) {
        Object factory = this.findAuthorizedFactory(ignoredClasses);
        if (factory == null) {
            return null;
        }
        if (factory == this) {
            return this.createInternalURLStreamHandler(protocol);
        }
        try {
            Method createInternalURLStreamHandlerMethod = factory.getClass().getMethod("createInternalURLStreamHandler", String.class);
            return (URLStreamHandler)createInternalURLStreamHandlerMethod.invoke(factory, protocol);
        }
        catch (Exception e) {
            this.container.getLogServices().log(URLStreamHandlerFactoryImpl.class.getName(), 4, "findAuthorizedURLStreamHandler-loop", e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Object getParentFactory() {
        return this.parentFactory;
    }

    @Override
    public void setParentFactory(Object parentFactory) {
        if (this.parentFactory == null) {
            this.parentFactory = (URLStreamHandlerFactory)parentFactory;
        }
    }
}

