/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Activator;
import org.eclipse.userstorage.internal.oauth.AuthToken;
import org.eclipse.userstorage.internal.oauth.OAuthCredentialsPersistence;
import org.eclipse.userstorage.internal.oauth.UIFacade;
import org.eclipse.userstorage.internal.oauth.ui.SWTInternalBrowserFacade;
import org.eclipse.userstorage.internal.util.AES;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.JSONUtil;
import org.eclipse.userstorage.internal.util.ProxyUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.oauth.OAuthCredentialsProvider;
import org.eclipse.userstorage.oauth.OAuthParameters;
import org.eclipse.userstorage.spi.Credentials;

public final class EclipseOAuthCredentialsProvider
extends OAuthCredentialsProvider {
    private static final String CONSENT_REQUIRED_ERROR_ID = "consent_required";
    private static final String AUTHORIZATION = "Authorization";
    private static final boolean DEBUG = Boolean.getBoolean("org.eclipse.userstorage.session.debug");
    private static final String PLUGIN_ID = "org.eclipse.userstorage.oauth";
    private OAuthCredentialsPersistence persister = OAuthCredentialsPersistence.standard();
    UIFacade uiFacade = new SWTInternalBrowserFacade();
    private boolean interactive = true;

    private static void debug(String message) {
        if (DEBUG) {
            System.out.println("<EclipseOAuthCredentialsProvider> " + message);
        }
    }

    private static void log(int statusCode, String message, Throwable exception) {
        Activator.log((IStatus)new Status(statusCode, PLUGIN_ID, message, exception));
    }

    public EclipseOAuthCredentialsProvider(String clientId, String clientSecret, String[] scopes, URI expectedCallback) throws URISyntaxException {
        this(null, clientId, clientSecret, scopes, expectedCallback);
    }

    public EclipseOAuthCredentialsProvider(URI authService, String clientId, String clientSecret, String[] scopes, URI expectedCallback) {
        super(authService, clientId, clientSecret, scopes, expectedCallback);
    }

    public EclipseOAuthCredentialsProvider(OAuthParameters parameters) {
        super(parameters);
    }

    public void setShell(IShellProvider provider) {
        if (this.uiFacade instanceof SWTInternalBrowserFacade) {
            ((SWTInternalBrowserFacade)this.uiFacade).setShell(provider);
        }
    }

    public Credentials provideCredentials(IStorageService service, boolean reauthentication) {
        AuthToken authToken;
        block13: {
            URI authCodeURI;
            block11: {
                block12: {
                    block10: {
                        block9: {
                            AuthToken authToken2;
                            if (!reauthentication && (authToken2 = this.refreshAuthToken(service)) != null) {
                                EclipseOAuthCredentialsProvider.debug("Returning cached credentials");
                                return this.asCredentials(service, authToken2);
                            }
                            if (this.isInteractive()) break block9;
                            EclipseOAuthCredentialsProvider.debug("Non-interactive login process failed");
                            return null;
                        }
                        EclipseOAuthCredentialsProvider.debug("Starting OAuth authorization process");
                        String providerName = service.getServiceLabel();
                        URI authURI = this.getAuthorizationURI(service);
                        URI callbackURI = this.getRegisteredCallback();
                        authCodeURI = this.uiFacade.obtainAuthCode(providerName, authURI, callbackURI);
                        if (authCodeURI != null) break block10;
                        EclipseOAuthCredentialsProvider.debug("User Cancelled login process");
                        return null;
                    }
                    List params = new URIBuilder(authCodeURI).getQueryParams();
                    String errorValue = this.findValue(params, "error");
                    if (errorValue == null) break block11;
                    if (!CONSENT_REQUIRED_ERROR_ID.equals(errorValue)) break block12;
                    EclipseOAuthCredentialsProvider.debug("User cancelled authorization");
                    return null;
                }
                EclipseOAuthCredentialsProvider.debug("Remote reported OAuth Error: " + authCodeURI.getRawQuery());
                this.uiFacade.showError("OAuth Error", "An error occurred retrieving during the authorization process.", (IStatus)new Status(4, PLUGIN_ID, "Error returned: " + authCodeURI.getRawQuery()));
                return null;
            }
            EclipseOAuthCredentialsProvider.debug("Login success: retrieving access token...");
            authToken = this.requestAuthToken(service, authCodeURI);
            if (authToken != null) break block13;
            EclipseOAuthCredentialsProvider.debug("Failed to turn Access Code -> Auth Token");
            this.uiFacade.showError("OAuth Error", "Unable to retrieve Authorization Code", (IStatus)new Status(4, PLUGIN_ID, "Unable to turn authorization code to an authoriation token"));
            return null;
        }
        try {
            return this.asCredentials(service, authToken);
        }
        catch (IOException ex) {
            EclipseOAuthCredentialsProvider.log(2, "Unable to fetch credential", ex);
            return null;
        }
        catch (URISyntaxException ex) {
            EclipseOAuthCredentialsProvider.log(2, "Invalid parameters", ex);
            return null;
        }
    }

    private String findValue(List<NameValuePair> queryParameters, String key) {
        for (NameValuePair pair : queryParameters) {
            if (!key.equals(pair.getName())) continue;
            return pair.getValue();
        }
        return null;
    }

    public Request configureRequest(Request request, URI uri, Credentials credentials) {
        AuthToken token = AuthToken.deserialize(credentials.getPassword());
        return request.addHeader(AUTHORIZATION, String.valueOf(token.getTokenType()) + " " + token.getAccessToken());
    }

    public boolean isValid(Credentials credentials) {
        if (!super.isValid(credentials)) {
            return false;
        }
        try {
            AuthToken token = AuthToken.deserialize(credentials.getPassword());
            return token != null && !token.isExpired() && this.hasRequiredScopes(token.getScopes());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean hasRequiredScopes(Set<String> authorizedScopes) {
        String[] stringArray = this.getScopes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scope = stringArray[n2];
            if (!authorizedScopes.contains(scope)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Credentials getCredentials(IStorageService service) {
        AuthToken authToken = this.retrieveStoredAuthToken(service);
        if (authToken == null || authToken.isExpired()) {
            return null;
        }
        return this.asCredentials(service, authToken);
    }

    public boolean hasCredentials(IStorageService service) {
        AuthToken authToken = this.retrieveStoredAuthToken(service);
        return authToken != null && !authToken.isExpired();
    }

    private AuthToken requestAuthToken(IStorageService service, URI uri) throws URISyntaxException, IOException {
        Pattern codePattern = Pattern.compile(".*[?&]code=([^&]+).*");
        Matcher m = codePattern.matcher(uri.toASCIIString());
        if (!m.matches()) {
            EclipseOAuthCredentialsProvider.debug("OAuth Access Code URI doesn't have an access code!");
            return null;
        }
        String accessCode = m.group(1);
        URI authorizationURI = new URIBuilder(this.getAuthorizationServiceBaseURI(service)).setPath("/oauth2/token").build();
        Request request = Request.Post((URI)authorizationURI).bodyForm(new NameValuePair[]{new BasicNameValuePair("grant_type", "authorization_code"), new BasicNameValuePair("client_id", this.getClientId()), new BasicNameValuePair("client_secret", this.getClientSecret()), new BasicNameValuePair("redirect_uri", this.getRegisteredCallback().toASCIIString()), new BasicNameValuePair("code", accessCode)});
        Response result = ProxyUtil.proxyAuthentication((Executor)this.executor, (URI)authorizationURI).execute(request);
        HttpResponse response = result.returnResponse();
        if (response.getStatusLine().getStatusCode() != 200) {
            EclipseOAuthCredentialsProvider.log(4, "Authorization/authentication failed: " + response, null);
            return null;
        }
        String jsonRep = EntityUtils.toString((HttpEntity)response.getEntity());
        Date date = DateUtils.parseDate((String)response.getFirstHeader("Date").getValue());
        AuthToken authToken = new AuthToken(jsonRep, date);
        String email = this.retrieveUserDetails(service, authToken);
        this.persistAuthToken(service, authToken, email);
        return authToken;
    }

    private String retrieveUserDetails(IStorageService service, AuthToken token) {
        HttpResponse response;
        block7: {
            if (!this.contains(this.getScopes(), "profile")) {
                return null;
            }
            URI refreshURI = new URIBuilder(service.getServiceURI()).setPath("/account/profile").build();
            Request request = Request.Get((URI)refreshURI).addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType()).addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).addHeader("User-Agent", "uss/1.0.0").addHeader(AUTHORIZATION, String.valueOf(token.getTokenType()) + " " + token.getAccessToken());
            Response result = ProxyUtil.proxyAuthentication((Executor)this.executor, (URI)refreshURI).execute(request);
            response = result.returnResponse();
            if (response.getStatusLine().getStatusCode() == 200) break block7;
            return null;
        }
        try {
            String jsonRep = EntityUtils.toString((HttpEntity)response.getEntity());
            Object o = JSONUtil.parse((InputStream)IOUtil.streamUTF((String)jsonRep), null);
            if (!(o instanceof List) || !(((List)o).get(0) instanceof Map)) {
                throw new IllegalArgumentException("not a valid profile object");
            }
            return (String)((Map)((List)o).get(0)).get("mail");
        }
        catch (URISyntaxException ex) {
            EclipseOAuthCredentialsProvider.log(2, "Unable to construct remote URI", ex);
        }
        catch (ClientProtocolException ex) {
            EclipseOAuthCredentialsProvider.log(2, "Unable to request user profile information", ex);
        }
        catch (IOException ex) {
            EclipseOAuthCredentialsProvider.log(2, "Unable to parse user profile information", ex);
        }
        return null;
    }

    private boolean contains(String[] scopes, String scope) {
        String[] stringArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(scope)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AuthToken refreshAuthToken(IStorageService service) {
        HttpResponse response;
        AuthToken authToken;
        block6: {
            authToken = this.retrieveStoredAuthToken(service);
            if (authToken == null) {
                return null;
            }
            if (authToken.getRefreshToken() == null) {
                this.discardStoredAuthToken(service);
                return null;
            }
            URI refreshURI = new URIBuilder(this.getAuthorizationServiceBaseURI(service)).setPath("/oauth2/token").build();
            Request request = Request.Post((URI)refreshURI).bodyForm(new NameValuePair[]{new BasicNameValuePair("grant_type", "refresh_token"), new BasicNameValuePair("refresh_token", authToken.getRefreshToken()), new BasicNameValuePair("client_id", this.getClientId()), new BasicNameValuePair("client_secret", this.getClientSecret())});
            Response result = ProxyUtil.proxyAuthentication((Executor)this.executor, (URI)refreshURI).execute(request);
            response = result.returnResponse();
            if (response.getStatusLine().getStatusCode() == 200) break block6;
            EclipseOAuthCredentialsProvider.log(2, "Authorization/authentication failed when refreshing auth token: " + response, null);
            this.discardStoredAuthToken(service);
            return null;
        }
        try {
            String jsonRep = EntityUtils.toString((HttpEntity)response.getEntity());
            Date date = DateUtils.parseDate((String)response.getFirstHeader("Date").getValue());
            authToken = new AuthToken(jsonRep, date);
            String email = this.retrieveUserDetails(service, authToken);
            this.persistAuthToken(service, authToken, email);
            return authToken;
        }
        catch (IOException ex) {
            EclipseOAuthCredentialsProvider.log(4, "Unparseable response", ex);
            return null;
        }
        catch (URISyntaxException ex) {
            EclipseOAuthCredentialsProvider.log(4, "Invalid URI", ex);
            return null;
        }
    }

    private AuthToken retrieveStoredAuthToken(IStorageService service) {
        String encryptedForm;
        block4: {
            encryptedForm = this.persister.getAccountToken(this.getClientId(), this.getAuthorizationServiceBaseURI(service).toString());
            if (encryptedForm != null) break block4;
            return null;
        }
        try {
            String serializedForm = AES.decrypt((String)encryptedForm, (char[])this.getClientSecretAsChars());
            return AuthToken.deserialize(serializedForm);
        }
        catch (IllegalArgumentException e) {
            EclipseOAuthCredentialsProvider.log(2, "Unable to deserialize stored token", e);
            return null;
        }
        catch (GeneralSecurityException e) {
            EclipseOAuthCredentialsProvider.log(2, "Unable to decrypt stored token", e);
            return null;
        }
    }

    private void discardStoredAuthToken(IStorageService service) {
        this.persister.removeAccountToken(this.getClientId(), this.getAuthorizationServiceBaseURI(service).toString());
    }

    private void persistAuthToken(IStorageService service, AuthToken authToken, String email) {
        try {
            String serializedForm = authToken.serialize();
            String encryptedForm = AES.encrypt((String)serializedForm, (char[])this.getClientSecretAsChars());
            this.persister.putAccountToken(this.getClientId(), this.getAuthorizationServiceBaseURI(service).toString(), encryptedForm, email);
        }
        catch (GeneralSecurityException e) {
            EclipseOAuthCredentialsProvider.log(4, "Unable to encrypt auth token for storage", e);
        }
        catch (IOException e) {
            EclipseOAuthCredentialsProvider.log(4, "Unable to serialize auth token for storage", e);
        }
    }

    private Credentials asCredentials(IStorageService service, AuthToken authToken) {
        try {
            return new Credentials(service.getServiceURI() + "|" + this.getClientId(), authToken.serialize());
        }
        catch (IOException e) {
            EclipseOAuthCredentialsProvider.log(2, "Unable to serialize auth token", e);
            return null;
        }
    }

    protected URI getAuthorizationURI(IStorageService service) throws URISyntaxException {
        return new URIBuilder(this.getAuthorizationServiceBaseURI(service)).setPath("/oauth2/authorize").addParameter("response_type", "code").addParameter("client_id", this.getClientId()).addParameter("client_secret", this.getClientSecret()).addParameter("scope", StringUtil.join((String)" ", (String[])this.getScopes())).addParameter("redirect_uri", this.getRegisteredCallback().toASCIIString()).addParameter("state", this.stateCode).build();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }
}

