/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IEclipseContextDebugger;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.osgi.service.component.annotations.Component;

@Component
public class ContextListener
implements IEclipseContextDebugger {
    public void notify(EclipseContext context, IEclipseContextDebugger.EventType type, Object data) {
        if (!Policy.DEBUG_CONTEXTS) {
            return;
        }
        Object msg = context.toString();
        if ("Anonymous Context".equals(msg)) {
            return;
        }
        msg = String.valueOf(type) + " : " + this.describe((IEclipseContext)context);
        WorkbenchSWTActivator.trace("/trace/eclipse.context", (String)msg, null);
    }

    private String describe(IEclipseContext context) {
        StringBuilder sb = new StringBuilder();
        IEclipseContext activeContext = context;
        IEclipseContext parent = context.getParent();
        while (parent != null) {
            sb.append(activeContext).append(" <- ");
            activeContext = parent;
            parent = parent.getParent();
        }
        sb.append(activeContext);
        return sb.toString();
    }
}

