/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.tools.comparator.IArtifactComparator;
import org.eclipse.osgi.util.NLS;

public final class ArtifactChecksumComparator
implements IArtifactComparator {
    public static final String COMPARATOR_ID = "org.eclipse.equinox.artifact.comparator.checksum";
    private final String name;
    private final String id;

    public ArtifactChecksumComparator(String checksumId, String checksumName) {
        this.name = checksumName;
        this.id = checksumId;
    }

    @Override
    public final IStatus compare(IArtifactRepository source, IArtifactDescriptor sourceDescriptor, IArtifactRepository destination, IArtifactDescriptor destDescriptor) {
        String sourceChecksum = (String)ChecksumHelper.getChecksums((IArtifactDescriptor)sourceDescriptor, (String)"download.checksum").get(this.id);
        String destChecksum = (String)ChecksumHelper.getChecksums((IArtifactDescriptor)destDescriptor, (String)"download.checksum").get(this.id);
        if (sourceChecksum == null && destChecksum == null) {
            return new Status(1, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.info_noChecksumInfomation, (Object)this.name, (Object)sourceDescriptor));
        }
        if (sourceChecksum == null) {
            return new Status(1, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.info_noChecksumInRepository, (Object[])new Object[]{source, this.name, sourceDescriptor}));
        }
        if (destChecksum == null) {
            return new Status(1, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.info_noChecksumInRepository, (Object[])new Object[]{destination, this.name, destDescriptor}));
        }
        if (sourceChecksum.equals(destChecksum)) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.warning_different_checksum, (Object[])new Object[]{URIUtil.toUnencodedString((URI)sourceDescriptor.getRepository().getLocation()), URIUtil.toUnencodedString((URI)destDescriptor.getRepository().getLocation()), this.name, sourceDescriptor}));
    }
}

