/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.UCaseProps;
import com.ibm.icu.util.ULocale;

public final class CaseMap {
    private static final void appendResult(int c, StringBuilder result) {
        if (c < 0) {
            result.appendCodePoint(~c);
        } else if (c > 31) {
            result.appendCodePoint(c);
        }
    }

    public static String toUpper(ULocale locale, String str) {
        int c;
        int[] locCache;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((locCache = new int[]{UCaseProps.getCaseLocale(locale, null)})[0] == 4) {
            return GreekUpper.toUpper(str, locCache);
        }
        StringContextIterator iter = new StringContextIterator(str);
        StringBuilder result = new StringBuilder(str.length());
        while ((c = iter.nextCaseMapCP()) >= 0) {
            c = UCaseProps.INSTANCE.toFullUpper(c, iter, result, locale, locCache);
            CaseMap.appendResult(c, result);
        }
        return result.toString();
    }

    private static final class GreekUpper {
        private static final int UPPER_MASK = 1023;
        private static final int HAS_VOWEL = 4096;
        private static final int HAS_YPOGEGRAMMENI = 8192;
        private static final int HAS_ACCENT = 16384;
        private static final int HAS_DIALYTIKA = 32768;
        private static final int HAS_COMBINING_DIALYTIKA = 65536;
        private static final int HAS_OTHER_GREEK_DIACRITIC = 131072;
        private static final int HAS_VOWEL_AND_ACCENT = 20480;
        private static final int HAS_VOWEL_AND_ACCENT_AND_DIALYTIKA = 53248;
        private static final int HAS_EITHER_DIALYTIKA = 98304;
        private static final int AFTER_CASED = 1;
        private static final int AFTER_VOWEL_WITH_ACCENT = 2;
        private static final char[] data0370;
        private static final char[] data1F00;
        private static final char data2126 = '\u13a9';

        static {
            char[] cArray = new char[144];
            cArray[0] = 880;
            cArray[1] = 880;
            cArray[2] = 882;
            cArray[3] = 882;
            cArray[6] = 886;
            cArray[7] = 886;
            cArray[10] = 890;
            cArray[11] = 1021;
            cArray[12] = 1022;
            cArray[13] = 1023;
            cArray[15] = 895;
            cArray[22] = 21393;
            cArray[24] = 21397;
            cArray[25] = 21399;
            cArray[26] = 21401;
            cArray[28] = 21407;
            cArray[30] = 21413;
            cArray[31] = 21417;
            cArray[32] = 54169;
            cArray[33] = 5009;
            cArray[34] = 914;
            cArray[35] = 915;
            cArray[36] = 916;
            cArray[37] = 5013;
            cArray[38] = 918;
            cArray[39] = 5015;
            cArray[40] = 920;
            cArray[41] = 5017;
            cArray[42] = 922;
            cArray[43] = 923;
            cArray[44] = 924;
            cArray[45] = 925;
            cArray[46] = 926;
            cArray[47] = 5023;
            cArray[48] = 928;
            cArray[49] = 929;
            cArray[51] = 931;
            cArray[52] = 932;
            cArray[53] = 5029;
            cArray[54] = 934;
            cArray[55] = 935;
            cArray[56] = 936;
            cArray[57] = 5033;
            cArray[58] = 37785;
            cArray[59] = 37797;
            cArray[60] = 21393;
            cArray[61] = 21397;
            cArray[62] = 21399;
            cArray[63] = 21401;
            cArray[64] = 54181;
            cArray[65] = 5009;
            cArray[66] = 914;
            cArray[67] = 915;
            cArray[68] = 916;
            cArray[69] = 5013;
            cArray[70] = 918;
            cArray[71] = 5015;
            cArray[72] = 920;
            cArray[73] = 5017;
            cArray[74] = 922;
            cArray[75] = 923;
            cArray[76] = 924;
            cArray[77] = 925;
            cArray[78] = 926;
            cArray[79] = 5023;
            cArray[80] = 928;
            cArray[81] = 929;
            cArray[82] = 931;
            cArray[83] = 931;
            cArray[84] = 932;
            cArray[85] = 5029;
            cArray[86] = 934;
            cArray[87] = 935;
            cArray[88] = 936;
            cArray[89] = 5033;
            cArray[90] = 37785;
            cArray[91] = 37797;
            cArray[92] = 21407;
            cArray[93] = 21413;
            cArray[94] = 21417;
            cArray[95] = 975;
            cArray[96] = 914;
            cArray[97] = 920;
            cArray[98] = 978;
            cArray[99] = 17362;
            cArray[100] = 33746;
            cArray[101] = 934;
            cArray[102] = 928;
            cArray[103] = 975;
            cArray[104] = 984;
            cArray[105] = 984;
            cArray[106] = 986;
            cArray[107] = 986;
            cArray[108] = 988;
            cArray[109] = 988;
            cArray[110] = 990;
            cArray[111] = 990;
            cArray[112] = 992;
            cArray[113] = 992;
            cArray[128] = 922;
            cArray[129] = 929;
            cArray[130] = 1017;
            cArray[131] = 895;
            cArray[132] = 1012;
            cArray[133] = 5013;
            cArray[135] = 1015;
            cArray[136] = 1015;
            cArray[137] = 1017;
            cArray[138] = 1018;
            cArray[139] = 1018;
            cArray[140] = 1020;
            cArray[141] = 1021;
            cArray[142] = 1022;
            cArray[143] = 1023;
            data0370 = cArray;
            char[] cArray2 = new char[256];
            cArray2[0] = 5009;
            cArray2[1] = 5009;
            cArray2[2] = 21393;
            cArray2[3] = 21393;
            cArray2[4] = 21393;
            cArray2[5] = 21393;
            cArray2[6] = 21393;
            cArray2[7] = 21393;
            cArray2[8] = 5009;
            cArray2[9] = 5009;
            cArray2[10] = 21393;
            cArray2[11] = 21393;
            cArray2[12] = 21393;
            cArray2[13] = 21393;
            cArray2[14] = 21393;
            cArray2[15] = 21393;
            cArray2[16] = 5013;
            cArray2[17] = 5013;
            cArray2[18] = 21397;
            cArray2[19] = 21397;
            cArray2[20] = 21397;
            cArray2[21] = 21397;
            cArray2[24] = 5013;
            cArray2[25] = 5013;
            cArray2[26] = 21397;
            cArray2[27] = 21397;
            cArray2[28] = 21397;
            cArray2[29] = 21397;
            cArray2[32] = 5015;
            cArray2[33] = 5015;
            cArray2[34] = 21399;
            cArray2[35] = 21399;
            cArray2[36] = 21399;
            cArray2[37] = 21399;
            cArray2[38] = 21399;
            cArray2[39] = 21399;
            cArray2[40] = 5015;
            cArray2[41] = 5015;
            cArray2[42] = 21399;
            cArray2[43] = 21399;
            cArray2[44] = 21399;
            cArray2[45] = 21399;
            cArray2[46] = 21399;
            cArray2[47] = 21399;
            cArray2[48] = 5017;
            cArray2[49] = 5017;
            cArray2[50] = 21401;
            cArray2[51] = 21401;
            cArray2[52] = 21401;
            cArray2[53] = 21401;
            cArray2[54] = 21401;
            cArray2[55] = 21401;
            cArray2[56] = 5017;
            cArray2[57] = 5017;
            cArray2[58] = 21401;
            cArray2[59] = 21401;
            cArray2[60] = 21401;
            cArray2[61] = 21401;
            cArray2[62] = 21401;
            cArray2[63] = 21401;
            cArray2[64] = 5023;
            cArray2[65] = 5023;
            cArray2[66] = 21407;
            cArray2[67] = 21407;
            cArray2[68] = 21407;
            cArray2[69] = 21407;
            cArray2[72] = 5023;
            cArray2[73] = 5023;
            cArray2[74] = 21407;
            cArray2[75] = 21407;
            cArray2[76] = 21407;
            cArray2[77] = 21407;
            cArray2[80] = 5029;
            cArray2[81] = 5029;
            cArray2[82] = 21413;
            cArray2[83] = 21413;
            cArray2[84] = 21413;
            cArray2[85] = 21413;
            cArray2[86] = 21413;
            cArray2[87] = 21413;
            cArray2[89] = 5029;
            cArray2[91] = 21413;
            cArray2[93] = 21413;
            cArray2[95] = 21413;
            cArray2[96] = 5033;
            cArray2[97] = 5033;
            cArray2[98] = 21417;
            cArray2[99] = 21417;
            cArray2[100] = 21417;
            cArray2[101] = 21417;
            cArray2[102] = 21417;
            cArray2[103] = 21417;
            cArray2[104] = 5033;
            cArray2[105] = 5033;
            cArray2[106] = 21417;
            cArray2[107] = 21417;
            cArray2[108] = 21417;
            cArray2[109] = 21417;
            cArray2[110] = 21417;
            cArray2[111] = 21417;
            cArray2[112] = 21393;
            cArray2[113] = 21393;
            cArray2[114] = 21397;
            cArray2[115] = 21397;
            cArray2[116] = 21399;
            cArray2[117] = 21399;
            cArray2[118] = 21401;
            cArray2[119] = 21401;
            cArray2[120] = 21407;
            cArray2[121] = 21407;
            cArray2[122] = 21413;
            cArray2[123] = 21413;
            cArray2[124] = 21417;
            cArray2[125] = 21417;
            cArray2[128] = 13201;
            cArray2[129] = 13201;
            cArray2[130] = 29585;
            cArray2[131] = 29585;
            cArray2[132] = 29585;
            cArray2[133] = 29585;
            cArray2[134] = 29585;
            cArray2[135] = 29585;
            cArray2[136] = 13201;
            cArray2[137] = 13201;
            cArray2[138] = 29585;
            cArray2[139] = 29585;
            cArray2[140] = 29585;
            cArray2[141] = 29585;
            cArray2[142] = 29585;
            cArray2[143] = 29585;
            cArray2[144] = 13207;
            cArray2[145] = 13207;
            cArray2[146] = 29591;
            cArray2[147] = 29591;
            cArray2[148] = 29591;
            cArray2[149] = 29591;
            cArray2[150] = 29591;
            cArray2[151] = 29591;
            cArray2[152] = 13207;
            cArray2[153] = 13207;
            cArray2[154] = 29591;
            cArray2[155] = 29591;
            cArray2[156] = 29591;
            cArray2[157] = 29591;
            cArray2[158] = 29591;
            cArray2[159] = 29591;
            cArray2[160] = 13225;
            cArray2[161] = 13225;
            cArray2[162] = 29609;
            cArray2[163] = 29609;
            cArray2[164] = 29609;
            cArray2[165] = 29609;
            cArray2[166] = 29609;
            cArray2[167] = 29609;
            cArray2[168] = 13225;
            cArray2[169] = 13225;
            cArray2[170] = 29609;
            cArray2[171] = 29609;
            cArray2[172] = 29609;
            cArray2[173] = 29609;
            cArray2[174] = 29609;
            cArray2[175] = 29609;
            cArray2[176] = 5009;
            cArray2[177] = 5009;
            cArray2[178] = 29585;
            cArray2[179] = 13201;
            cArray2[180] = 29585;
            cArray2[182] = 21393;
            cArray2[183] = 29585;
            cArray2[184] = 5009;
            cArray2[185] = 5009;
            cArray2[186] = 21393;
            cArray2[187] = 21393;
            cArray2[188] = 13201;
            cArray2[190] = 5017;
            cArray2[194] = 29591;
            cArray2[195] = 13207;
            cArray2[196] = 29591;
            cArray2[198] = 21399;
            cArray2[199] = 29591;
            cArray2[200] = 21397;
            cArray2[201] = 21397;
            cArray2[202] = 21399;
            cArray2[203] = 21399;
            cArray2[204] = 13207;
            cArray2[208] = 5017;
            cArray2[209] = 5017;
            cArray2[210] = 54169;
            cArray2[211] = 54169;
            cArray2[214] = 21401;
            cArray2[215] = 54169;
            cArray2[216] = 5017;
            cArray2[217] = 5017;
            cArray2[218] = 21401;
            cArray2[219] = 21401;
            cArray2[224] = 5029;
            cArray2[225] = 5029;
            cArray2[226] = 54181;
            cArray2[227] = 54181;
            cArray2[228] = 929;
            cArray2[229] = 929;
            cArray2[230] = 21413;
            cArray2[231] = 54181;
            cArray2[232] = 5029;
            cArray2[233] = 5029;
            cArray2[234] = 21413;
            cArray2[235] = 21413;
            cArray2[236] = 929;
            cArray2[242] = 29609;
            cArray2[243] = 13225;
            cArray2[244] = 29609;
            cArray2[246] = 21417;
            cArray2[247] = 29609;
            cArray2[248] = 21407;
            cArray2[249] = 21407;
            cArray2[250] = 21417;
            cArray2[251] = 21417;
            cArray2[252] = 13225;
            data1F00 = cArray2;
        }

        private GreekUpper() {
        }

        private static final int getLetterData(int c) {
            if (c < 880 || 8486 < c || 1023 < c && c < 7936) {
                return 0;
            }
            if (c <= 1023) {
                return data0370[c - 880];
            }
            if (c <= 8191) {
                return data1F00[c - 7936];
            }
            if (c == 8486) {
                return 5033;
            }
            return 0;
        }

        private static final int getDiacriticData(int c) {
            switch (c) {
                case 768: 
                case 769: 
                case 770: 
                case 771: 
                case 785: 
                case 834: {
                    return 16384;
                }
                case 776: {
                    return 65536;
                }
                case 836: {
                    return 81920;
                }
                case 837: {
                    return 8192;
                }
                case 772: 
                case 774: 
                case 787: 
                case 788: 
                case 835: {
                    return 131072;
                }
            }
            return 0;
        }

        private static boolean isFollowedByCasedLetter(CharSequence s, int i) {
            while (i < s.length()) {
                int c = Character.codePointAt(s, i);
                int type = UCaseProps.INSTANCE.getTypeOrIgnorable(c);
                if ((type & 4) != 0) continue;
                return type != 0;
            }
            return false;
        }

        private static String toUpper(CharSequence s, int[] locCache) {
            StringBuilder result = new StringBuilder(s.length());
            int state = 0;
            int i = 0;
            while (i < s.length()) {
                int c = Character.codePointAt(s, i);
                int nextIndex = i + Character.charCount(c);
                int nextState = 0;
                int type = UCaseProps.INSTANCE.getTypeOrIgnorable(c);
                if ((type & 4) != 0) {
                    nextState |= state & true;
                } else if (type != 0) {
                    nextState |= 1;
                }
                int data = GreekUpper.getLetterData(c);
                if (data > 0) {
                    int upper = data & 0x3FF;
                    if ((data & 0x1000) != 0 && (state & 2) != 0 && (upper == 921 || upper == 933)) {
                        data |= 0x8000;
                    }
                    int numYpogegrammeni = 0;
                    if ((data & 0x2000) != 0) {
                        numYpogegrammeni = 1;
                    }
                    while (nextIndex < s.length()) {
                        int diacriticData = GreekUpper.getDiacriticData(s.charAt(nextIndex));
                        if (diacriticData == 0) break;
                        data |= diacriticData;
                        if ((diacriticData & 0x2000) != 0) {
                            ++numYpogegrammeni;
                        }
                        ++nextIndex;
                    }
                    if ((data & 0xD000) == 20480) {
                        nextState |= 2;
                    }
                    boolean addTonos = false;
                    if (upper == 919 && (data & 0x4000) != 0 && numYpogegrammeni == 0 && (state & 1) == 0 && !GreekUpper.isFollowedByCasedLetter(s, nextIndex)) {
                        if (i == nextIndex) {
                            upper = 905;
                        } else {
                            addTonos = true;
                        }
                    } else if ((data & 0x8000) != 0) {
                        if (upper == 921) {
                            upper = 938;
                            data &= 0xFFFE7FFF;
                        } else if (upper == 933) {
                            upper = 939;
                            data &= 0xFFFE7FFF;
                        }
                    }
                    result.appendCodePoint(upper);
                    if ((data & 0x18000) != 0) {
                        result.append('\u0308');
                    }
                    if (addTonos) {
                        result.append('\u0301');
                    }
                    while (numYpogegrammeni > 0) {
                        result.append('\u0399');
                        --numYpogegrammeni;
                    }
                } else {
                    c = UCaseProps.INSTANCE.toFullUpper(c, null, result, null, locCache);
                    CaseMap.appendResult(c, result);
                }
                i = nextIndex;
                state = nextState;
            }
            return result.toString();
        }
    }

    public static final class StringContextIterator
    implements UCaseProps.ContextIterator {
        protected String s;
        protected int index;
        protected int limit;
        protected int cpStart;
        protected int cpLimit;
        protected int dir;

        public StringContextIterator(String s) {
            this.s = s;
            this.limit = s.length();
            this.index = 0;
            this.cpLimit = 0;
            this.cpStart = 0;
            this.dir = 0;
        }

        public void setLimit(int lim) {
            this.limit = lim >= 0 && lim <= this.s.length() ? lim : this.s.length();
        }

        public void moveToLimit() {
            this.cpStart = this.cpLimit = this.limit;
        }

        public int nextCaseMapCP() {
            this.cpStart = this.cpLimit;
            if (this.cpLimit < this.limit) {
                int c = this.s.codePointAt(this.cpLimit);
                this.cpLimit += Character.charCount(c);
                return c;
            }
            return -1;
        }

        public int getCPStart() {
            return this.cpStart;
        }

        public int getCPLimit() {
            return this.cpLimit;
        }

        @Override
        public void reset(int direction) {
            if (direction > 0) {
                this.dir = 1;
                this.index = this.cpLimit;
            } else if (direction < 0) {
                this.dir = -1;
                this.index = this.cpStart;
            } else {
                this.dir = 0;
                this.index = 0;
            }
        }

        @Override
        public int next() {
            if (this.dir > 0 && this.index < this.s.length()) {
                int c = this.s.codePointAt(this.index);
                this.index += Character.charCount(c);
                return c;
            }
            if (this.dir < 0 && this.index > 0) {
                int c = this.s.codePointBefore(this.index);
                this.index -= Character.charCount(c);
                return c;
            }
            return -1;
        }
    }
}

