/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.passage.lic.base.BaseLicensingResult;
import org.eclipse.passage.lic.runtime.LicensingResult;

public class LicensingResults {
    public static LicensingResult createOK() {
        return new BaseLicensingResult(0, "", LicensingResults.class.getName());
    }

    public static LicensingResult createOK(String message) {
        return new BaseLicensingResult(0, message, LicensingResults.class.getName());
    }

    public static LicensingResult createOK(String message, String source) {
        return new BaseLicensingResult(0, message, source);
    }

    public static LicensingResult createEvent(String topic, Object data) {
        String source = LicensingResult.class.getName();
        return LicensingResults.createEvent(topic, data, source, "");
    }

    public static LicensingResult createEvent(String topic, Object data, String source, String message) {
        LicensingResult basis = LicensingResults.createOK(message, source);
        return LicensingResults.createEvent(topic, data, basis);
    }

    public static LicensingResult createEvent(String topic, Object data, LicensingResult basis) {
        int severity = basis.getSeverity();
        String message = basis.getMessage();
        int code = basis.getCode();
        String source = basis.getSource();
        Throwable exception = basis.getException();
        ArrayList<LicensingResult> details = new ArrayList<LicensingResult>();
        Iterable children = basis.getChildren();
        for (LicensingResult child : children) {
            details.add(child);
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>();
        Iterable attachmentKeys = basis.getAttachmentKeys();
        for (String key : attachmentKeys) {
            attachments.put(key, basis.getAttachment(key));
        }
        attachments.put("org.eclipse.passage.lic.runtime.topic", topic);
        attachments.put("org.eclipse.passage.lic.runtime.source", source);
        attachments.put("org.eclipse.passage.lic.runtime.data", data);
        attachments.put("org.eclipse.passage.lic.runtime.message", message);
        return new BaseLicensingResult(severity, message, code, source, exception, details, attachments);
    }

    public static LicensingResult createError(String message, String source) {
        return new BaseLicensingResult(4, message, 0, source, null);
    }

    public static LicensingResult createError(String message, String source, Throwable e) {
        return new BaseLicensingResult(4, message, 0, source, e);
    }

    public static LicensingResult createError(String message, String source, Iterable<LicensingResult> children) {
        return new BaseLicensingResult(4, message, 0, source, null, children, null);
    }

    public static LicensingResult createError(String message, int code, Throwable e) {
        String source = LicensingResults.class.getName();
        return new BaseLicensingResult(4, message, code, source, e);
    }

    public static LicensingResult createError(String message, int code, String source, Throwable e) {
        return new BaseLicensingResult(4, message, code, source, e);
    }
}

