/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.conditions.BaseLicensingCondition;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public class LicensingConditions {
    private static final String SEGMENT_SEPARATOR = ";";
    private static final String VALUE_SEPARATOR = "=";

    private LicensingConditions() {
    }

    public static Map<String, String> parseExpression(String expression) {
        String[] segments;
        HashMap<String, String> map = new HashMap<String, String>();
        if (expression == null) {
            return map;
        }
        String[] stringArray = segments = expression.split(SEGMENT_SEPARATOR);
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            String[] split = segment.split(VALUE_SEPARATOR);
            if (split.length == 2) {
                map.put(split[0], split[1]);
            }
            ++n2;
        }
        return map;
    }

    public static boolean evaluateSegmentValue(String expected, String actual) {
        if (actual == null) {
            return false;
        }
        String regexp = expected.replaceAll("\\*", ".*");
        return actual.matches(regexp);
    }

    public static LicensingCondition create(String identifier, String version, String rule, Date from, Date until, String type, String expression) {
        return new BaseLicensingCondition(identifier, version, rule, from, until, type, expression);
    }

    public static LicensingResult validate(LicensingCondition condition, String source) {
        Date validFrom = condition.getValidFrom();
        if (validFrom == null) {
            String format = BaseMessages.getString("LicensingConditions_validation_no_from");
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        Date now = new Date();
        if (validFrom.after(now)) {
            String format = BaseMessages.getString("LicensingConditions_validation_invalid_from");
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        Date validUntil = condition.getValidUntil();
        if (validUntil == null) {
            String format = BaseMessages.getString("LicensingConditions_validation_no_until");
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        if (validUntil.before(now)) {
            String format = BaseMessages.getString("LicensingConditions_validation_invalid_until");
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        return LicensingResults.createOK("", source);
    }
}

