/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.api.access.LicensingRequest;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.products.registry.ProductRegistry;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.registry.UserRegistry;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.licenses.ui.SelectLicensePlan;
import org.eclipse.passage.loc.internal.workbench.SelectRoot;
import org.eclipse.passage.loc.jface.dialogs.DateDialog;
import org.eclipse.passage.loc.products.ui.ProductsUi;
import org.eclipse.passage.loc.users.ui.UsersUi;
import org.eclipse.passage.loc.workbench.viewers.DomainRegistryLabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class IssueLicenseRequestPage
extends WizardPage {
    private final IEclipseContext context;
    private LicensePlanDescriptor licensePlanDescriptor;
    private UserDescriptor userDescriptor;
    private ProductVersionDescriptor productVersionDescriptor;
    private LocalDate validFrom;
    private LocalDate validUntil;
    private final ComposedAdapterFactoryProvider provider;
    private final LabelProvider labelProvider;

    protected IssueLicenseRequestPage(String pageName, IEclipseContext context) {
        super(pageName);
        this.context = context;
        this.provider = (ComposedAdapterFactoryProvider)context.get(ComposedAdapterFactoryProvider.class);
        this.labelProvider = new DomainRegistryLabelProvider((AdapterFactory)this.provider.getComposedAdapterFactory());
        this.setTitle(IssueLicensePageMessages.IssueLicenseRequestPage_page_title);
        this.setDescription(IssueLicensePageMessages.IssueLicenseRequestPage_page_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.setControl((Control)container);
        this.createLicenseBlock(container);
        this.createUserBlock(container);
        this.createProductBlock(container);
        this.createDatesBlock(container);
        this.setPageComplete(this.validatePage());
        Dialog.applyDialogFont((Control)container);
    }

    private void createLicenseBlock(Composite composite) {
        this.createTextButtonBlock(composite, IssueLicensePageMessages.IssueLicenseRequestPage_lbl_license_plan, t -> this.selectLicensePlan((Text)t), this.licensePlanDescriptor);
    }

    private void createUserBlock(Composite composite) {
        this.createTextButtonBlock(composite, IssueLicensePageMessages.IssueLicenseRequestPage_lbl_user, t -> this.selectUser((Text)t), this.userDescriptor);
    }

    private void createProductBlock(Composite composite) {
        this.createTextButtonBlock(composite, IssueLicensePageMessages.IssueLicenseRequestPage_lbl_product_version, t -> this.selectProductVersion((Text)t), this.productVersionDescriptor);
    }

    private void createDatesBlock(Composite composite) {
        this.createTextButtonBlock(composite, IssueLicensePageMessages.IssueLicenseRequestPage_lbl_valid_from, t -> this.selectFromDate((Text)t), this.validFrom);
        this.createTextButtonBlock(composite, IssueLicensePageMessages.IssueLicenseRequestPage_lbl_valid_until, t -> this.selectUntilDate((Text)t), this.validUntil);
    }

    private void createTextButtonBlock(Composite composite, String labelText, Function<Text, String> s, Object initial) {
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Text text = new Text(composite, 8);
        text.setData(initial);
        text.addModifyListener(m -> this.setPageComplete(this.validatePage()));
        text.setText(this.labelProvider.getText(initial));
        text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Button select = new Button(composite, 8);
        select.setText(IssueLicensePageMessages.IssueLicenseRequestPage_btn_select_text);
        select.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> text.setText((String)s.apply(text))));
        select.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    private String selectLicensePlan(Text text) {
        Object data = text.getData();
        ArrayList<LicensePlanDescriptor> initial = new ArrayList<LicensePlanDescriptor>();
        if (data instanceof LicensePlanDescriptor) {
            initial.add((LicensePlanDescriptor)data);
        }
        LicensePlanDescriptor selected = new SelectRoot(new SelectLicensePlan(this.context).get(), this.context).get().orElse(null);
        text.setData((Object)selected);
        this.licensePlanDescriptor = selected;
        return this.labelProvider.getText((Object)selected);
    }

    private String selectUser(Text text) {
        Object data = text.getData();
        UserDescriptor initial = null;
        if (data instanceof UserDescriptor) {
            initial = (UserDescriptor)data;
        }
        UserRegistry registry = (UserRegistry)this.context.get(UserRegistry.class);
        UserDescriptor selected = UsersUi.selectUserDescriptor((Shell)this.getShell(), (ComposedAdapterFactoryProvider)this.provider, (UserRegistry)registry, (UserDescriptor)initial);
        text.setData((Object)selected);
        this.userDescriptor = selected;
        return this.labelProvider.getText((Object)selected);
    }

    private String selectProductVersion(Text text) {
        Object data = text.getData();
        ProductVersionDescriptor initial = null;
        if (data instanceof ProductVersionDescriptor) {
            initial = (ProductVersionDescriptor)data;
        }
        ProductRegistry registry = (ProductRegistry)this.context.get(ProductRegistry.class);
        ProductVersionDescriptor selected = ProductsUi.selectProductVersionDescriptor((Shell)this.getShell(), (ComposedAdapterFactoryProvider)this.provider, (ProductRegistry)registry, (ProductVersionDescriptor)initial);
        text.setData((Object)selected);
        this.productVersionDescriptor = selected;
        return this.labelProvider.getText((Object)selected);
    }

    private String selectFromDate(Text text) {
        LocalDate selected;
        this.validFrom = selected = this.selectDate(text, this.validFrom, IssueLicensePageMessages.IssueLicenseRequestPage_valid_from_title);
        return selected.toString();
    }

    private String selectUntilDate(Text text) {
        LocalDate selected;
        this.validUntil = selected = this.selectDate(text, this.validUntil, IssueLicensePageMessages.IssueLicenseRequestPage_valid_until_title);
        return selected.toString();
    }

    private LocalDate selectDate(Text text, LocalDate initial, String title) {
        LocalDate current = initial;
        Object data = text.getData();
        if (data instanceof LocalDate) {
            current = (LocalDate)data;
        }
        DateDialog dialog = new DateDialog(this.getShell(), current);
        dialog.create();
        dialog.getShell().setText(title);
        if (dialog.open() == 0) {
            current = dialog.getSelected();
            text.setData((Object)current);
        }
        return current;
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        if (this.licensePlanDescriptor == null) {
            this.setErrorMessage(IssueLicensePageMessages.IssueLicenseRequestPage_e_no_license_plan);
            return false;
        }
        if (this.userDescriptor == null) {
            this.setErrorMessage(IssueLicensePageMessages.IssueLicenseRequestPage_e_no_user);
            return false;
        }
        if (this.productVersionDescriptor == null) {
            this.setErrorMessage(IssueLicensePageMessages.IssueLicenseRequestPage_e_no_product_version);
            return false;
        }
        return true;
    }

    public void init(LicensePlanDescriptor plan, UserDescriptor user, ProductVersionDescriptor version) {
        this.licensePlanDescriptor = plan;
        this.userDescriptor = user;
        this.productVersionDescriptor = version;
        this.validFrom = LocalDate.now();
        this.validUntil = this.validFrom.plusMonths(12L);
    }

    public LicensingRequest getLicensingRequest() {
        return this.createLicensingRequest(this.userDescriptor, this.licensePlanDescriptor, this.productVersionDescriptor, this.validFrom, this.validUntil);
    }

    private LicensingRequest createLicensingRequest(final UserDescriptor user, final LicensePlanDescriptor licensePlan, final ProductVersionDescriptor productVersion, final LocalDate from, final LocalDate until) {
        final ZoneId systemDefault = ZoneId.systemDefault();
        final String uuid = UUID.randomUUID().toString();
        final Date creationDate = new Date();
        return new LicensingRequest(){

            public Date getValidUntil() {
                return Date.from(until.atStartOfDay(systemDefault).toInstant());
            }

            public Date getValidFrom() {
                return Date.from(from.atStartOfDay(systemDefault).toInstant());
            }

            public String getUserIdentifier() {
                return user.getEmail();
            }

            public String getUserFullName() {
                return user.getFullName();
            }

            public String getProductVersion() {
                return productVersion.getVersion();
            }

            public String getProductIdentifier() {
                return productVersion.getProduct().getIdentifier();
            }

            public String getPlanIdentifier() {
                return licensePlan.getIdentifier();
            }

            public String getIdentifier() {
                return uuid;
            }

            public Date getCreationDate() {
                return creationDate;
            }

            public String getConditionType() {
                return user.getPreferredConditionType();
            }

            public String getConditionExpression() {
                return user.getPreferredConditionExpression();
            }
        };
    }
}

