/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.ui.handlers;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.UUID;
import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.access.LicensingRequest;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.equinox.LicensingEquinox;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.products.registry.ProductRegistry;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.model.api.UserLicense;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.loc.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.licenses.ui.i18n.LicensesUiMessages;
import org.eclipse.passage.loc.internal.users.ui.SelectUser;
import org.eclipse.passage.loc.internal.users.ui.SelectUserOrigin;
import org.eclipse.passage.loc.internal.workbench.MandatoryEclipseContext;
import org.eclipse.passage.loc.internal.workbench.SelectInner;
import org.eclipse.passage.loc.products.ui.ProductsUi;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.swt.widgets.Shell;

public class LicenseExportHandler {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") LicensePlanDescriptor licensePlan, IEclipseContext context) {
        LicensePackDescriptor licensePack;
        OperatorLicenseService licenseService = (OperatorLicenseService)context.get(OperatorLicenseService.class);
        Shell shell = (Shell)context.get(Shell.class);
        MandatoryEclipseContext resolution = new MandatoryEclipseContext(context);
        java.util.Optional user = new SelectInner(new SelectUser((MandatoryService)resolution).get(), new SelectUserOrigin((MandatoryService)resolution).get(), (MandatoryService)resolution).get();
        if (!user.isPresent()) {
            return;
        }
        ProductRegistry productRegistry = (ProductRegistry)context.get(ProductRegistry.class);
        ComposedAdapterFactoryProvider provider = (ComposedAdapterFactoryProvider)context.get(ComposedAdapterFactoryProvider.class);
        ProductVersionDescriptor productVersion = ProductsUi.selectProductVersionDescriptor((Shell)shell, (ComposedAdapterFactoryProvider)provider, (ProductRegistry)productRegistry, null);
        if (productVersion == null) {
            return;
        }
        long months = 12L;
        InputDialog durationDialog = new InputDialog(shell, LicensesUiMessages.LicenseExportHandler_period_title, LicensesUiMessages.LicenseExportHandler_period_message, String.valueOf(months), new IInputValidator(){

            public String isValid(String newText) {
                String invalidInput = LicensesUiMessages.LicenseExportHandler_e_period_invalid;
                try {
                    long parsed = Long.parseLong(newText);
                    if (parsed <= 0L) {
                        return invalidInput;
                    }
                }
                catch (Exception e) {
                    return invalidInput;
                }
                return null;
            }
        });
        if (durationDialog.open() != 0) {
            return;
        }
        months = Long.parseLong(durationDialog.getValue());
        LocalDateTime fromLocal = LocalDateTime.now();
        LocalDateTime untilLocal = fromLocal.plusMonths(months);
        Date from = Date.from(fromLocal.atZone(ZoneId.systemDefault()).toInstant());
        Date until = Date.from(untilLocal.atZone(ZoneId.systemDefault()).toInstant());
        LicensingRequest request = this.createLicensingRequest((UserDescriptor)user.get(), licensePlan, productVersion, from, until);
        LicensingResult result = licenseService.issueLicensePack(request, licensePack = licenseService.createLicensePack(request));
        if (result.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)LicensesUiMessages.LicenseExportHandler_success_title, (String)result.getMessage());
            Object attached = result.getAttachment(UsersPackage.eINSTANCE.getUserLicense().getName());
            if (attached instanceof UserLicense) {
                UserLicense userLicense = (UserLicense)attached;
                String perspectiveId = "org.eclipse.passage.loc.users.ui.perspective.main";
                LocWokbench.switchPerspective((IEclipseContext)context, (String)perspectiveId);
                IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
                broker.post("org/eclipse/passage/loc/workbench/show", (Object)userLicense);
            }
        } else {
            IStatus status = LicensingEquinox.toStatus((LicensingResult)result);
            ErrorDialog.openError((Shell)shell, (String)LicensesUiMessages.LicenseExportHandler_error_title, (String)LicensesUiMessages.LicenseExportHandler_error_message, (IStatus)status);
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional LicensePlanDescriptor licensePlan, IEclipseContext context) {
        OperatorLicenseService licenseService = (OperatorLicenseService)context.get(OperatorLicenseService.class);
        if (licenseService == null) {
            return false;
        }
        return licensePlan != null;
    }

    private LicensingRequest createLicensingRequest(final UserDescriptor userDescriptor, final LicensePlanDescriptor licensePlan, final ProductVersionDescriptor productVersion, final Date from, final Date until) {
        final String uuid = UUID.randomUUID().toString();
        final Date creationDate = new Date();
        return new LicensingRequest(){

            public Date getValidUntil() {
                return until;
            }

            public Date getValidFrom() {
                return from;
            }

            public String getUserIdentifier() {
                return userDescriptor.getEmail();
            }

            public String getUserFullName() {
                return userDescriptor.getFullName();
            }

            public String getProductVersion() {
                return productVersion.getVersion();
            }

            public String getProductIdentifier() {
                return productVersion.getProduct().getIdentifier();
            }

            public String getPlanIdentifier() {
                return licensePlan.getIdentifier();
            }

            public String getIdentifier() {
                return uuid;
            }

            public Date getCreationDate() {
                return creationDate;
            }

            public String getConditionType() {
                return userDescriptor.getPreferredConditionType();
            }

            public String getConditionExpression() {
                return userDescriptor.getPreferredConditionExpression();
            }
        };
    }
}

