/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions.evaluation;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Emission;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionEvaluationException;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionEvaluatorsRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingException;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionPasringRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionTokenAssessorsRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.PermissionEmittingService;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.Authentication;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.BasePermission;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.SumOfEmissions;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.code.LicenseDoesNotMatch;
import org.eclipse.passage.lic.internal.base.diagnostic.code.LicenseInvalid;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.base.i18n.ConditionsEvaluationMessages;

public final class BasePermissionEmittingService
implements PermissionEmittingService {
    private final StringServiceId id = new StringServiceId("default-emitter");
    private final Authentication authentification;

    public BasePermissionEmittingService(ExpressionPasringRegistry parsers, ExpressionTokenAssessorsRegistry assessors, ExpressionEvaluatorsRegistry evaluators) {
        this.authentification = new Authentication(parsers, assessors, evaluators);
    }

    public StringServiceId id() {
        return this.id;
    }

    public ServiceInvocationResult<Collection<Emission>> emit(Collection<ConditionPack> conditions, LicensedProduct product) {
        return conditions.stream().map(pack -> this.emitFor((ConditionPack)pack, product)).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).orElse(new BaseServiceInvocationResult(new ArrayList()));
    }

    private ServiceInvocationResult<Collection<Emission>> emitFor(ConditionPack pack, LicensedProduct product) {
        return pack.conditions().stream().map(condition -> this.emitFor((Condition)condition, pack, product)).reduce(new BaseServiceInvocationResult.Sum<Emission>(new SumOfEmissions())).map(this::singleton).orElse(new BaseServiceInvocationResult(Collections.emptyList()));
    }

    private ServiceInvocationResult<Collection<Emission>> singleton(ServiceInvocationResult<Emission> origin) {
        return new BaseServiceInvocationResult<Collection<Emission>>(origin.diagnostic(), origin.data().isPresent() ? Collections.singleton((Emission)origin.data().get()) : Collections.emptyList());
    }

    private ServiceInvocationResult<Emission> emitFor(Condition condition, ConditionPack pack, LicensedProduct product) {
        try {
            this.authentification.verify(condition.evaluationInstructions());
        }
        catch (ExpressionParsingException e) {
            return this.fail(pack, new LicenseInvalid(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.parse_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        catch (LicensingException e) {
            return this.fail(pack, new LicenseInvalid(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.assessment_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            return this.fail(pack, new LicenseDoesNotMatch(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.evaluation_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        return this.createFor(condition, pack, product);
    }

    private ServiceInvocationResult<Emission> createFor(Condition condition, ConditionPack pack, LicensedProduct product) {
        try {
            return new BaseServiceInvocationResult<Emission>(new Emission(pack, (Permission)new BasePermission(product, condition, this.from(condition.validityPeriod()), this.expiration(condition.validityPeriod()), pack.origin())));
        }
        catch (Exception e) {
            return new BaseServiceInvocationResult<Emission>(new BaseDiagnostic(Collections.singletonList(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.failed_create_permission"), condition.feature(), condition.identifier()), e))));
        }
    }

    private ServiceInvocationResult<Emission> fail(ConditionPack pack, TroubleCode code, String explanation, Exception e) {
        return new BaseServiceInvocationResult<Emission>((Diagnostic)new BaseDiagnostic(Collections.singletonList(new Trouble(code, explanation, e))), new Emission(pack));
    }

    private ZonedDateTime from(ValidityPeriod period) {
        if (ValidityPeriodClosed.class.isInstance(period)) {
            return ((ValidityPeriodClosed)period).from();
        }
        return ZonedDateTime.now();
    }

    private ZonedDateTime expiration(ValidityPeriod period) {
        if (ValidityPeriodClosed.class.isInstance(period)) {
            return ((ValidityPeriodClosed)period).to();
        }
        return ZonedDateTime.now().plusDays(1L);
    }
}

