/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.LabeledField;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

abstract class SelectableField<T>
extends LabeledField<T> {
    private Text text;
    private Button select;

    protected SelectableField(Optional<T> source, Runnable modified, LabelProvider labels, MandatoryService context) {
        super(source, modified, labels, context);
    }

    @Override
    public Optional<String> error() {
        return this.data().isEmpty() ? Optional.of(this.errorText()) : Optional.empty();
    }

    @Override
    protected Control control(Composite parent) {
        this.installText(parent);
        this.installSelectButton(parent);
        return this.text;
    }

    @Override
    protected void reflectData(T data) {
        if (data instanceof Collection) {
            String altogether = StreamSupport.stream(((Collection)data).spliterator(), false).map(arg_0 -> ((LabelProvider)this.labels).getText(arg_0)).collect(Collectors.joining(", "));
            this.text.setText(altogether);
        } else {
            this.text.setText(this.labels.getText(data));
        }
    }

    private void installText(Composite parent) {
        this.text = new Text(parent, 2056);
        this.text.addModifyListener(m -> this.modified.run());
        this.text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    private void installSelectButton(Composite parent) {
        this.select = new Button(parent, 8);
        this.select.setText(IssueLicensePageMessages.IssueLicenseRequestPage_btn_select_text);
        this.select.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.installData(this.select(this.text))));
        this.select.setLayoutData((Object)GridDataFactory.fillDefaults().create());
    }

    @Override
    protected void enableAuxiliaryControls(boolean enable) {
        this.select.setEnabled(enable);
    }

    @Override
    protected abstract String label();

    protected abstract String errorText();

    protected abstract Optional<T> select(Text var1);
}

