/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lic.emf.ecore.LicensingEcore;
import org.eclipse.passage.lic.floating.FloatingFileExtension;
import org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.floating.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.floating.model.api.LicenseRequisites;
import org.eclipse.passage.lic.floating.model.api.ProductRef;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseLicensedProduct;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.internal.base.diagnostic.SumOfLists;
import org.eclipse.passage.lic.internal.base.io.UserHomeProductResidence;
import org.eclipse.passage.loc.internal.api.IssuedFloatingLicense;
import org.eclipse.passage.loc.internal.api.OperatorProductService;
import org.eclipse.passage.loc.internal.licenses.core.BaseIssuedFloatingLicense;
import org.eclipse.passage.loc.internal.licenses.core.PersistedDecoded;
import org.eclipse.passage.loc.internal.licenses.core.PersistedEncoded;
import org.eclipse.passage.loc.internal.licenses.core.ProductKeyFile;
import org.eclipse.passage.loc.internal.licenses.core.ProductPassword;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;
import org.eclipse.passage.loc.internal.licenses.trouble.code.LicenseIssuingFailed;
import org.eclipse.passage.loc.internal.licenses.trouble.code.LicenseValidationFailed;
import org.eclipse.passage.loc.internal.products.ProductRegistry;

final class IssueFloatingLicense {
    private final ProductRegistry products;
    private final OperatorProductService operator;

    IssueFloatingLicense(ProductRegistry products, OperatorProductService operator) {
        this.products = products;
        this.operator = operator;
    }

    ServiceInvocationResult<IssuedFloatingLicense> issue(FloatingLicensePack pack, Collection<FloatingLicenseAccess> configs) {
        LicensedProduct product = this.product(pack.getLicense().getProduct());
        Path residence = this.residence(pack.getLicense());
        ServiceInvocationResult<List<Path>> license = this.persist((EObject)pack, product, residence, this.decryptedFile(pack), this.encryptedFile(pack));
        BaseServiceInvocationResult.Sum sum = new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfLists());
        ServiceInvocationResult withConfigs = configs.stream().map(access -> this.persist((EObject)access, product, residence, this.decryptedFile((FloatingLicenseAccess)access), this.encryptedFile((FloatingLicenseAccess)access))).reduce(license, (BinaryOperator<ServiceInvocationResult>)sum);
        ServiceInvocationResult withKey = (ServiceInvocationResult)sum.apply(withConfigs, this.replicateKey(product, residence));
        if (!new NoSevereErrors().test(withKey.diagnostic())) {
            return new BaseServiceInvocationResult(withKey.diagnostic());
        }
        return new BaseServiceInvocationResult((Object)new BaseIssuedFloatingLicense(residence, (List)withKey.data().get()));
    }

    private ServiceInvocationResult<List<Path>> persist(EObject target, LicensedProduct product, Path folder, String decrypted, String encrypted) {
        Path licen;
        Path lic;
        Optional<String> errors = Optional.ofNullable(LicensingEcore.extractValidationError((EObject)target));
        if (errors.isPresent()) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseValidationFailed(), errors.get()));
        }
        try {
            lic = new PersistedDecoded(folder, target).write(decrypted);
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_floating_save_decoded_failed, (Exception)((Object)e)));
        }
        try {
            licen = new PersistedEncoded(product, lic, new ProductPassword(this.products, this.operator)).write(encrypted);
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_floating_save_encoded_failed, (Exception)((Object)e)));
        }
        return new BaseServiceInvocationResult(Arrays.asList(lic, licen));
    }

    private ServiceInvocationResult<List<Path>> replicateKey(LicensedProduct product, Path folder) {
        Path key;
        try {
            key = this.copyPlainFile(new ProductKeyFile(product).pub(), folder);
        }
        catch (Exception e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_floating_save_product_key, e));
        }
        return new BaseServiceInvocationResult(Collections.singletonList(key));
    }

    private Path residence(LicenseRequisites license) {
        return new UserHomeProductResidence(license.getProduct().getProduct(), license.getProduct().getVersion()).get().resolve(license.getIdentifier());
    }

    private Path copyPlainFile(Path origin, Path folder) throws IOException {
        Path destination = folder.resolve(origin.getFileName().toString());
        Files.copy(origin, destination, new CopyOption[0]);
        return destination;
    }

    private LicensedProduct product(ProductRef ref) {
        return new BaseLicensedProduct(ref.getProduct(), ref.getVersion());
    }

    private String decryptedFile(FloatingLicensePack pack) {
        return String.valueOf(pack.getLicense().getIdentifier()) + new FloatingFileExtension.FloatingLicenseDecrypted().get();
    }

    private String encryptedFile(FloatingLicensePack pack) {
        return String.valueOf(pack.getLicense().getIdentifier()) + new FloatingFileExtension.FloatingLicenseEncrypted().get();
    }

    private String decryptedFile(FloatingLicenseAccess access) {
        return this.accessFile(access, (FloatingFileExtension)new FloatingFileExtension.FloatingLicenseAccessDecrypted());
    }

    private String encryptedFile(FloatingLicenseAccess access) {
        return this.accessFile(access, (FloatingFileExtension)new FloatingFileExtension.FloatingLicenseAccessEncrypted());
    }

    private String accessFile(FloatingLicenseAccess access, FloatingFileExtension ext) {
        return String.format("%s_%s%s", access.getOriginLicensePack(), access.getUser(), ext.get());
    }
}

