/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.agreements.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.agreements.AgreementDescriptor;
import org.eclipse.passage.lic.agreements.AgreementGroupDescriptor;
import org.eclipse.passage.lic.agreements.model.api.AgreementGroup;
import org.eclipse.passage.lic.agreements.model.meta.AgreementsPackage;
import org.eclipse.passage.lic.agreements.model.util.AgreementsResourceImpl;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.loc.internal.agreements.AgreementRegistry;
import org.eclipse.passage.loc.internal.agreements.core.AgreementsDomainRegistryTracker;
import org.eclipse.passage.loc.internal.agreements.core.i18n.AgreementsCoreMessages;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.Agreements;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.emf.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=agreements", "org.eclipse.passage.lic.emf.edit.file.extension=agreements_xmi"})
public final class AgreementDomainRegistry
extends BaseDomainRegistry<AgreementGroupDescriptor>
implements AgreementRegistry,
EditingDomainRegistry<AgreementGroupDescriptor> {
    private final Map<String, AgreementGroupDescriptor> groups = new HashMap<String, AgreementGroupDescriptor>();
    private final Map<String, AgreementDescriptor> agreements = new HashMap<String, AgreementDescriptor>();
    private EventAdmin events;

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        this.agreements.clear();
        this.groups.clear();
        super.deactivate(properties);
    }

    @Reference
    public void bindGear(OperatorGearSupplier supplier) {
        super.bindGear(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        super.unbindGear(supplier);
    }

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events = null;
    }

    public String getFileExtension() {
        return "agreements_xmi";
    }

    public Class<AgreementGroupDescriptor> getContentClass() {
        return AgreementGroupDescriptor.class;
    }

    public String resolveIdentifier(AgreementGroupDescriptor content) {
        return content.getIdentifier();
    }

    @Override
    public Collection<AgreementGroupDescriptor> groups() {
        return new ArrayList<AgreementGroupDescriptor>(this.groups.values());
    }

    @Override
    public AgreementGroupDescriptor group(String identifier) {
        return this.groups.get(identifier);
    }

    @Override
    public Collection<AgreementDescriptor> agreements() {
        return new ArrayList<AgreementDescriptor>(this.agreements.values());
    }

    public Collection<AgreementDescriptor> agreements(String id) {
        AgreementGroupDescriptor group = this.groups.get(id);
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getAgreements();
    }

    @Override
    public AgreementDescriptor agreement(String identifier) {
        return this.agreements.get(identifier);
    }

    protected DomainContentAdapter<AgreementGroupDescriptor, AgreementDomainRegistry> createContentAdapter() {
        return new AgreementsDomainRegistryTracker(this);
    }

    public void registerAgreementGroup(AgreementGroupDescriptor group) {
        AgreementGroupDescriptor existing = this.groups.put(group.getIdentifier(), group);
        if (existing != null && existing != group) {
            String msg = NLS.bind((String)AgreementsCoreMessages.AgreementDomain_instance_duplication_message, (Object)existing, (Object)group);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.brush(group);
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/AgreementGroup/create", (Object)group).get());
        group.getAgreements().forEach(u -> this.registerAgreement((AgreementDescriptor)u));
    }

    private void brush(AgreementGroupDescriptor group) {
        if (group.getDescription() == null) {
            ((AgreementGroup)group).setDescription("");
        }
    }

    public void registerAgreement(AgreementDescriptor agreement) {
        String identifier = agreement.getIdentifier();
        AgreementDescriptor existing = this.agreements.put(identifier, agreement);
        if (existing != null && existing != agreement) {
            String msg = NLS.bind((String)AgreementsCoreMessages.AgreementDomain_instance_duplication_message, (Object)existing, (Object)agreement);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/Agreement/create", (Object)agreement).get());
    }

    public void unregisterAgreementGroup(String id) {
        AgreementGroupDescriptor removed = this.groups.remove(id);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/AgreementGroup/delete", (Object)removed).get());
            removed.getAgreements().forEach(u -> this.unregisterAgreement(u.getIdentifier()));
        }
    }

    public void unregisterAgreement(String id) {
        AgreementDescriptor removed = this.agreements.remove(id);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/agreements/registry/Agreement/delete", (Object)removed).get());
        }
    }

    public EClass getContentClassifier() {
        return AgreementsPackage.eINSTANCE.getAgreementGroup();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return AgreementsPackage.eINSTANCE.getAgreementGroup_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return AgreementsPackage.eINSTANCE.getAgreementGroup_Name();
    }

    public void registerContent(AgreementGroupDescriptor content) {
        this.registerAgreementGroup(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterAgreementGroup(identifier);
    }

    protected final Resource createResource(URI uri) {
        return new AgreementsResourceImpl(uri);
    }

    protected boolean emfResource(ResourceHandle handle) {
        return Agreements.xmi.equals(handle.type());
    }

    protected KnownResources knownResources(OperatorWorkspace workspace) {
        return workspace.agreements();
    }
}

