/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseDetailsPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicensePackPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseRequestPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.LicenseIssuedNotification;
import org.eclipse.passage.loc.dashboard.ui.wizards.PersonalDataPack;
import org.eclipse.passage.loc.dashboard.ui.wizards.TwoPhaseWizardPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.WizardInfoBar;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.workbench.LocWokbench;

public class IssueLicenseWizard
extends Wizard {
    private final IEclipseContext context;
    private final PersonalDataPack initial;
    private IssueLicenseRequestPage request;
    private IssueLicensePackPage pack;
    private IssueLicenseDetailsPage info;

    public IssueLicenseWizard(IEclipseContext context, PersonalDataPack initial) {
        this.context = context;
        this.initial = initial;
        this.setWindowTitle(IssueLicensePageMessages.IssueLicenseWizard_window_title);
    }

    public void addPages() {
        this.request = new IssueLicenseRequestPage(this.context, this.initial);
        this.addPage(this.request.get());
        this.pack = new IssueLicensePackPage(IssueLicensePackPage.class.getName(), this.request::request, this.context);
        this.addPage((IWizardPage)this.pack);
        this.info = new IssueLicenseDetailsPage(IssueLicenseDetailsPage.class.getName(), this.pack::pack);
        this.addPage((IWizardPage)this.info);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next instanceof TwoPhaseWizardPage) {
            ((TwoPhaseWizardPage)next).init();
        }
        return next;
    }

    public boolean performFinish() {
        ServiceInvocationResult result = ((OperatorLicenseService)this.context.get(OperatorLicenseService.class)).issueLicensePack(this.pack.pack());
        if (!new NoSevereErrors().test(result.diagnostic())) {
            new WizardInfoBar((IWizard)this).installError("Export failed");
            new DiagnosticDialog(this.getShell(), result.diagnostic()).open();
            return false;
        }
        new WizardInfoBar((IWizard)this).wipe();
        new LicenseIssuedNotification(this.getShell()).showPersonal((IssuedLicense)result.data().get());
        this.broadcast((IssuedLicense)result.data().get());
        return true;
    }

    private void broadcast(IssuedLicense result) {
        PersonalLicensePack userLicense = result.license();
        String perspectiveId = "org.eclipse.passage.loc.users.ui.perspective.main";
        LocWokbench.switchPerspective((IEclipseContext)this.context, (String)perspectiveId);
        IEventBroker broker = (IEventBroker)this.context.get(IEventBroker.class);
        broker.post("org/eclipse/passage/loc/workbench/show", (Object)userLicense);
    }
}

