/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.features.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.passage.lic.features.model.api.Feature;
import org.eclipse.passage.lic.features.model.api.FeatureSet;
import org.eclipse.passage.lic.features.model.api.FeatureVersion;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.features.core.FeatureDomainRegistry;

public class FeaturesDomainRegistryTracker
extends DomainContentAdapter<FeatureSet, FeatureDomainRegistry> {
    public FeaturesDomainRegistryTracker(FeatureDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof FeatureSet) {
            FeatureSet featureSet = (FeatureSet)notifier;
            switch (notification.getFeatureID(FeatureSet.class)) {
                case 0: {
                    this.processFeatureSetIdentifier(featureSet, notification);
                    break;
                }
                case 3: {
                    this.processFeatureSetFeatures(featureSet, notification);
                    break;
                }
            }
        } else if (notifier instanceof Feature) {
            Feature feature = (Feature)notifier;
            switch (notification.getFeatureID(Feature.class)) {
                case 0: {
                    this.processFeatureIdentifier(feature, notification);
                    break;
                }
                case 5: {
                    this.processFeatureFeatureVersions(feature, notification);
                    break;
                }
            }
        } else if (notifier instanceof FeatureVersion) {
            FeatureVersion featureVersion = (FeatureVersion)notifier;
            switch (notification.getFeatureID(FeatureVersion.class)) {
                case 0: {
                    this.processFeatureVersionVersion(featureVersion, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processFeatureSetIdentifier(FeatureSet featureSet, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((FeatureDomainRegistry)this.registry).unregisterFeatureSet(oldValue);
                }
                if (newValue == null) break;
                ((FeatureDomainRegistry)this.registry).registerFeatureSet(featureSet);
                break;
            }
        }
    }

    protected void processFeatureSetFeatures(FeatureSet featureSet, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                Feature feature;
                String identifier;
                if (!(newValue instanceof Feature) || (identifier = (feature = (Feature)newValue).getIdentifier()) == null) break;
                ((FeatureDomainRegistry)this.registry).registerFeature(feature);
                break;
            }
            case 4: {
                Feature feature;
                String identifier;
                if (!(oldValue instanceof Feature) || (identifier = (feature = (Feature)oldValue).getIdentifier()) == null) break;
                ((FeatureDomainRegistry)this.registry).unregisterFeature(identifier);
                break;
            }
        }
    }

    protected void processFeatureIdentifier(Feature feature, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((FeatureDomainRegistry)this.registry).unregisterFeature(oldValue);
                }
                if (newValue == null) break;
                ((FeatureDomainRegistry)this.registry).registerFeature(feature);
                break;
            }
        }
    }

    protected void processFeatureFeatureVersions(Feature feature, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                FeatureVersion featureVersion;
                String version;
                if (!(newValue instanceof FeatureVersion) || (version = (featureVersion = (FeatureVersion)newValue).getVersion()) == null) break;
                ((FeatureDomainRegistry)this.registry).registerFeatureVersion(feature, featureVersion);
                break;
            }
            case 4: {
                FeatureVersion featureVersion;
                String version;
                if (!(oldValue instanceof FeatureVersion) || (version = (featureVersion = (FeatureVersion)oldValue).getVersion()) == null) break;
                ((FeatureDomainRegistry)this.registry).unregisterFeatureVersion(feature.getIdentifier(), featureVersion.getVersion());
                break;
            }
        }
    }

    protected void processFeatureVersionVersion(FeatureVersion featureVersion, Notification notification) {
        Feature feature = featureVersion.getFeature();
        if (feature == null) {
            return;
        }
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((FeatureDomainRegistry)this.registry).unregisterFeatureVersion(feature.getIdentifier(), oldValue);
                }
                if (newValue == null) break;
                ((FeatureDomainRegistry)this.registry).registerFeatureVersion(feature, featureVersion);
                break;
            }
        }
    }
}

