/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.request;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.loc.internal.api.GeneralLicenseRequest;

public abstract class GeneralLicenseData
implements GeneralLicenseRequest {
    private final ZoneId zone = ZoneId.systemDefault();
    private final String uuid = UUID.randomUUID().toString();
    private final Date stamp = new Date();
    private final Supplier<LicensePlan> plan;
    private final Supplier<ProductVersion> product;
    private final Supplier<Date> from;
    private final Supplier<Date> until;

    protected GeneralLicenseData(Supplier<LicensePlan> plan, Supplier<ProductVersion> product, Supplier<LocalDate> from, Supplier<LocalDate> until) {
        this.noNulls(plan, product, from, until);
        this.plan = plan;
        this.product = product;
        this.from = () -> Date.from(((LocalDate)from.get()).atStartOfDay(this.zone).toInstant());
        this.until = () -> Date.from(((LocalDate)until.get()).atStartOfDay(this.zone).toInstant());
    }

    private void noNulls(Object planObj, Object productObj, Object fromObj, Object untilObj) {
        String cls = this.getClass().getSimpleName();
        Objects.requireNonNull(planObj, cls + "::plan");
        Objects.requireNonNull(productObj, cls + "::product");
        Objects.requireNonNull(fromObj, cls + "::from");
        Objects.requireNonNull(untilObj, cls + "::until");
    }

    public final Date validUntil() {
        return this.until.get();
    }

    public final Date validFrom() {
        return this.from.get();
    }

    public final String productVersion() {
        return this.product.get().getVersion();
    }

    public final String productIdentifier() {
        return this.product.get().getProduct().getIdentifier();
    }

    public final String plan() {
        return this.plan.get().getIdentifier();
    }

    public final String identifier() {
        return this.uuid;
    }

    public final Date creationDate() {
        return this.stamp;
    }
}

