/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.operator.internal.gear;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironment;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironmentRegistry;
import org.eclipse.passage.lic.api.io.Hashes;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.Service;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.base.io.MD5Hashes;
import org.eclipse.passage.lic.base.registry.ReadOnlyRegistry;
import org.eclipse.passage.lic.bc.BcStreamCodec;
import org.eclipse.passage.lic.oshi.HardwareEnvironment;
import org.eclipse.passage.loc.internal.api.EditingDomainSource;
import org.eclipse.passage.loc.internal.api.OperatorGear;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.operator.internal.gear.services.PassageEditingDomainSource;
import org.eclipse.passage.loc.workspace.CollectiveWorkspace;

final class DefaultGear
implements OperatorGear {
    static final DefaultGear gear = new DefaultGear();
    private final Registry<EvaluationType, RuntimeEnvironment> environments = new ReadOnlyRegistry(Arrays.asList(new HardwareEnvironment()));
    private final Registry<StringServiceId, Hashes> hashes = new ReadOnlyRegistry((Service)new MD5Hashes());
    private final OperatorWorkspace workspace = new CollectiveWorkspace();
    private final EditingDomainSource editing = new PassageEditingDomainSource();

    private DefaultGear() {
    }

    public Optional<StreamCodec> codec(LicensedProduct product) {
        Objects.requireNonNull(product, "DefaultGear::codec -> product");
        return Optional.of(new BcStreamCodec(() -> product));
    }

    public RuntimeEnvironmentRegistry environments() {
        return () -> this.environments;
    }

    public OperatorWorkspace workspace() {
        return this.workspace;
    }

    public HashesRegistry hashes() {
        return () -> this.hashes;
    }

    public EditingDomainSource editingDomainSource() {
        return this.editing;
    }
}

