/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.DeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.pde.api.tools.ui.internal.actions.ExportDialog;
import org.eclipse.pde.api.tools.ui.internal.views.APIToolingView;

public class ExportSessionAction
extends Action {
    private static final String DELTAS_XSLT_TRANSFORM_PATH = "/compare.xsl";
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String HTML_FILE_EXTENSION = ".html";
    APIToolingView view;

    public ExportSessionAction(APIToolingView view) {
        this.setText(ActionMessages.ExportSessionAction_label);
        this.setToolTipText(ActionMessages.ExportSessionAction_tooltip);
        ImageDescriptor enabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_ELCL_EXPORT");
        this.setImageDescriptor(enabledImageDescriptor);
        ImageDescriptor disabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_DLCL_EXPORT");
        this.setDisabledImageDescriptor(disabledImageDescriptor);
        this.setEnabled(false);
        this.view = view;
    }

    public void run() {
        final ISession activeSession = ApiPlugin.getDefault().getSessionManager().getActiveSession();
        if (activeSession == null) {
            return;
        }
        ExportDialog dialog = new ExportDialog(this.view.getSite().getShell(), ActionMessages.ExportActionTitle);
        int returnCode = dialog.open();
        if (returnCode != 0) {
            return;
        }
        final String reportFileName = dialog.getValue();
        if (reportFileName == null) {
            return;
        }
        final String lowerCase = reportFileName.toLowerCase();
        if (!lowerCase.endsWith(HTML_FILE_EXTENSION) && !lowerCase.endsWith(XML_FILE_EXTENSION)) {
            return;
        }
        Job job = new Job(ActionMessages.CompareWithAction_comparing_apis){

            /*
             * Unable to fully structure code
             */
            protected IStatus run(IProgressMonitor monitor) {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                progress.subTask(ActionMessages.CompareDialogCollectingElementTaskName);
                isHtmlFile = lowerCase.endsWith(".html");
                xmlOutputFile = null;
                try {
                    block62: {
                        block58: {
                            block56: {
                                block57: {
                                    progress.subTask(ActionMessages.CompareDialogComputeDeltasTaskName);
                                    reportFile = new File(reportFileName);
                                    progress.worked(25);
                                    Util.updateMonitor((IProgressMonitor)progress);
                                    writer = null;
                                    xmlOutputFile = isHtmlFile != false ? Util.createTempFile((String)String.valueOf(System.currentTimeMillis()), (String)".xml") : reportFile;
                                    if (xmlOutputFile.exists()) {
                                        xmlOutputFile.delete();
                                        break block56;
                                    }
                                    parent = xmlOutputFile.getParentFile();
                                    if (parent.exists() || parent.mkdirs()) break block56;
                                    var11_10 = new Status(4, "org.eclipse.pde.api.tools", ActionMessages.ExportSessionAction_failed_to_create_parent_folders);
                                    if (writer == null) break block57;
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException v0) {}
                                }
                                return var11_10;
                            }
                            writer = new BufferedWriter(new FileWriter(xmlOutputFile));
                            visitor = new DeltaXmlVisitor();
                            data = activeSession.getModel().getRoot().getData();
                            if (data instanceof IDelta) {
                                delta = (IDelta)data;
                                progress.worked(25);
                                Util.updateMonitor((IProgressMonitor)progress);
                                delta.accept((DeltaVisitor)visitor);
                                writer.write(visitor.getXML());
                                writer.flush();
                                progress.worked(25);
                            }
                            {
                                catch (IOException e) {
                                    ApiPlugin.log((Throwable)e);
                                    if (writer != null) {
                                        try {
                                            writer.close();
                                        }
                                        catch (IOException v1) {}
                                    }
                                    break block58;
                                }
                                catch (CoreException e) {
                                    try {
                                        ApiPlugin.log((Throwable)e);
                                        ** if (writer == null) goto lbl-1000
                                    }
                                    catch (Throwable var10_14) {
                                        if (writer != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (IOException v3) {}
                                        }
                                        throw var10_14;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        try {
                                            writer.close();
                                        }
                                        catch (IOException v2) {}
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        break block58;
                                    }
                                }
                            }
                            if (writer == null) break block58;
                            try {
                                writer.close();
                            }
                            catch (IOException v4) {}
                        }
                        if (isHtmlFile) {
                            block59: {
                                block60: {
                                    Util.updateMonitor((IProgressMonitor)progress);
                                    xmlSource = new StreamSource(xmlOutputFile);
                                    stream = ApiPlugin.class.getResourceAsStream("/compare.xsl");
                                    xsltSource = new StreamSource(stream);
                                    if (reportFile.exists()) {
                                        reportFile.delete();
                                        break block59;
                                    }
                                    parent = reportFile.getParentFile();
                                    if (parent.exists() || parent.mkdirs()) break block59;
                                    var14_19 = new Status(4, "org.eclipse.pde.api.tools", ActionMessages.ExportSessionAction_failed_to_create_parent_folders);
                                    if (writer == null) break block60;
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException v5) {}
                                }
                                return var14_19;
                            }
                            try {
                                writer = new BufferedWriter(new FileWriter(reportFile));
                                result = new StreamResult(writer);
                                transFact = TransformerFactory.newInstance();
                                trans = transFact.newTransformer(xsltSource);
                                trans.transform(xmlSource, result);
                            }
                            catch (TransformerConfigurationException e) {
                                ApiUIPlugin.log(e);
                                if (writer == null) ** GOTO lbl141
                                try {
                                    writer.close();
                                }
                                catch (IOException v6) {}
                            }
                            catch (TransformerException e) {
                                ApiUIPlugin.log(e);
                                if (writer == null) ** GOTO lbl141
                                try {
                                    writer.close();
                                }
                                catch (IOException v7) {}
                            }
                            catch (IOException e) {
                                ApiUIPlugin.log(e);
                                if (writer == null) ** GOTO lbl141
                                {
                                    catch (Throwable var13_21) {
                                        if (writer != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (IOException v8) {}
                                        }
                                        throw var13_21;
                                    }
                                }
                                try {
                                    writer.close();
                                }
                                catch (IOException v9) {}
                            }
                            if (writer == null) break block62;
                            try {
                                writer.close();
                            }
                            catch (IOException v10) {}
                        }
                    }
                    progress.worked(25);
                    var16_22 = Status.OK_STATUS;
                    return var16_22;
                    catch (OperationCanceledException v11) {
                        if (xmlOutputFile != null && xmlOutputFile.exists()) {
                            xmlOutputFile.delete();
                        }
                        if (reportFile.exists()) {
                            reportFile.delete();
                        }
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.setSystem(false);
        job.setPriority(30);
        job.schedule();
    }

    public void dispose() {
    }
}

