/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.PDEAuxiliaryState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class PDEState
extends MinimalState {
    private PDEAuxiliaryState fAuxiliaryState;
    private ArrayList<IPluginModelBase> fTargetModels = new ArrayList();

    public PDEState(URL[] target, boolean addResolver, boolean removeDuplicates, IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        this.fAuxiliaryState = new PDEAuxiliaryState();
        this.createNewTargetState(addResolver, target, monitor);
        if (removeDuplicates) {
            this.removeDuplicatesFromState(this.fState);
        }
        this.initializePlatformProperties();
        this.createTargetModels(this.fState.getBundles());
        this.clearOldCache();
        if (PDECore.DEBUG_MODEL) {
            System.out.println("Time to create state: " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void createNewTargetState(boolean resolve, URL[] urls, IProgressMonitor monitor) {
        this.fState = stateObjectFactory.createState(resolve);
        monitor.beginTask(PDECoreMessages.PDEState_CreatingTargetModelState, urls.length);
        int i = 0;
        while (i < urls.length) {
            block8: {
                File file;
                block6: {
                    file = new File(urls[i].getFile());
                    if (!monitor.isCanceled()) break block6;
                    monitor.worked(1);
                    return;
                }
                try {
                    try {
                        monitor.subTask(file.getName());
                        this.addBundle(file, -1L);
                    }
                    catch (CoreException e) {
                        PDECore.log(e);
                        monitor.worked(1);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    monitor.worked(1);
                    throw throwable;
                }
                monitor.worked(1);
            }
            ++i;
        }
    }

    @Override
    protected void addAuxiliaryData(BundleDescription desc, Map<String, String> manifest, boolean hasBundleStructure) {
        this.fAuxiliaryState.addAuxiliaryData(desc, manifest, hasBundleStructure);
    }

    private void removeDuplicatesFromState(State state) {
        BundleDescription[] bundles = state.getBundles();
        int i = 0;
        while (i < bundles.length) {
            BundleDescription desc = bundles[i];
            String id = desc.getSymbolicName();
            BundleDescription[] conflicts = state.getBundles(id);
            if (conflicts.length > 1) {
                int j = 0;
                while (j < conflicts.length) {
                    if (desc.getVersion().equals((Object)conflicts[j].getVersion()) && desc.getBundleId() != conflicts[j].getBundleId()) {
                        this.fState.removeBundle(desc);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private IPluginModelBase[] createTargetModels(BundleDescription[] bundleDescriptions) {
        HashMap<String, IPluginModelBase> models = new HashMap<String, IPluginModelBase>(1 * bundleDescriptions.length + 1);
        int i = 0;
        while (i < bundleDescriptions.length) {
            BundleDescription desc = bundleDescriptions[i];
            IPluginModelBase base = this.createExternalModel(desc);
            this.fTargetModels.add(base);
            models.put(desc.getSymbolicName(), base);
            ++i;
        }
        if (models.isEmpty()) {
            return new IPluginModelBase[0];
        }
        return models.values().toArray(new IPluginModelBase[models.size()]);
    }

    private IPluginModelBase createExternalModel(BundleDescription desc) {
        ExternalPluginModelBase model = null;
        model = desc.getHost() == null ? new ExternalPluginModel() : new ExternalFragmentModel();
        model.load(desc, this);
        model.setBundleDescription(desc);
        model.setEnabled(true);
        return model;
    }

    public IPluginModelBase[] getTargetModels() {
        return this.fTargetModels.toArray(new IPluginModelBase[this.fTargetModels.size()]);
    }

    private void clearOldCache() {
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString());
        File[] children = dir.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                if (child.isDirectory()) {
                    String name = child.getName();
                    if (name.endsWith(".target") && name.length() > ".target".length()) {
                        CoreUtility.deleteContent(child);
                    } else if (name.endsWith(".workspace") && name.length() > ".workspace".length()) {
                        CoreUtility.deleteContent(child);
                    } else if (name.endsWith(".cache") && name.length() > ".cache".length()) {
                        CoreUtility.deleteContent(child);
                    }
                }
                ++i;
            }
        }
    }

    public String getClassName(long bundleID) {
        return this.fAuxiliaryState.getClassName(bundleID);
    }

    public boolean hasExtensibleAPI(long bundleID) {
        return this.fAuxiliaryState.hasExtensibleAPI(bundleID);
    }

    public boolean isPatchFragment(long bundleID) {
        return this.fAuxiliaryState.isPatchFragment(bundleID);
    }

    public boolean hasBundleStructure(long bundleID) {
        return this.fAuxiliaryState.hasBundleStructure(bundleID);
    }

    public String getPluginName(long bundleID) {
        return this.fAuxiliaryState.getPluginName(bundleID);
    }

    public String getProviderName(long bundleID) {
        return this.fAuxiliaryState.getProviderName(bundleID);
    }

    public String[] getLibraryNames(long bundleID) {
        return this.fAuxiliaryState.getLibraryNames(bundleID);
    }

    public String getBundleLocalization(long bundleID) {
        return this.fAuxiliaryState.getBundleLocalization(bundleID);
    }

    public String getProject(long bundleID) {
        return this.fAuxiliaryState.getProject(bundleID);
    }

    public String getBundleSourceEntry(long bundleID) {
        return this.fAuxiliaryState.getBundleSourceEntry(bundleID);
    }
}

