/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.AllTermDocs;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReadOnlySegmentReader;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentNorms;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentReader
extends IndexReader
implements Cloneable {
    protected boolean readOnly;
    private SegmentInfo si;
    private int readBufferSize;
    CloseableThreadLocal<FieldsReader> fieldsReaderLocal = new FieldsReaderLocal();
    CloseableThreadLocal<TermVectorsReader> termVectorsLocal = new CloseableThreadLocal();
    BitVector deletedDocs = null;
    AtomicInteger deletedDocsRef = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private int pendingDeleteCount;
    private boolean rollbackHasChanges = false;
    private boolean rollbackDeletedDocsDirty = false;
    private boolean rollbackNormsDirty = false;
    private SegmentInfo rollbackSegmentInfo;
    private int rollbackPendingDeleteCount;
    IndexInput singleNormStream;
    AtomicInteger singleNormRef;
    SegmentCoreReaders core;
    Map<String, SegmentNorms> norms = new HashMap<String, SegmentNorms>();

    public static SegmentReader get(boolean readOnly, SegmentInfo si, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return SegmentReader.get(readOnly, si.dir, si, 1024, true, termInfosIndexDivisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SegmentReader get(boolean readOnly, Directory dir, SegmentInfo si, int readBufferSize, boolean doOpenStores, int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        SegmentReader instance = readOnly ? new ReadOnlySegmentReader() : new SegmentReader();
        instance.readOnly = readOnly;
        instance.si = si;
        instance.readBufferSize = readBufferSize;
        boolean success = false;
        try {
            instance.core = new SegmentCoreReaders(instance, dir, si, readBufferSize, termInfosIndexDivisor);
            if (doOpenStores) {
                instance.core.openDocStores(si);
            }
            instance.loadDeletedDocs();
            instance.openNorms(instance.core.cfsDir, readBufferSize);
            return instance;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (success) throw throwable;
            instance.doClose();
            throw throwable;
        }
    }

    void openDocStores() throws IOException {
        this.core.openDocStores(this.si);
    }

    private boolean checkDeletedCounts() throws IOException {
        int recomputedCount = this.deletedDocs.getRecomputedCount();
        assert (this.deletedDocs.count() == recomputedCount) : "deleted count=" + this.deletedDocs.count() + " vs recomputed count=" + recomputedCount;
        assert (this.si.getDelCount() == recomputedCount) : "delete count mismatch: info=" + this.si.getDelCount() + " vs BitVector=" + recomputedCount;
        assert (this.si.getDelCount() <= this.maxDoc()) : "delete count mismatch: " + recomputedCount + ") exceeds max doc (" + this.maxDoc() + ") for segment " + this.si.name;
        return true;
    }

    private void loadDeletedDocs() throws IOException {
        if (SegmentReader.hasDeletions(this.si)) {
            this.deletedDocs = new BitVector(this.directory(), this.si.getDelFileName());
            this.deletedDocsRef = new AtomicInteger(1);
            assert (this.checkDeletedCounts());
            if (this.deletedDocs.size() != this.si.docCount) {
                throw new CorruptIndexException("document count mismatch: deleted docs count " + this.deletedDocs.size() + " vs segment doc count " + this.si.docCount + " segment=" + this.si.name);
            }
        } else assert (this.si.getDelCount() == 0);
    }

    protected byte[] cloneNormBytes(byte[] bytes) {
        byte[] cloneBytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, cloneBytes, 0, bytes.length);
        return cloneBytes;
    }

    protected BitVector cloneDeletedDocs(BitVector bv) {
        this.ensureOpen();
        return (BitVector)bv.clone();
    }

    @Override
    public final synchronized Object clone() {
        try {
            return this.clone(this.readOnly);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final synchronized IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, true, openReadOnly);
    }

    @Override
    protected synchronized IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, false, this.readOnly);
    }

    @Override
    protected synchronized IndexReader doOpenIfChanged(boolean openReadOnly) throws CorruptIndexException, IOException {
        return this.reopenSegment(this.si, false, openReadOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized SegmentReader reopenSegment(SegmentInfo si, boolean doClone, boolean openReadOnly) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean deletionsUpToDate = this.si.hasDeletions() == si.hasDeletions() && (!si.hasDeletions() || this.si.getDelFileName().equals(si.getDelFileName()));
        boolean normsUpToDate = true;
        boolean[] fieldNormsChanged = new boolean[this.core.fieldInfos.size()];
        int fieldCount = this.core.fieldInfos.size();
        for (int i = 0; i < fieldCount; ++i) {
            if (this.si.getNormFileName(i).equals(si.getNormFileName(i))) continue;
            normsUpToDate = false;
            fieldNormsChanged[i] = true;
        }
        if (normsUpToDate && deletionsUpToDate && !doClone && openReadOnly && this.readOnly) {
            return null;
        }
        assert (!doClone || normsUpToDate && deletionsUpToDate);
        SegmentReader clone = openReadOnly ? new ReadOnlySegmentReader() : new SegmentReader();
        boolean success = false;
        try {
            this.core.incRef();
            clone.core = this.core;
            clone.readOnly = openReadOnly;
            clone.si = si;
            clone.readBufferSize = this.readBufferSize;
            clone.pendingDeleteCount = this.pendingDeleteCount;
            clone.readerFinishedListeners = this.readerFinishedListeners;
            if (!openReadOnly && this.hasChanges) {
                clone.deletedDocsDirty = this.deletedDocsDirty;
                clone.normsDirty = this.normsDirty;
                clone.hasChanges = this.hasChanges;
                this.hasChanges = false;
            }
            if (doClone) {
                if (this.deletedDocs != null) {
                    this.deletedDocsRef.incrementAndGet();
                    clone.deletedDocs = this.deletedDocs;
                    clone.deletedDocsRef = this.deletedDocsRef;
                }
            } else if (!deletionsUpToDate) {
                assert (clone.deletedDocs == null);
                clone.loadDeletedDocs();
            } else if (this.deletedDocs != null) {
                this.deletedDocsRef.incrementAndGet();
                clone.deletedDocs = this.deletedDocs;
                clone.deletedDocsRef = this.deletedDocsRef;
            }
            clone.norms = new HashMap<String, SegmentNorms>();
            for (int i = 0; i < fieldNormsChanged.length; ++i) {
                String curField;
                SegmentNorms norm;
                if (!doClone && fieldNormsChanged[i] || (norm = this.norms.get(curField = this.core.fieldInfos.fieldInfo((int)i).name)) == null) continue;
                clone.norms.put(curField, (SegmentNorms)norm.clone());
            }
            clone.openNorms(si.getUseCompoundFile() ? this.core.getCFSReader() : this.directory(), this.readBufferSize);
            return clone;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (success) throw throwable;
            clone.decRef();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        if (this.hasChanges) {
            this.startCommit();
            boolean success = false;
            try {
                this.commitChanges(commitUserData);
                success = true;
                Object var4_3 = null;
                if (!success) {
                    this.rollbackCommit();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!success) {
                    this.rollbackCommit();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void commitChanges(Map<String, String> commitUserData) throws IOException {
        if (this.deletedDocsDirty) {
            block12: {
                this.si.advanceDelGen();
                assert (this.deletedDocs.size() == this.si.docCount);
                String delFileName = this.si.getDelFileName();
                boolean success = false;
                try {
                    this.deletedDocs.write(this.directory(), delFileName);
                    success = true;
                    Object var5_5 = null;
                    if (success) break block12;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (success) throw throwable;
                    try {
                        this.directory().deleteFile(delFileName);
                        throw throwable;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Throwable t) {}
                this.directory().deleteFile(delFileName);
            }
            this.si.setDelCount(this.si.getDelCount() + this.pendingDeleteCount);
            this.pendingDeleteCount = 0;
            assert (this.deletedDocs.count() == this.si.getDelCount()) : "delete count mismatch during commit: info=" + this.si.getDelCount() + " vs BitVector=" + this.deletedDocs.count();
        } else assert (this.pendingDeleteCount == 0);
        if (this.normsDirty) {
            this.si.setNumFields(this.core.fieldInfos.size());
            for (SegmentNorms norm : this.norms.values()) {
                if (!norm.dirty) continue;
                norm.reWrite(this.si);
            }
        }
        this.deletedDocsDirty = false;
        this.normsDirty = false;
        this.hasChanges = false;
    }

    FieldsReader getFieldsReader() {
        return this.fieldsReaderLocal.get();
    }

    @Override
    protected void doClose() throws IOException {
        this.termVectorsLocal.close();
        this.fieldsReaderLocal.close();
        if (this.deletedDocs != null) {
            this.deletedDocsRef.decrementAndGet();
            this.deletedDocs = null;
        }
        for (SegmentNorms norm : this.norms.values()) {
            norm.decRef();
        }
        if (this.core != null) {
            this.core.decRef();
        }
    }

    static boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.hasDeletions();
    }

    @Override
    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static boolean usesCompoundFile(SegmentInfo si) throws IOException {
        return si.getUseCompoundFile();
    }

    static boolean hasSeparateNorms(SegmentInfo si) throws IOException {
        return si.hasSeparateNorms();
    }

    @Override
    protected void doDelete(int docNum) {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
            this.deletedDocsRef = new AtomicInteger(1);
        }
        if (this.deletedDocsRef.get() > 1) {
            AtomicInteger oldRef = this.deletedDocsRef;
            this.deletedDocs = this.cloneDeletedDocs(this.deletedDocs);
            this.deletedDocsRef = new AtomicInteger(1);
            oldRef.decrementAndGet();
        }
        this.deletedDocsDirty = true;
        if (!this.deletedDocs.getAndSet(docNum)) {
            ++this.pendingDeleteCount;
        }
    }

    @Override
    protected void doUndeleteAll() {
        this.deletedDocsDirty = false;
        if (this.deletedDocs != null) {
            assert (this.deletedDocsRef != null);
            this.deletedDocsRef.decrementAndGet();
            this.deletedDocs = null;
            this.deletedDocsRef = null;
            this.pendingDeleteCount = 0;
            this.si.clearDelGen();
            this.si.setDelCount(0);
        } else {
            assert (this.deletedDocsRef == null);
            assert (this.pendingDeleteCount == 0);
        }
    }

    List<String> files() throws IOException {
        return new ArrayList<String>(this.si.files());
    }

    @Override
    public TermEnum terms() {
        this.ensureOpen();
        return this.core.getTermsReader().terms();
    }

    @Override
    public TermEnum terms(Term t) throws IOException {
        this.ensureOpen();
        return this.core.getTermsReader().terms(t);
    }

    FieldInfos fieldInfos() {
        return this.core.fieldInfos;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (n < 0 || n >= this.maxDoc()) {
            throw new IllegalArgumentException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + n + ")");
        }
        return this.getFieldsReader().doc(n, fieldSelector);
    }

    @Override
    public synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        if (term == null) {
            return new AllTermDocs(this);
        }
        return super.termDocs(term);
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new SegmentTermDocs(this);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new SegmentTermPositions(this);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        TermInfo ti = this.core.getTermsReader().get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    @Override
    public int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    @Override
    public int maxDoc() {
        return this.si.docCount;
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            FieldInfo fi = this.core.fieldInfos.fieldInfo(i);
            if (fieldOption == IndexReader.FieldOption.ALL) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.isIndexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY && fieldOption == IndexReader.FieldOption.OMIT_TERM_FREQ_AND_POSITIONS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS && fieldOption == IndexReader.FieldOption.OMIT_POSITIONS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePayloads && fieldOption == IndexReader.FieldOption.STORES_PAYLOADS) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && !fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeTermVector && !fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.isIndexed && fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                fieldSet.add(fi.name);
                continue;
            }
            if (fi.storeOffsetWithTermVector && !fi.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                fieldSet.add(fi.name);
                continue;
            }
            if (!fi.storeOffsetWithTermVector || !fi.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    @Override
    public boolean hasNorms(String field) {
        this.ensureOpen();
        return this.norms.containsKey(field);
    }

    @Override
    public byte[] norms(String field) throws IOException {
        this.ensureOpen();
        SegmentNorms norm = this.norms.get(field);
        if (norm == null) {
            return null;
        }
        return norm.bytes();
    }

    @Override
    protected void doSetNorm(int doc, String field, byte value) throws IOException {
        SegmentNorms norm = this.norms.get(field);
        if (norm == null) {
            throw new IllegalStateException("Cannot setNorm for field " + field + ": norms were omitted");
        }
        this.normsDirty = true;
        norm.copyOnWrite()[doc] = value;
    }

    @Override
    public synchronized void norms(String field, byte[] bytes, int offset) throws IOException {
        this.ensureOpen();
        SegmentNorms norm = this.norms.get(field);
        if (norm == null) {
            Arrays.fill(bytes, offset, bytes.length, Similarity.getDefault().encodeNormValue(1.0f));
            return;
        }
        norm.bytes(bytes, offset, this.maxDoc());
    }

    int getPostingsSkipInterval() {
        return this.core.getTermsReader().getSkipInterval();
    }

    private void openNorms(Directory cfsDir, int readBufferSize) throws IOException {
        long nextNormSeek = SegmentNorms.NORMS_HEADER.length;
        int maxDoc = this.maxDoc();
        for (int i = 0; i < this.core.fieldInfos.size(); ++i) {
            long normSeek;
            FieldInfo fi = this.core.fieldInfos.fieldInfo(i);
            if (this.norms.containsKey(fi.name) || !fi.isIndexed || fi.omitNorms) continue;
            Directory d = this.directory();
            String fileName = this.si.getNormFileName(fi.number);
            if (!this.si.hasSeparateNorms(fi.number)) {
                d = cfsDir;
            }
            boolean singleNormFile = IndexFileNames.matchesExtension(fileName, "nrm");
            IndexInput normInput = null;
            if (singleNormFile) {
                normSeek = nextNormSeek;
                if (this.singleNormStream == null) {
                    this.singleNormStream = d.openInput(fileName, readBufferSize);
                    this.singleNormRef = new AtomicInteger(1);
                } else {
                    this.singleNormRef.incrementAndGet();
                }
                normInput = this.singleNormStream;
            } else {
                normInput = d.openInput(fileName);
                String version = this.si.getVersion();
                boolean isUnversioned = (version == null || StringHelper.getVersionComparator().compare(version, "3.2") < 0) && normInput.length() == (long)this.maxDoc();
                normSeek = isUnversioned ? 0L : (long)SegmentNorms.NORMS_HEADER.length;
            }
            this.norms.put(fi.name, new SegmentNorms(normInput, fi.number, normSeek, this));
            nextNormSeek += (long)maxDoc;
        }
    }

    boolean termsIndexLoaded() {
        return this.core.termsIndexIsLoaded();
    }

    void loadTermsIndex(int termsIndexDivisor) throws IOException {
        this.core.loadTermsIndex(this.si, termsIndexDivisor);
    }

    boolean normsClosed() {
        if (this.singleNormStream != null) {
            return false;
        }
        for (SegmentNorms norm : this.norms.values()) {
            if (norm.refCount <= 0) continue;
            return false;
        }
        return true;
    }

    boolean normsClosed(String field) {
        return this.norms.get((Object)field).refCount == 0;
    }

    TermVectorsReader getTermVectorsReader() {
        TermVectorsReader tvReader = this.termVectorsLocal.get();
        if (tvReader == null) {
            TermVectorsReader orig = this.core.getTermVectorsReaderOrig();
            if (orig == null) {
                return null;
            }
            try {
                tvReader = (TermVectorsReader)orig.clone();
            }
            catch (CloneNotSupportedException cnse) {
                return null;
            }
            this.termVectorsLocal.set(tvReader);
        }
        return tvReader;
    }

    TermVectorsReader getTermVectorsReaderOrig() {
        return this.core.getTermVectorsReaderOrig();
    }

    @Override
    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.core.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector) {
            return null;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber, field);
    }

    @Override
    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.core.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector) {
            return;
        }
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, field, mapper);
    }

    @Override
    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return;
        }
        termVectorsReader.get(docNumber, mapper);
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        this.ensureOpen();
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        return termVectorsReader.get(docNumber);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.hasChanges) {
            buffer.append('*');
        }
        buffer.append(this.si.toString(this.core.dir, this.pendingDeleteCount));
        return buffer.toString();
    }

    public String getSegmentName() {
        return this.core.segment;
    }

    SegmentInfo getSegmentInfo() {
        return this.si;
    }

    void setSegmentInfo(SegmentInfo info) {
        this.si = info;
    }

    void startCommit() {
        this.rollbackSegmentInfo = (SegmentInfo)this.si.clone();
        this.rollbackHasChanges = this.hasChanges;
        this.rollbackDeletedDocsDirty = this.deletedDocsDirty;
        this.rollbackNormsDirty = this.normsDirty;
        this.rollbackPendingDeleteCount = this.pendingDeleteCount;
        for (SegmentNorms norm : this.norms.values()) {
            norm.rollbackDirty = norm.dirty;
        }
    }

    void rollbackCommit() {
        this.si.reset(this.rollbackSegmentInfo);
        this.hasChanges = this.rollbackHasChanges;
        this.deletedDocsDirty = this.rollbackDeletedDocsDirty;
        this.normsDirty = this.rollbackNormsDirty;
        this.pendingDeleteCount = this.rollbackPendingDeleteCount;
        for (SegmentNorms norm : this.norms.values()) {
            norm.dirty = norm.rollbackDirty;
        }
    }

    @Override
    public Directory directory() {
        return this.core.dir;
    }

    @Override
    public final Object getCoreCacheKey() {
        return this.core.freqStream;
    }

    @Override
    public Object getDeletesCacheKey() {
        return this.deletedDocs;
    }

    @Override
    public long getUniqueTermCount() {
        return this.core.getTermsReader().size();
    }

    @Deprecated
    static SegmentReader getOnlySegmentReader(Directory dir) throws IOException {
        return SegmentReader.getOnlySegmentReader(IndexReader.open(dir, false));
    }

    static SegmentReader getOnlySegmentReader(IndexReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof DirectoryReader) {
            IndexReader[] subReaders = reader.getSequentialSubReaders();
            if (subReaders.length != 1) {
                throw new IllegalArgumentException(reader + " has " + subReaders.length + " segments instead of exactly one");
            }
            return (SegmentReader)subReaders[0];
        }
        throw new IllegalArgumentException(reader + " is not a SegmentReader or a single-segment DirectoryReader");
    }

    @Override
    public int getTermInfosIndexDivisor() {
        return this.core.termsIndexDivisor;
    }

    @Override
    protected void readerFinished() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldsReaderLocal
    extends CloseableThreadLocal<FieldsReader> {
        private FieldsReaderLocal() {
        }

        @Override
        protected FieldsReader initialValue() {
            return (FieldsReader)SegmentReader.this.core.getFieldsReaderOrig().clone();
        }
    }
}

