/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.DefaultContextMaker;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.internal.resources.Activator;
import org.eclipse.rcptt.ctx.resources.ImportUtils;
import org.eclipse.rcptt.ctx.resources.WSUtils;
import org.eclipse.rcptt.ctx.resources.WorkspaceContextImporter;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSFolderLink;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.rcptt.workspace.WorkspaceFactory;

public class WorkspaceContextMaker
extends DefaultContextMaker {
    public Context create(Resource resource, ContextType type, String name) {
        WorkspaceContext context = (WorkspaceContext)super.create(resource, type, name);
        context.setContent(WorkspaceFactory.eINSTANCE.createWSRoot());
        return context;
    }

    public void makeExecutable(Context context, IQ7NamedElement source) throws ModelException {
        this.makeSelfSufficientContext((WorkspaceContext)context, source.getModifiedPersistenceModel(), source);
    }

    public void makeSelfSufficientContext(WorkspaceContext context, IPersistenceModel model, IQ7NamedElement source) throws ModelException {
        WSRoot root;
        if (model != null) {
            model.extractAll();
        }
        if ((root = context.getContent()) != null) {
            for (WSProject wsProject : root.getProjects()) {
                String location = source.getParent().getResource().getLocation().toString();
                this.fillFilesContent(wsProject.getFiles(), location, model);
                this.fillFileLinksContent(wsProject.getFileLinks());
                EList<WSFolder> folders = wsProject.getFolders();
                this.processFolders(folders, location, model);
                this.fillFolderLinksContent(wsProject.getFolderLinks(), model);
            }
            this.fillFolderLinksContent(root.getProjectLinks(), model);
        }
    }

    private void processFolders(EList<WSFolder> folders, String location, IPersistenceModel model) throws ModelException {
        for (WSFolder wsFolder : folders) {
            EList<WSFolder> list = wsFolder.getFolders();
            this.processFolders(list, location, model);
            EList<WSFile> files = wsFolder.getFiles();
            this.fillFilesContent(files, location, model);
            EList<WSFileLink> fileLinks = wsFolder.getFileLinks();
            this.fillFileLinksContent(fileLinks);
            this.fillFolderLinksContent(wsFolder.getFolderLinks(), model);
        }
    }

    private void fillFilesContent(EList<WSFile> files, String location, IPersistenceModel model) {
        for (WSFile wsFile : files) {
            this.fillFile(location, wsFile, model);
        }
    }

    private void fillFileLinksContent(EList<WSFileLink> fileLinks) throws ModelException {
        for (WSFileLink fileLink : fileLinks) {
            this.fillFileLink(fileLink);
        }
    }

    private <T extends WSFolderLink> void fillFolderLinksContent(EList<T> folderLinks, IPersistenceModel model) throws ModelException {
        for (WSFolderLink folderLink : folderLinks) {
            this.fillFolderLink(folderLink, model);
        }
    }

    private void fillFolderLink(WSFolderLink folderLink, IPersistenceModel model) throws ModelException {
        try {
            WSUtils.loadFolderLinkWithContent(folderLink);
        }
        catch (IOException e) {
            Activator.log(e);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private void fillFile(String location, WSFile wsFile, IPersistenceModel model) {
        try {
            byte[] content = WSUtils.getFileContent(location, wsFile, model);
            if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(bout);
                zout.setLevel(9);
                zout.setMethod(8);
                ZipEntry entry = new ZipEntry("content");
                entry.setTime(1L);
                zout.putNextEntry(entry);
                zout.write(content);
                zout.close();
                wsFile.setContent(bout.toByteArray());
            } else {
                wsFile.setContent(content);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private void fillFileLink(WSFileLink fileLink) throws ModelException {
        WSUtils.loadFileLinkWithContent(fileLink);
    }

    public void makeExecutableContext(WSFile child, IFile iFile) {
        if ("false".equals(Q7Features.getInstance().getValue("q7.contexts.resources.transfer.content"))) {
            return;
        }
        try {
            InputStream contents = iFile.getContents();
            byte[] content = WSUtils.getStreamContent(contents);
            contents.close();
            if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(bout);
                zout.setLevel(9);
                zout.setMethod(8);
                ZipEntry entry = new ZipEntry("content");
                entry.setTime(1L);
                zout.putNextEntry(entry);
                zout.write(content);
                zout.close();
                child.setContent(bout.toByteArray());
            } else {
                child.setContent(content);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public void captureContents(IContext context, Context data, IProgressMonitor monitor) throws CoreException {
        WorkspaceContext wsContext = (WorkspaceContext)data;
        WorkspaceContextImporter importer = new WorkspaceContextImporter(wsContext);
        IPersistenceModel model = context.getPersistenceModel();
        model.removeAll();
        try {
            WSRoot ownRoot = ((WorkspaceContext)context.getNamedElement()).getContent();
            ownRoot.getProjects().clear();
            EList<WSProject> projects = wsContext.getContent().getProjects();
            if (projects.size() > 0) {
                monitor.beginTask("Copy projects...", projects.size());
                for (WSProject project : projects) {
                    WSProject ownProject = WSUtils.getProject(ownRoot, project.getName(), true);
                    ImportUtils.importFiles(ownProject, project.getFiles(), model, importer);
                    ImportUtils.importFolders(ownProject, project.getFolders(), model, importer);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(RcpttPlugin.createStatus((Throwable)e));
        }
    }
}

