/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.EclException;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.internal.core.ProcessStatusConverter;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ImageEntry;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.core.TimeFormatHelper;
import org.eclipse.rcptt.reporting.util.IndentedWriter;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaException;
import org.eclipse.rcptt.sherlock.core.model.sherlock.JavaStackTraceEntry;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.ReportBuilder;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfo;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.utils.AdvancedInformationGenerator;
import org.eclipse.rcptt.util.StringUtils;

public class RcpttReportGenerator {
    private final SimpleReportGenerator simpleReportGenerator = new SimpleReportGenerator();
    private final List<ImageEntry> images;
    private final PrintWriter writer;
    private long startTime = 0L;
    private final Map<String, Long> totalWaitTime = new HashMap<String, Long>();
    private int maxMethodNameLength = 0;
    private int maxTotalTimeLength = 0;

    public RcpttReportGenerator(PrintWriter writer, List<ImageEntry> images) {
        this.writer = writer;
        this.images = images;
    }

    protected PrintWriter writeTabs(int tabs) {
        return RcpttReportGenerator.writeTabs(this.writer, tabs);
    }

    public void writeReport(Report report, int tabs) {
        this.startTime = report.getRoot().getStartTime();
        this.printNode(report.getRoot(), tabs);
        this.printTotalWaitTime();
    }

    protected static <T extends Appendable> T writeTabs(T writer, int tabs) {
        int i = 0;
        while (i < tabs) {
            try {
                writer.append("  ");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return writer;
    }

    public void printNode(Node infoNode, int tabs) {
        this.writeQ7Info(tabs, infoNode);
        this.writeQ7WaitInfo(tabs, infoNode);
        this.writeLogsFromNode(tabs, infoNode);
        try {
            for (Event child : infoNode.getEvents()) {
                this.writeEvent(child, tabs + 1);
            }
            for (Event child : infoNode.getSnapshots()) {
                this.writeSnapshot((Snaphot)child, tabs + 1);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.printChildren(tabs, infoNode);
    }

    private void writeEvent(Event event, int tabs) throws IOException {
        if (event.getCount() == 1) {
            this.writeTabs(tabs + 1).append("Event at ").println(TimeFormatHelper.format((long)(event.getTime() - this.startTime)));
        } else {
            this.writeTabs(tabs + 1).append("Event: ").append(String.valueOf(event.getCount())).append(" times, first at ").append(TimeFormatHelper.format((long)(event.getTime() - this.startTime))).println();
        }
        this.printObject(event.getData(), tabs + 2);
    }

    public void printObject(EObject object, int tabs) throws IOException {
        if (object instanceof EclipseStatus) {
            this.printStatus((EclipseStatus)object, tabs);
        } else if (object instanceof Snaphot) {
            this.writeSnapshot((Snaphot)object, tabs);
        } else {
            this.simpleReportGenerator.toString((Appendable)this.writer, tabs, object, new String[0]);
        }
    }

    private void writeSnapshot(Snaphot snapshot, int tabs) throws IOException {
        if (snapshot.getData() instanceof Screenshot) {
            Screenshot shot = (Screenshot)snapshot.getData();
            String description = String.valueOf(shot.getMessage()) + ": " + TimeFormatHelper.format((long)(snapshot.getTime() - this.startTime));
            this.images.add(new ImageEntry(shot.getData(), description));
            return;
        }
        if (snapshot.getData() instanceof AdvancedInformation) {
            this.printAdvanced((AdvancedInformation)snapshot.getData(), tabs);
            return;
        }
        this.writeTabs(tabs).println("Snapshot " + TimeFormatHelper.format((long)(snapshot.getTime() - this.startTime)));
        this.printObject(snapshot.getData(), tabs + 1);
    }

    private void printAdvanced(AdvancedInformation data, int tabs) {
        new AdvancedInformationGenerator(this.writer).writeAdvanced(data, tabs);
    }

    private PrintWriter w(int tabs) {
        return this.writeTabs(tabs);
    }

    private void printStatus(EclipseStatus status, int tabs) throws IOException {
        SimpleSeverity severity = SimpleSeverity.create((int)status.getSeverity());
        this.w(tabs).append(severity.name());
        this.writer.append(" in plugin: ").println(status.getPlugin());
        this.w(tabs).append("message: ").println(status.getMessage());
        if (status.getException() != null) {
            this.w(tabs).println("exception: ");
            this.printJavaException(status.getException(), tabs + 2);
        }
        for (EclipseStatus child : status.getChildren()) {
            this.printStatus(child, tabs + 1);
        }
    }

    private void printJavaException(JavaException e, int tabs) {
        this.w(tabs).append(e.getClassName());
        if (!StringUtils.isEmpty((String)e.getMessage())) {
            this.writer.print(":" + e.getMessage());
        }
        this.writer.println();
        for (JavaStackTraceEntry st : e.getStackTrace()) {
            this.w(tabs + 2).append("at ").append(st.getClassName()).append(".").append(st.getMethodName()).append("(").append(st.getFileName()).append(":").append("" + st.getLineNumber()).append(")").println();
        }
        JavaException cause = e.getCause();
        if (cause != null) {
            this.w(tabs + 2).println("Caused by:");
            this.printJavaException(cause, tabs + 1);
        }
    }

    protected void printChildren(int tabs, Node infoNode) {
        for (Node child : infoNode.getChildren()) {
            this.printNode(child, tabs + 4);
        }
    }

    private void writeQ7WaitInfo(int tabs, Node infoNode) {
        Q7WaitInfoRoot waitInfo = ReportHelper.getWaitInfo((Node)infoNode, (boolean)false);
        if (waitInfo != null) {
            this.writeQ7WaitInfo(tabs, waitInfo);
        }
    }

    public static String getType(Q7WaitInfoRoot info, Q7WaitInfo q7WaitInfo) {
        String type = (String)info.getTypesNames().get(q7WaitInfo.getTypeId());
        if (!TeslaFeatures.isIncludeIgnoredWaitDetails() && type.contains("(ignored)")) {
            return null;
        }
        return type;
    }

    public void writeQ7WaitInfo(int tabs, Q7WaitInfoRoot info) {
        String methodName;
        String className;
        String type;
        long totalTime;
        ArrayList infos = new ArrayList(info.getInfos());
        if (infos.size() == 0) {
            return;
        }
        Comparator<Q7WaitInfo> comparator = new Comparator<Q7WaitInfo>(){

            @Override
            public int compare(Q7WaitInfo info1, Q7WaitInfo info2) {
                return Long.compare(info1.getDuration(), info2.getDuration());
            }
        };
        Collections.sort(infos, Collections.reverseOrder(comparator));
        String classNameColumn = "Method name";
        String totalTimeColumn = "Time";
        int classNameLength = classNameColumn.length();
        int totalTimeLength = totalTimeColumn.length();
        boolean isEmpty = true;
        for (Q7WaitInfo q7WaitInfo : infos) {
            totalTime = q7WaitInfo.getDuration();
            type = RcpttReportGenerator.getType(info, q7WaitInfo);
            className = SimpleReportGenerator.getClassName((Q7WaitInfoRoot)info, (Q7WaitInfo)q7WaitInfo);
            if (type == null || !TeslaFeatures.isIncludeEclipseMethodsWaitDetails() && className.startsWith("org.eclipse") || totalTime == 0L) continue;
            methodName = String.format("%s: %s", type, className);
            if (methodName.length() > classNameLength) {
                classNameLength = methodName.length();
            }
            if (String.valueOf(totalTime).length() > totalTimeLength) {
                totalTimeLength = String.valueOf(totalTime).length();
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return;
        }
        this.writeTabs(tabs + 4).println("--> Wait details <--");
        this.writeTabs(tabs + 8).append(String.format("%" + -classNameLength + "s", classNameColumn)).append("   ").append(String.format("%" + -totalTimeLength + "s", totalTimeColumn)).println();
        for (Q7WaitInfo i : infos) {
            totalTime = i.getDuration();
            type = RcpttReportGenerator.getType(info, i);
            className = SimpleReportGenerator.getClassName((Q7WaitInfoRoot)info, (Q7WaitInfo)i);
            if (type == null || !TeslaFeatures.isIncludeEclipseMethodsWaitDetails() && className.startsWith("org.eclipse") || totalTime == 0L) continue;
            methodName = String.format("%s: %s", type, className);
            this.writeTabs(tabs + 8).append(String.format("%" + -classNameLength + "s", methodName)).append("   ").append(String.format("%" + totalTimeLength + "s", totalTime)).println();
            this.addWaitTime(type, className, totalTime);
        }
    }

    String kindToString(ItemKind kind, String name) {
        switch (kind) {
            case CONTEXT: {
                return "Context *" + name + "*";
            }
            case ECL_COMMAND: {
                return name;
            }
            case SCRIPT: {
                return "Script *" + name + "*";
            }
            case TESTCASE: {
                return "Test case *" + name + "*";
            }
            case TEST_SUITE: {
                return "Test suite *" + name + "*";
            }
            case VERIFICATION: {
                return "Verification *" + name + "*";
            }
        }
        return name;
    }

    private void writeQ7Info(int tabs, Node infoNode) {
        Q7Info q7Info = ReportHelper.getInfo((Node)infoNode);
        this.writeTabs(tabs);
        if (q7Info != null) {
            this.writer.append(this.kindToString(q7Info.getType(), infoNode.getName()));
            this.writer.append(" ").append("time: " + TimeFormatHelper.format((long)infoNode.getDuration())).println();
            this.writeResult(tabs + 1, q7Info.getResult());
        }
    }

    public void writeResult(int tabs, ProcessStatus result) {
        if (result == null) {
            result = RcpttPlugin.createProcessStatus((int)4, (String)"Null result");
        }
        if (SimpleSeverity.create((ProcessStatus)result) == SimpleSeverity.OK) {
            return;
        }
        this.w(tabs).append("Result: " + SimpleSeverity.create((ProcessStatus)result).name() + ", message: ").println(result.getMessage());
        RcpttReportGenerator.writeException(this.writer, tabs + 1, result.getException());
        for (ProcessStatus child : result.getChildren()) {
            this.writeResult(tabs + 1, child);
        }
    }

    private static void writeException(Writer writer, final int tabs, EclException exception) {
        if (exception == null) {
            return;
        }
        IndentedWriter iwriter = new IndentedWriter(writer){

            @Override
            public void writeIndent() {
                RcpttReportGenerator.writeTabs(this, tabs);
            }
        };
        ProcessStatusConverter.getThrowable((EclException)exception).printStackTrace(iwriter);
        iwriter.println();
        iwriter.flush();
    }

    public void writeLogsFromNode(int tabs, Node infoNode) {
        boolean haveEntries = false;
        for (LoggingCategory logCategory : LoggingCategory.VALUES) {
            String log = ReportBuilder.getLogs((Node)infoNode, (LoggingCategory)logCategory);
            if (StringUtils.isEmpty((String)log)) continue;
            if (!haveEntries) {
                haveEntries = true;
                this.writeTabs(tabs).println("--------------Logs BEGIN-------------------");
            }
            String[] stringArray = log.split("[\r\n]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String logLine = stringArray[n2];
                this.writeTabs(tabs).append(logLine).println();
                ++n2;
            }
        }
        if (haveEntries) {
            this.writeTabs(tabs).append("--------------Logs END-------------------").println();
        }
    }

    private void addWaitTime(String type, String className, long totalTime) {
        int totalTimeLength;
        if (!(type.equals("job") || type.equals("sync") || type.equals("async"))) {
            return;
        }
        if (!TeslaFeatures.isIncludeEclipseMethodsWaitDetails() && className.startsWith("org.eclipse")) {
            return;
        }
        String methodName = String.format("%s: %s", type, className);
        if (this.totalWaitTime.containsKey(methodName)) {
            totalTime += this.totalWaitTime.get(methodName).longValue();
        }
        this.totalWaitTime.put(methodName, totalTime);
        int methodNameLength = methodName.length();
        if (methodNameLength > this.maxMethodNameLength) {
            this.maxMethodNameLength = methodNameLength;
        }
        if ((totalTimeLength = String.valueOf(totalTime).length()) > this.maxTotalTimeLength) {
            this.maxTotalTimeLength = totalTimeLength;
        }
    }

    private void printTotalWaitTime() {
        int totalTimeLength;
        String totalWaitTimeTable = "Total wait time:";
        String methodNameColumn = "Method name";
        String totalTimeColumn = "Time";
        String noWaitInfoMessage = TeslaFeatures.isIncludeEclipseMethodsWaitDetails() ? "There were no methods RCPTT was waiting for" : "There were no third-party methods RCPTT was waiting for";
        int methodNameLength = methodNameColumn.length();
        if (methodNameLength > this.maxMethodNameLength) {
            this.maxMethodNameLength = methodNameLength;
        }
        if ((totalTimeLength = totalTimeColumn.length()) > this.maxTotalTimeLength) {
            this.maxTotalTimeLength = totalTimeLength;
        }
        this.writer.println();
        this.writer.append(totalWaitTimeTable).println();
        if (this.totalWaitTime.isEmpty()) {
            this.writer.append("  ").append(noWaitInfoMessage).println();
            return;
        }
        this.writer.append("  ").append(String.format("%" + -this.maxMethodNameLength + "s", methodNameColumn)).append("   ").append(String.format("%" + -this.maxTotalTimeLength + "s", totalTimeColumn)).println();
        List<Map.Entry<String, Long>> sortedTable = this.getSortedTimeTable(this.totalWaitTime);
        for (Map.Entry<String, Long> entry : sortedTable) {
            this.writer.append("  ").append(String.format("%" + -this.maxMethodNameLength + "s", entry.getKey())).append("   ").append(String.format("%" + this.maxTotalTimeLength + "s", entry.getValue())).println();
        }
    }

    private List<Map.Entry<String, Long>> getSortedTimeTable(Map<String, Long> unsortedMap) {
        Comparator<Map.Entry<String, Long>> comparator = new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> entry1, Map.Entry<String, Long> entry2) {
                return entry1.getValue().compareTo(entry2.getValue());
            }
        };
        LinkedList<Map.Entry<String, Long>> sortedTable = new LinkedList<Map.Entry<String, Long>>(unsortedMap.entrySet());
        Collections.sort(sortedTable, Collections.reverseOrder(comparator));
        return sortedTable;
    }
}

