/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.testrail;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.rcptt.internal.testrail.Messages;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class TestRailPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.testrail";
    public static final String LAUNCH_TESTRUNID = "org.eclipse.rcptt.testrail.ATTR_TESTRAIL_TESTRUNID";
    public static final String TESTRAIL_STATE = "TESTRAIL_STATE";
    public static final String TESTRAIL_ADDRESS = "TESTRAIL_ADDRESS";
    public static final String TESTRAIL_USERNAME = "TESTRAIL_USERNAME";
    public static final String TESTRAIL_PASSWORD = "TESTRAIL_PASSWORD";
    public static final String TESTRAIL_PROJECTID = "TESTRAIL_PROJECTID";
    public static final String TESTRAIL_USEUNICODE = "TESTRAIL_USEUNICODE";
    public static final int DEFAULT_TESTRAIL_STATE = 0;
    public static final String DEFAULT_TESTRAIL_PROJECTID = "P1";
    public static final int DEFAULT_TESTRAIL_USEUNICODE = 0;
    private static TestRailPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static TestRailPlugin getDefault() {
        return plugin;
    }

    public static void logInfo(String message) {
        String loggingEnabled = TeslaFeatures.getInstance().getValue("com.xored.testengine.logs");
        if ("true".equals(loggingEnabled)) {
            TestRailPlugin.log(TestRailPlugin.createStatus(1, message));
        }
    }

    public static void log(Throwable t) {
        TestRailPlugin.log(t.getMessage(), t);
    }

    public static void log(String message, Throwable t) {
        TestRailPlugin.log(TestRailPlugin.createStatus(message, t));
    }

    public static void log(String message) {
        TestRailPlugin.log(TestRailPlugin.createStatus(message));
    }

    public static void log(IStatus status) {
        if (TestRailPlugin.getDefault() != null) {
            TestRailPlugin.getDefault().getLog().log(status);
        }
    }

    public static IStatus createStatus(String message) {
        return TestRailPlugin.createStatus(4, message, null);
    }

    public static IStatus createStatus(int state, String message) {
        return TestRailPlugin.createStatus(state, message, null);
    }

    public static IStatus createStatus(String message, Throwable t) {
        return TestRailPlugin.createStatus(4, message, t);
    }

    public static IStatus createStatus(int state, String message, Throwable t) {
        return new Status(state, PLUGIN_ID, message, t);
    }

    public static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public static ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node(PLUGIN_ID);
    }

    public static boolean getTestRailState() {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        return preferences.getInt(TESTRAIL_STATE, 0) == 1;
    }

    public static void setTestRailState(int state) {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        preferences.putInt(TESTRAIL_STATE, state);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailPlugin_ErrorWhileSaving, TESTRAIL_STATE), e);
        }
    }

    public static String getTestRailAddress() {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        return preferences.get(TESTRAIL_ADDRESS, "");
    }

    public static void setTestRailAddress(String address) {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        preferences.put(TESTRAIL_ADDRESS, address);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailPlugin_ErrorWhileSaving, TESTRAIL_ADDRESS), e);
        }
    }

    public static String getTestRailUsername() {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        return preferences.get(TESTRAIL_USERNAME, "");
    }

    public static void setTestRailUsername(String username) {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        preferences.put(TESTRAIL_USERNAME, username);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailPlugin_ErrorWhileSaving, TESTRAIL_USERNAME), e);
        }
    }

    public static String getTestRailPassword() {
        ISecurePreferences preferences = TestRailPlugin.getSecurePreferences();
        try {
            return preferences.get(TESTRAIL_PASSWORD, "");
        }
        catch (StorageException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailPlugin_ErrorWhileGetting, TESTRAIL_PASSWORD), e);
            return null;
        }
    }

    public static void setTestRailPassword(String password) {
        ISecurePreferences preferences = TestRailPlugin.getSecurePreferences();
        try {
            preferences.put(TESTRAIL_PASSWORD, password, true);
            preferences.flush();
        }
        catch (IOException | StorageException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailPlugin_ErrorWhileSaving, TESTRAIL_PASSWORD), e);
        }
    }

    public static String getTestRailProjectId() {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        return preferences.get(TESTRAIL_PROJECTID, DEFAULT_TESTRAIL_PROJECTID);
    }

    public static void setTestRailProjectId(String projectId) {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        preferences.put(TESTRAIL_PROJECTID, projectId);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailPlugin_ErrorWhileSaving, TESTRAIL_PROJECTID), e);
        }
    }

    public static boolean getTestRailUseUnicode() {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        return preferences.getInt(TESTRAIL_USEUNICODE, 0) == 1;
    }

    public static void setTestRailUseUnicode(int state) {
        IEclipsePreferences preferences = TestRailPlugin.getPreferences();
        preferences.putInt(TESTRAIL_USEUNICODE, state);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailPlugin_ErrorWhileSaving, TESTRAIL_USEUNICODE), e);
        }
    }
}

