/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.plain;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.rcptt.core.persistence.plain.IPlainConstants;
import org.eclipse.rcptt.core.persistence.plain.MapMaker;
import org.eclipse.rcptt.util.Base64;
import org.eclipse.rcptt.util.FileUtil;

public class PlainWriter
implements IPlainConstants,
Closeable {
    private OutputStream out;
    private OutputStreamWriter writer;
    private String plainStoreFormat;

    public PlainWriter(OutputStream bout, String plainHeader) throws IOException {
        this.out = bout;
        this.plainStoreFormat = plainHeader;
        this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.out), "utf-8");
    }

    private void write(String str) throws IOException {
        this.writer.write(str + "\n");
    }

    public void writeHeader(Map<String, String> attrs) throws IOException {
        this.write(this.getPlainFormat());
        this.writeAttributes(new MapMaker<String, String>().set("Format-Version", "1.0"));
        this.writeAttributes(attrs);
        this.write("");
    }

    protected String getPlainFormat() {
        return this.plainStoreFormat;
    }

    private void writeAttributes(Map<String, String> attrs) throws IOException {
        if (attrs != null) {
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            sorted.putAll(attrs);
            for (Map.Entry entry : sorted.entrySet()) {
                this.write((String)entry.getKey() + ": " + FileUtil.escape((String)((String)entry.getValue())));
            }
        }
    }

    public void writeNode(String name, Map<String, String> attrs, Object content) throws IOException {
        UUID id = UUID.nameUUIDFromBytes(name.getBytes("utf-8"));
        String currentNode = name + "-" + id.toString();
        this.write("------=_" + currentNode);
        if (attrs == null) {
            attrs = new HashMap<String, String>();
        }
        attrs.put("Entry-Name", name);
        String curType = attrs.get("Content-Type");
        if (content instanceof String) {
            if (curType == null || !curType.contains("text")) {
                attrs.put("Content-Type", "text/plain");
            }
        } else if (content instanceof byte[] && (curType == null || !curType.contains("binary"))) {
            attrs.put("Content-Type", "q7/binary");
        }
        this.writeAttributes(attrs);
        this.write("");
        if (content instanceof String) {
            this.writeContent((String)content);
        } else if (content instanceof byte[]) {
            this.writeContent((byte[])content);
        }
        this.write("------=_" + currentNode + "--");
    }

    private void writeContent(String content) throws IOException {
        this.writer.write(content);
        this.write("");
    }

    private void writeContent(byte[] binary) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream zout = new ZipOutputStream(bout);){
            ZipEntry e = new ZipEntry(".content");
            e.setTime(1L);
            zout.putNextEntry(e);
            zout.write(binary);
            zout.close();
            String encode = Base64.encode((byte[])bout.toByteArray());
            int len = encode.length();
            int chunks = len / 80;
            int i = 0;
            while (i < chunks) {
                this.write(encode.substring(i * 80, (i + 1) * 80));
                ++i;
            }
            this.write(encode.substring(chunks * 80));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

