/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.client.tcp;

import org.eclipse.rcptt.ecl.client.tcp.EclTcpClientPlugin;

public class NetworkUtil {
    private static final String JRE_CONNECT_TIMEOUT_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String JRE_READ_TIMEOUT_PROPERTY = "sun.net.client.defaultReadTimeout";

    public static void initTimeouts() {
        NetworkUtil.setTimeout(JRE_CONNECT_TIMEOUT_PROPERTY, NetworkUtil.getConnectTimeout());
        NetworkUtil.setTimeout(JRE_READ_TIMEOUT_PROPERTY, NetworkUtil.getReadTimeout());
    }

    private static int getExistingTimeout(String propName) {
        String val = System.getProperty(propName, "-1");
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static void setTimeout(String prop, int val) {
        int existingTimeout = NetworkUtil.getExistingTimeout(prop);
        if (existingTimeout == -1) {
            EclTcpClientPlugin.logInfo("%s is not set. Setting to %d", prop, val);
        } else if (existingTimeout < val) {
            EclTcpClientPlugin.logInfo("%s is set to %d. Increasing to %d", prop, existingTimeout, val);
        }
        System.setProperty(prop, Integer.toString(val));
    }

    private static int getReadTimeout() {
        return 120000;
    }

    private static int getConnectTimeout() {
        return 60000;
    }
}

