/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.util.ASTHelper;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class InitializeFinalFieldProposalCore
extends LinkedCorrectionProposalCore {
    private IProblemLocation fProblem;
    private ASTNode fAstNode;
    private final IVariableBinding fVariableBinding;
    private int fupdateType;
    public static final int UPDATE_AT_DECLARATION = 0;
    public static final int UPDATE_AT_CONSTRUCTOR = 1;
    public static final int UPDATE_CONSTRUCTOR_NEW_PARAMETER = 2;

    public InitializeFinalFieldProposalCore(IProblemLocation problem, ICompilationUnit cu, ASTNode astNode, IVariableBinding variableBinding, int relevance) {
        super(Messages.format(CorrectionMessages.InitializeFieldAtDeclarationCorrectionProposal_description, problem.getProblemArguments()[0]), cu, (ASTRewrite)null, relevance);
        this.fProblem = problem;
        this.fAstNode = astNode;
        this.fVariableBinding = variableBinding;
        this.fupdateType = 0;
    }

    public InitializeFinalFieldProposalCore(IProblemLocation problem, ICompilationUnit cu, ASTNode astNode, int relevance, int updateType) {
        super(Messages.format(CorrectionMessages.InitializeFieldInConstructorCorrectionProposal_description, problem.getProblemArguments()[0]), cu, (ASTRewrite)null, relevance);
        if (updateType == 2) {
            this.setDisplayName(Messages.format(CorrectionMessages.InitializeFieldWithConstructorParameterCorrectionProposal_description, problem.getProblemArguments()[0]));
        }
        this.fProblem = problem;
        this.fAstNode = astNode;
        this.fVariableBinding = null;
        this.fupdateType = updateType;
    }

    public boolean hasProposal() throws CoreException {
        return this.getRewrite() != null;
    }

    @Override
    public ASTRewrite getRewrite() throws CoreException {
        switch (this.fupdateType) {
            case 1: {
                if (this.fAstNode != null && this.fAstNode.getParent() instanceof RecordDeclaration && ASTHelper.isRecordDeclarationNodeSupportedInAST(this.fAstNode.getAST())) {
                    return this.doInitRecordComponentsInConstructor();
                }
                return this.doInitFieldInConstructor();
            }
            case 0: {
                return this.doInitField();
            }
            case 2: {
                return this.doUpdateConstructorWithParameter();
            }
        }
        return null;
    }

    private ASTRewrite doInitField() {
        FieldDeclaration field = this.getFieldDeclaration(this.fVariableBinding.getName());
        if (field == null) {
            return null;
        }
        AST ast = this.fAstNode.getAST();
        ITypeBinding type = this.fVariableBinding.getType();
        String variableTypeName = type.getName();
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        newFragment.setName(ast.newSimpleName(this.fVariableBinding.getName()));
        FieldDeclaration declaration = ast.newFieldDeclaration(newFragment);
        declaration.modifiers().addAll(ast.newModifiers(this.fVariableBinding.getModifiers()));
        NumberLiteral expression = null;
        if (type.isPrimitive()) {
            declaration.setType((Type)ast.newPrimitiveType(PrimitiveType.toCode((String)variableTypeName)));
            expression = ast.newNumberLiteral();
        } else if ("String".equals(variableTypeName)) {
            declaration.setType((Type)ast.newSimpleType(ast.newName(variableTypeName)));
            expression = ast.newStringLiteral();
        } else {
            Object newType = null;
            newType = type.isParameterizedType() ? this.createParameterizedType(ast, type) : ast.newSimpleType(ast.newName(variableTypeName));
            declaration.setType(newType);
            if (this.hasDefaultConstructor()) {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                cic.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)newType));
                expression = cic;
            } else {
                expression = ast.newNullLiteral();
            }
        }
        newFragment.setInitializer((Expression)expression);
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        rewrite.replace((ASTNode)field, (ASTNode)declaration, null);
        this.setEndPosition(rewrite.track((ASTNode)expression));
        return rewrite;
    }

    private Type createParameterizedType(AST ast, ITypeBinding typeBinding) {
        if (typeBinding.isParameterizedType() && !typeBinding.isRawType()) {
            SimpleType baseType = ast.newSimpleType(ASTNodeFactory.newName(ast, typeBinding.getErasure().getName()));
            ParameterizedType newType = ast.newParameterizedType((Type)baseType);
            int i = 0;
            while (i < typeBinding.getTypeArguments().length) {
                ITypeBinding typeArg = typeBinding.getTypeArguments()[i];
                Type argType = this.createParameterizedType(ast, typeArg);
                newType.typeArguments().add(argType);
                ++i;
            }
            return newType;
        }
        if (!typeBinding.isTypeVariable()) {
            if (typeBinding.isWildcardType()) {
                ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fAstNode.getRoot());
                return importRewrite.addImport(typeBinding, ast);
            }
            return ast.newSimpleType(ASTNodeFactory.newName(ast, typeBinding.getErasure().getName()));
        }
        return ast.newSimpleType((Name)ast.newSimpleName(typeBinding.getName()));
    }

    private ASTRewrite doInitRecordComponentsInConstructor() {
        String variableName = this.fProblem.getProblemArguments()[0];
        SingleVariableDeclaration svd = this.getRecordComponentDeclaration(variableName);
        if (svd == null) {
            return null;
        }
        AST ast = svd.getAST();
        FieldAccess fieldAccess = ast.newFieldAccess();
        fieldAccess.setName(ast.newSimpleName(variableName));
        fieldAccess.setExpression((Expression)ast.newThisExpression());
        Assignment assignment = ast.newAssignment();
        assignment.setLeftHandSide((Expression)fieldAccess);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        Type fieldType = svd.getType();
        if (fieldType.isPrimitiveType()) {
            assignment.setRightHandSide((Expression)ast.newNumberLiteral());
        } else if ("String".equals(fieldType.toString())) {
            assignment.setRightHandSide((Expression)ast.newStringLiteral());
        } else if (this.hasDefaultConstructor(fieldType.resolveBinding())) {
            ClassInstanceCreation cic = ast.newClassInstanceCreation();
            cic.setType((Type)ast.newSimpleType(ast.newName(fieldType.toString())));
            assignment.setRightHandSide((Expression)cic);
        } else {
            assignment.setRightHandSide((Expression)ast.newNullLiteral());
        }
        ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ConstructorVisitor cv = new ConstructorVisitor(((RecordDeclaration)svd.getParent()).getName().toString());
        this.fAstNode.getRoot().accept((ASTVisitor)cv);
        for (MethodDeclaration md : cv.getNodes()) {
            if (!this.isCanonical(md)) continue;
            Block body = md.getBody();
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, 0, null);
            this.setEndPosition(rewrite.track((ASTNode)assignment));
        }
        return rewrite;
    }

    private boolean isCanonical(MethodDeclaration md) {
        IMethodBinding methodBinding = md.resolveBinding();
        return methodBinding == null ? false : methodBinding.isCanonicalConstructor();
    }

    private ASTRewrite doUpdateConstructorWithParameter() {
        String variableName = this.fProblem.getProblemArguments()[0];
        FieldDeclaration field = this.getFieldDeclaration(variableName);
        if (field == null) {
            return null;
        }
        Type fieldType = field.getType();
        ITypeBinding fieldBinding = fieldType.resolveBinding();
        if (fieldBinding == null) {
            return null;
        }
        ConstructorVisitor cv = new ConstructorVisitor(((AbstractTypeDeclaration)field.getParent()).getName().toString());
        this.fAstNode.getRoot().accept((ASTVisitor)cv);
        if (cv.getNodes().size() != 1) {
            return null;
        }
        MethodDeclaration methodDeclaration = cv.getNodes().get(0);
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        if (methodBinding == null) {
            return null;
        }
        AST ast = field.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        SingleVariableDeclaration newSingleVariableDeclaration = ast.newSingleVariableDeclaration();
        String[] excludedNames = this.collectParameterNames(methodDeclaration);
        String newName = StubUtility.suggestArgumentName(this.getCompilationUnit().getJavaProject(), variableName, excludedNames);
        newSingleVariableDeclaration.setName(ast.newSimpleName(newName));
        Type copyType = ASTNodes.copySubtree(ast, fieldType);
        newSingleVariableDeclaration.setType(copyType);
        FieldAccess fieldAccess = ast.newFieldAccess();
        fieldAccess.setName(ast.newSimpleName(variableName));
        fieldAccess.setExpression((Expression)ast.newThisExpression());
        Assignment assignment = ast.newAssignment();
        assignment.setLeftHandSide((Expression)fieldAccess);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide((Expression)ast.newSimpleName(newName));
        ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
        rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)newSingleVariableDeclaration, null);
        Block body = methodDeclaration.getBody();
        if (!this.hasThisCall(body)) {
            List decls = ((AbstractTypeDeclaration)methodDeclaration.getParent()).bodyDeclarations();
            List<String> finalFieldList = this.getFinalFieldList(decls);
            int insertIndex = 0;
            if (finalFieldList.size() > 1) {
                int findFirstFinalFieldReferenceIndex = this.findFirstFinalFieldReferenceIndex(body.statements(), variableName);
                int findFinalFieldInsertIndex = this.findFinalFieldAssignmentInsertIndex(body.statements(), variableName, finalFieldList);
                int index = findFirstFinalFieldReferenceIndex == -1 ? findFinalFieldInsertIndex : findFirstFinalFieldReferenceIndex;
                insertIndex = Math.min(body.statements().size(), Math.min(findFinalFieldInsertIndex, index));
            }
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, insertIndex, null);
            this.setEndPosition(rewrite.track((ASTNode)assignment));
        }
        return rewrite;
    }

    private String[] collectParameterNames(MethodDeclaration methodDeclaration) {
        final ArrayList<String> names = new ArrayList<String>();
        for (Object element : methodDeclaration.parameters()) {
            SingleVariableDeclaration svd = (SingleVariableDeclaration)element;
            names.add(svd.getName().getIdentifier());
        }
        ASTVisitor v = new ASTVisitor(){

            public boolean visit(VariableDeclarationFragment node) {
                names.add(node.getName().getIdentifier());
                return super.visit(node);
            }
        };
        methodDeclaration.accept(v);
        return names.toArray(new String[names.size()]);
    }

    private ASTRewrite doInitFieldInConstructor() {
        String variableName = this.fProblem.getProblemArguments()[0];
        FieldDeclaration field = this.getFieldDeclaration(variableName);
        if (field == null) {
            return null;
        }
        AST ast = field.getAST();
        FieldAccess fieldAccess = ast.newFieldAccess();
        fieldAccess.setName(ast.newSimpleName(variableName));
        fieldAccess.setExpression((Expression)ast.newThisExpression());
        Assignment assignment = ast.newAssignment();
        assignment.setLeftHandSide((Expression)fieldAccess);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        Type fieldType = field.getType();
        if (fieldType.isPrimitiveType()) {
            assignment.setRightHandSide((Expression)ast.newNumberLiteral());
        } else if ("String".equals(fieldType.toString())) {
            assignment.setRightHandSide((Expression)ast.newStringLiteral());
        } else if (this.hasDefaultConstructor(fieldType.resolveBinding())) {
            ClassInstanceCreation cic = ast.newClassInstanceCreation();
            cic.setType((Type)ast.newSimpleType(ast.newName(fieldType.toString())));
            assignment.setRightHandSide((Expression)cic);
        } else {
            assignment.setRightHandSide((Expression)ast.newNullLiteral());
        }
        ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ConstructorVisitor cv = new ConstructorVisitor(((AbstractTypeDeclaration)field.getParent()).getName().toString());
        this.fAstNode.getRoot().accept((ASTVisitor)cv);
        for (MethodDeclaration md : cv.getNodes()) {
            Block body = md.getBody();
            if (this.hasThisCall(body) || this.hasFieldInitialization(body, variableName)) continue;
            List decls = ((AbstractTypeDeclaration)md.getParent()).bodyDeclarations();
            List<String> finalFieldList = this.getFinalFieldList(decls);
            int insertIndex = 0;
            if (finalFieldList.size() > 1) {
                int findFirstFinalFieldReferenceIndex = this.findFirstFinalFieldReferenceIndex(body.statements(), variableName);
                int findFinalFieldInsertIndex = this.findFinalFieldAssignmentInsertIndex(body.statements(), variableName, finalFieldList);
                int index = findFirstFinalFieldReferenceIndex == -1 ? findFinalFieldInsertIndex : findFirstFinalFieldReferenceIndex;
                insertIndex = Math.min(body.statements().size(), Math.min(findFinalFieldInsertIndex, index));
            }
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, insertIndex, null);
            this.setEndPosition(rewrite.track((ASTNode)assignment));
        }
        return rewrite;
    }

    private boolean hasFieldInitialization(Block body, final String variableName) {
        final boolean[] hasInit = new boolean[1];
        ASTVisitor v = new ASTVisitor(){

            public boolean visit(SimpleName node) {
                if (!node.getIdentifier().equals(variableName)) {
                    return true;
                }
                Assignment assignNode = ASTNodes.getFirstAncestorOrNull((ASTNode)node, Assignment.class);
                if (assignNode != null) {
                    Expression lhs = assignNode.getLeftHandSide();
                    IBinding resolveBinding = node.resolveBinding();
                    if (resolveBinding != null && ((IVariableBinding)resolveBinding).isField()) {
                        String name;
                        int nodeType = lhs.getNodeType();
                        if (nodeType == 42) {
                            String name2 = ((SimpleName)lhs).getIdentifier();
                            if (variableName.equals(name2)) {
                                hasInit[0] = true;
                                return false;
                            }
                        } else if (nodeType == 22 && variableName.equals(name = ((FieldAccess)lhs).getName().getIdentifier())) {
                            hasInit[0] = true;
                            return false;
                        }
                    }
                }
                return true;
            }
        };
        body.accept(v);
        return hasInit[0];
    }

    private List<String> getFinalFieldList(List<ASTNode> fieldDeclarations) {
        ArrayList<String> list = new ArrayList<String>();
        for (ASTNode astNode : fieldDeclarations) {
            int modifiers;
            if (!(astNode instanceof FieldDeclaration) || !Modifier.isFinal((int)(modifiers = ((FieldDeclaration)astNode).getModifiers()))) continue;
            for (Object object : ((FieldDeclaration)astNode).fragments()) {
                list.add(((VariableDeclarationFragment)object).getName().getIdentifier());
            }
        }
        return list;
    }

    private int findFinalFieldAssignmentInsertIndex(List<ASTNode> astNodes, String variableName, final List<String> finalFieldList) {
        int index = 0;
        int fieldIndex = 0;
        int findFinalFieldDeclarationIndex = finalFieldList.indexOf(variableName);
        final String[] fieldAccess = new String[1];
        for (ASTNode astNode : astNodes) {
            fieldAccess[0] = null;
            ASTVisitor v = new ASTVisitor(){

                public boolean visit(FieldAccess node) {
                    fieldAccess[0] = node.getName().getIdentifier();
                    return false;
                }

                public boolean visit(SimpleName node) {
                    IBinding resolveBinding;
                    Assignment assignNode = ASTNodes.getFirstAncestorOrNull((ASTNode)node, Assignment.class);
                    if (assignNode != null && (resolveBinding = node.resolveBinding()) instanceof IVariableBinding && ((IVariableBinding)resolveBinding).isField() && resolveBinding.getKind() == 3 && finalFieldList.contains(node.getIdentifier())) {
                        fieldAccess[0] = node.getIdentifier();
                        return false;
                    }
                    return true;
                }
            };
            astNode.accept(v);
            if (fieldAccess[0] == null) {
                ++index;
                continue;
            }
            String fieldId = fieldAccess[0];
            int indexOfField = finalFieldList.indexOf(fieldId);
            fieldIndex = index;
            if (indexOfField > findFinalFieldDeclarationIndex) {
                return fieldIndex;
            }
            ++fieldIndex;
            ++index;
        }
        return fieldIndex;
    }

    private int findFirstFinalFieldReferenceIndex(List<ASTNode> astNodes, String variableName) {
        int index = 0;
        final String[] fieldAccess = new String[1];
        for (ASTNode astNode : astNodes) {
            fieldAccess[0] = null;
            ASTVisitor v = new ASTVisitor(){

                public boolean visit(FieldAccess node) {
                    fieldAccess[0] = node.getName().getIdentifier();
                    return false;
                }

                public boolean visit(SimpleName node) {
                    IBinding resolveBinding = node.resolveBinding();
                    if (resolveBinding != null && resolveBinding.getKind() == 3 && ((IVariableBinding)resolveBinding).isField()) {
                        fieldAccess[0] = node.getIdentifier();
                        return false;
                    }
                    return true;
                }
            };
            astNode.accept(v);
            if (fieldAccess[0] != null && fieldAccess[0].equals(variableName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean hasThisCall(Block body) {
        for (Object object : body.statements()) {
            if (((ASTNode)object).getNodeType() != 17) continue;
            return true;
        }
        return false;
    }

    private boolean hasDefaultConstructor(ITypeBinding type) {
        IMethodBinding[] iMethodBindingArray = type.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding mb = iMethodBindingArray[n2];
            String key = mb.getKey();
            if (key.contains(";.()V")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasDefaultConstructor() {
        return this.hasDefaultConstructor(this.fVariableBinding.getType());
    }

    private FieldDeclaration getFieldDeclaration(String name) {
        FieldVisitor fieldVisitor = new FieldVisitor();
        this.fAstNode.getRoot().accept((ASTVisitor)fieldVisitor);
        for (FieldDeclaration f : fieldVisitor.getNodes()) {
            for (Object object : f.fragments()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)object;
                if (!fragment.getName().getIdentifier().equals(name)) continue;
                return f;
            }
        }
        return null;
    }

    private SingleVariableDeclaration getRecordComponentDeclaration(String name) {
        RecordComponentVisitor recordComponentVisitor = new RecordComponentVisitor();
        this.fAstNode.getRoot().accept((ASTVisitor)recordComponentVisitor);
        for (SingleVariableDeclaration f : recordComponentVisitor.getNodes()) {
            if (!f.getName().getIdentifier().equals(name)) continue;
            return f;
        }
        return null;
    }

    private static final class ConstructorVisitor
    extends ASTVisitor {
        private final List<MethodDeclaration> fNodes = new ArrayList<MethodDeclaration>();
        private String fTypeName;

        public ConstructorVisitor(String typeName) {
            this.fTypeName = typeName;
        }

        public boolean visit(MethodDeclaration node) {
            if (node.getName().toString().equals(this.fTypeName)) {
                this.fNodes.add(node);
            }
            return true;
        }

        public List<MethodDeclaration> getNodes() {
            return this.fNodes;
        }
    }

    private static final class FieldVisitor
    extends ASTVisitor {
        private final List<FieldDeclaration> fNodes = new ArrayList<FieldDeclaration>();

        public boolean visit(FieldDeclaration node) {
            this.fNodes.add(node);
            return true;
        }

        public List<FieldDeclaration> getNodes() {
            return this.fNodes;
        }
    }

    private static final class RecordComponentVisitor
    extends ASTVisitor {
        private final List<SingleVariableDeclaration> fNodes = new ArrayList<SingleVariableDeclaration>();

        public boolean visit(RecordDeclaration node) {
            List decl = node.recordComponents();
            if (decl != null) {
                this.fNodes.addAll(decl);
            }
            return true;
        }

        public List<SingleVariableDeclaration> getNodes() {
            return this.fNodes;
        }
    }
}

