/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import org.apache.poi.ss.formula.ptg.ScalarConstantPtg;
import org.apache.poi.ss.usermodel.ErrorConstants;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class ErrPtg
extends ScalarConstantPtg {
    private static final ErrorConstants EC = null;
    public static final ErrPtg NULL_INTERSECTION = new ErrPtg(0);
    public static final ErrPtg DIV_ZERO = new ErrPtg(7);
    public static final ErrPtg VALUE_INVALID = new ErrPtg(15);
    public static final ErrPtg REF_INVALID = new ErrPtg(23);
    public static final ErrPtg NAME_INVALID = new ErrPtg(29);
    public static final ErrPtg NUM_ERROR = new ErrPtg(36);
    public static final ErrPtg N_A = new ErrPtg(42);
    public static final short sid = 28;
    private static final int SIZE = 2;
    private final int field_1_error_code;

    private ErrPtg(int errorCode) {
        if (!ErrorConstants.isValidCode(errorCode)) {
            throw new IllegalArgumentException("Invalid error code (" + errorCode + ")");
        }
        this.field_1_error_code = errorCode;
    }

    public static ErrPtg read(LittleEndianInput in) {
        return ErrPtg.valueOf(in.readByte());
    }

    public void write(LittleEndianOutput out) {
        out.writeByte(28 + this.getPtgClass());
        out.writeByte(this.field_1_error_code);
    }

    public String toFormulaString() {
        return ErrorConstants.getText(this.field_1_error_code);
    }

    public int getSize() {
        return 2;
    }

    public int getErrorCode() {
        return this.field_1_error_code;
    }

    public static ErrPtg valueOf(int code) {
        switch (code) {
            case 7: {
                return DIV_ZERO;
            }
            case 42: {
                return N_A;
            }
            case 29: {
                return NAME_INVALID;
            }
            case 0: {
                return NULL_INTERSECTION;
            }
            case 36: {
                return NUM_ERROR;
            }
            case 23: {
                return REF_INVALID;
            }
            case 15: {
                return VALUE_INVALID;
            }
        }
        throw new RuntimeException("Unexpected error code (" + code + ")");
    }
}

