/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

public class PluginReference {
    private IFeaturePlugin reference;
    private IPluginModelBase model;
    private boolean fragment;

    public PluginReference(IFeaturePlugin reference, IPluginModelBase model) {
        this.reference = reference;
        this.model = model;
    }

    public IPluginModelBase getModel() {
        return this.model;
    }

    public IFeaturePlugin getReference() {
        return this.reference;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public boolean isInSync() {
        if (this.model == null) {
            return false;
        }
        if (this.reference == null) {
            return true;
        }
        if (!this.reference.getId().equals(this.model.getPluginBase().getId())) {
            return false;
        }
        return this.reference.getVersion().equals(this.model.getPluginBase().getVersion());
    }

    public boolean isUnresolved() {
        return false;
    }

    public void setFragment(boolean newFragment) {
        this.fragment = newFragment;
    }

    public void setModel(IPluginModelBase newModel) {
        this.model = newModel;
    }

    public void setReference(IFeaturePlugin newReference) {
        this.reference = newReference;
    }

    public String toString() {
        String name = this.model.getPluginBase().getName();
        return this.model.getResourceString(name);
    }
}

