/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.nio.file.FileSystem;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.client.subsystem.sftp.impl.DefaultSftpClientFactory;

public interface SftpClientFactory {
    public static SftpClientFactory instance() {
        return DefaultSftpClientFactory.INSTANCE;
    }

    default public SftpClient createSftpClient(ClientSession session) throws IOException {
        return this.createSftpClient(session, SftpVersionSelector.CURRENT);
    }

    default public SftpClient createSftpClient(ClientSession session, int version) throws IOException {
        return this.createSftpClient(session, SftpVersionSelector.fixedVersionSelector(version));
    }

    public SftpClient createSftpClient(ClientSession var1, SftpVersionSelector var2) throws IOException;

    default public FileSystem createSftpFileSystem(ClientSession session) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.CURRENT);
    }

    default public FileSystem createSftpFileSystem(ClientSession session, int version) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.fixedVersionSelector(version));
    }

    default public FileSystem createSftpFileSystem(ClientSession session, SftpVersionSelector selector) throws IOException {
        return this.createSftpFileSystem(session, selector, 32768, 32768);
    }

    default public FileSystem createSftpFileSystem(ClientSession session, int version, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.fixedVersionSelector(version), readBufferSize, writeBufferSize);
    }

    default public FileSystem createSftpFileSystem(ClientSession session, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.CURRENT, readBufferSize, writeBufferSize);
    }

    public FileSystem createSftpFileSystem(ClientSession var1, SftpVersionSelector var2, int var3, int var4) throws IOException;
}

