/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.ui.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.cmake.ui.internal.Activator;
import org.eclipse.cdt.cmake.ui.internal.CMakePropertyCombo;
import org.eclipse.cdt.cmake.ui.internal.CMakePropertyText;
import org.eclipse.cdt.cmake.ui.internal.ICMakePropertyPageControl;
import org.eclipse.cdt.cmake.ui.internal.Messages;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildCommandLauncher;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class CMakePropertyPage
extends PropertyPage {
    private List<ICMakePropertyPageControl> componentList = new ArrayList<ICMakePropertyPageControl>();

    protected Control createContents(final Composite parent) {
        Composite composite;
        block11: {
            composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)new GridLayout());
            boolean isContainerBuild = false;
            ICBuildConfiguration cconfig = null;
            IProject project = (IProject)this.getElement();
            try {
                IBuildConfiguration config = project.getActiveBuildConfig();
                cconfig = (ICBuildConfiguration)config.getAdapter(ICBuildConfiguration.class);
                IToolChain toolChain = cconfig.getToolChain();
                String os = toolChain.getProperty("os");
                isContainerBuild = os.equals("linux-container");
            }
            catch (CoreException e2) {
                MessageDialog.openError((Shell)parent.getShell(), (String)Messages.CMakePropertyPage_FailedToGetOS_Title, (String)(String.valueOf(Messages.CMakePropertyPage_FailedToGetOS_Body) + e2.getMessage()));
            }
            if (isContainerBuild) {
                try {
                    ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class));
                    launcher.setProject(project);
                    if (launcher instanceof ICBuildCommandLauncher) {
                        ((ICBuildCommandLauncher)launcher).setBuildConfiguration(cconfig);
                    }
                    IPath buildPath = project.getLocation().append("build").append(((CBuildConfiguration)cconfig).getName());
                    Process p = launcher.execute((IPath)new Path("cmake"), new String[]{"-LAH", "."}, new String[0], buildPath, (IProgressMonitor)new NullProgressMonitor());
                    if (p == null) break block11;
                    ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                    ByteArrayOutputStream stderr = new ByteArrayOutputStream();
                    int rc = -1;
                    try {
                        if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new NullProgressMonitor()) == 0) {
                            p.waitFor();
                        }
                        rc = p.exitValue();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (rc == 0) {
                        this.componentList = this.parseConfigureOutput(stdout, composite);
                    }
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)parent.getShell(), (String)Messages.CMakePropertyPage_FailedToGetCMakeConfiguration_Title, (String)(String.valueOf(Messages.CMakePropertyPage_FailedToGetCMakeConfiguration_Body) + e.getMessage()));
                }
            } else {
                Button b = new Button(composite, 0);
                b.setText(Messages.CMakePropertyPage_LaunchCMakeGui);
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IProject project = (IProject)CMakePropertyPage.this.getElement();
                        try {
                            String configName = project.getActiveBuildConfig().getName();
                            String sourceDir = project.getLocation().toOSString();
                            String buildDir = project.getLocation().append("build").append(configName).toOSString();
                            Runtime.getRuntime().exec(new String[]{"cmake-gui", "-H" + sourceDir, "-B" + buildDir});
                        }
                        catch (IOException | CoreException e1) {
                            MessageDialog.openError((Shell)parent.getShell(), (String)Messages.CMakePropertyPage_FailedToStartCMakeGui_Title, (String)(String.valueOf(Messages.CMakePropertyPage_FailedToStartCMakeGui_Body) + e1.getMessage()));
                        }
                    }
                });
            }
        }
        return composite;
    }

    public boolean performOk() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-LAH");
        for (ICMakePropertyPageControl control : this.componentList) {
            if (!control.isValueChanged()) continue;
            args.add(control.getConfiguredString());
        }
        if (args.size() == 2) {
            return true;
        }
        try {
            IProject project = (IProject)this.getElement();
            ICBuildConfiguration buildConfig = (ICBuildConfiguration)project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class);
            String configName = ((CBuildConfiguration)buildConfig).getName();
            IPath buildDir = project.getLocation().append("build").append(configName);
            ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class));
            launcher.setProject(project);
            if (launcher instanceof ICBuildCommandLauncher) {
                ((ICBuildCommandLauncher)launcher).setBuildConfiguration(buildConfig);
            }
            args.add(".");
            Process p = launcher.execute((IPath)new Path("cmake"), args.toArray(new String[0]), new String[0], buildDir, (IProgressMonitor)new NullProgressMonitor());
            int rc = -1;
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(project);
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try (ConsoleOutputStream stdout = console.getOutputStream();){
                    ConsoleOutputStream stderr = stdout;
                    StringBuilder buf = new StringBuilder();
                    for (String arg : args) {
                        buf.append(arg);
                        buf.append(" ");
                    }
                    buf.append(System.lineSeparator());
                    stdout.write(buf.toString().getBytes());
                    stdout.flush();
                    try {
                        if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new NullProgressMonitor()) == 0) {
                            p.waitFor();
                        }
                        rc = p.exitValue();
                        stdout.write(NLS.bind((String)Messages.CMakePropertyPage_Terminated, (Object)rc).getBytes());
                        stdout.flush();
                        if (rc != 0) {
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)this.getShell(), null, (String)Messages.CMakePropertyPage_FailedToConfigure));
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                Activator.log(e2);
                return false;
            }
        }
        catch (CoreException e3) {
            Activator.log((Exception)((Object)e3));
            return false;
        }
        return true;
    }

    List<ICMakePropertyPageControl> parseConfigureOutput(ByteArrayOutputStream stdout, Composite composite) {
        ArrayList<ICMakePropertyPageControl> controls = new ArrayList<ICMakePropertyPageControl>();
        try {
            ParseState state = ParseState.INIT;
            String output = stdout.toString(StandardCharsets.UTF_8.name());
            String[] lines = output.split("\\r?\\n");
            Pattern commentPattern = Pattern.compile("//(.*)");
            Pattern argPattern = Pattern.compile("(\\w+):([a-zA-Z]+)=(.*)");
            Pattern optionPattern = Pattern.compile(".*?options are:((\\s+\\w+(\\(.*\\))?)+).*");
            String lastComment = "";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                line = line.trim();
                switch (state) {
                    case INIT: {
                        Matcher commentMatcher = commentPattern.matcher(line);
                        if (!commentMatcher.matches()) break;
                        state = ParseState.SEENCOMMENT;
                        lastComment = commentMatcher.group(1);
                        break;
                    }
                    case SEENCOMMENT: {
                        Matcher argMatcher = argPattern.matcher(line);
                        if (argMatcher.matches()) {
                            ICMakePropertyPageControl control;
                            String name = argMatcher.group(1);
                            String type = argMatcher.group(2);
                            String initialValue = argMatcher.group(3);
                            Matcher optionMatcher = optionPattern.matcher(lastComment);
                            if (optionMatcher.matches()) {
                                String optionString = optionMatcher.group(1).trim();
                                String[] options = optionString.split("\\s+");
                                int i = 0;
                                while (i < options.length) {
                                    options[i] = options[i].replaceAll("\\(.*?\\)", "").trim();
                                    ++i;
                                }
                                CMakePropertyCombo control2 = new CMakePropertyCombo(composite, name, options, initialValue, lastComment);
                                controls.add(control2);
                            } else if ("BOOL".equals(type)) {
                                if ("ON".equals(initialValue) || "OFF".equals(initialValue)) {
                                    control = new CMakePropertyCombo(composite, name, new String[]{"ON", "OFF"}, initialValue, lastComment);
                                    controls.add(control);
                                } else if ("YES".equals(initialValue) || "NO".equals(initialValue)) {
                                    control = new CMakePropertyCombo(composite, name, new String[]{"YES", "NO"}, initialValue, lastComment);
                                    controls.add(control);
                                } else {
                                    control = new CMakePropertyCombo(composite, name, new String[]{"TRUE", "FALSE"}, "TRUE".equals(initialValue) ? "TRUE" : "FALSE", lastComment);
                                    controls.add(control);
                                }
                            } else {
                                control = new CMakePropertyText(composite, name, initialValue, lastComment);
                                controls.add(control);
                            }
                        }
                        state = ParseState.INIT;
                    }
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            return controls;
        }
        return controls;
    }

    public static enum ParseState {
        INIT,
        SEENCOMMENT;

    }
}

