/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CorrosionPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.corrosion";
    private static CorrosionPlugin plugin;

    private static synchronized void setSharedInstance(CorrosionPlugin newValue) {
        plugin = newValue;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CorrosionPlugin.setSharedInstance(this);
        Job.create((String)"Import .cargo in workspace", monitor -> CargoTools.ensureDotCargoImportedAsProject(monitor)).schedule();
    }

    public void stop(BundleContext context) throws Exception {
        CorrosionPlugin.setSharedInstance(null);
        super.stop(context);
    }

    public static CorrosionPlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable t) {
        CorrosionPlugin.logError((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void logError(IStatus s) {
        CorrosionPlugin.getDefault().getLog().log(s);
    }

    public static void showError(String title, String message, Exception exception) {
        CorrosionPlugin.showError(title, String.valueOf(message) + '\n' + exception.getLocalizedMessage());
    }

    public static void showError(String title, String message) {
        Display.getDefault().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 1, 0, new String[]{IDialogConstants.OK_LABEL});
            dialog.setBlockOnOpen(false);
            dialog.open();
        });
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        CorrosionPlugin.declareRegistryImage(reg, "images/cargo.png");
        CorrosionPlugin.declareRegistryImage(reg, "images/cargo16.png");
    }

    private static final void declareRegistryImage(ImageRegistry reg, String image) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        URL url = null;
        Bundle bundle = plugin.getBundle();
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(image), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        reg.put(image, desc);
    }

    public static boolean validateCommandVersion(String[] commandStrings, Pattern matchPattern) {
        String[] command = new String[1 + commandStrings.length];
        System.arraycopy(commandStrings, 0, command, 0, commandStrings.length);
        command[commandStrings.length] = "--version";
        return matchPattern.matcher(CorrosionPlugin.getOutputFromCommand(command)).matches();
    }

    public static boolean validateCommandVersion(String commandPath, Pattern matchPattern) {
        return matchPattern.matcher(CorrosionPlugin.getOutputFromCommand(commandPath, "--version")).matches();
    }

    public static Process getProcessForCommand(String ... commandStrings) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(commandStrings);
        builder.directory(CorrosionPlugin.getWorkingDirectoryFromPreferences());
        return builder.start();
    }

    private static File getWorkingDirectoryFromPreferences() {
        String wdString = CorrosionPlugin.getDefault().getPreferenceStore().getString("corrosion.workingDirectory");
        if (wdString == null) {
            return null;
        }
        File wdFile = new File(wdString);
        if (wdFile.exists() && wdFile.isDirectory()) {
            return wdFile;
        }
        return null;
    }

    public static String getOutputFromCommand(String ... commandStrings) {
        try {
            Process process = CorrosionPlugin.getProcessForCommand(commandStrings);
            if (process.waitFor() == 0) {
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    return in.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }
}

