/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.CDOEditorInputImpl;
import org.eclipse.emf.cdo.internal.ui.InteractiveConflictHandlerSelector;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorOpener;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.internal.cdo.transaction.CDOHandlingConflictResolver;
import org.eclipse.emf.spi.cdo.CDOMergingConflictResolver;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CDOModelEditorOpener
extends CDOEditorOpener.Default {
    private static final boolean INTERACTIVE_CONFLICT_RESOLUTION = OMPlatform.INSTANCE.isProperty("cdo.interactive.conflict.resolution", true);

    protected IEditorPart doOpenEditor(final IWorkbenchPage page, URI uri) {
        CDOObject cdoObject;
        CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)uri);
        if (checkout == null) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)"Error", (String)("The checkout for " + uri + " could not be found."));
            return null;
        }
        final CDOView view = checkout.openView();
        if (view instanceof CDOTransaction) {
            this.configureTransaction((CDOTransaction)view);
        }
        CDOID objectID = null;
        if (uri.hasFragment() && (cdoObject = CDOUtil.getCDOObject((EObject)view.getResourceSet().getEObject(uri, true))) != null) {
            objectID = cdoObject.cdoID();
        }
        final IEditorPart editor = this.openEditor(page, view, CDOURIUtil.extractResourcePath((URI)uri), objectID);
        page.addPartListener(new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                if (part == editor) {
                    try {
                        try {
                            view.close();
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                            page.removePartListener((IPartListener)this);
                        }
                    }
                    finally {
                        page.removePartListener((IPartListener)this);
                    }
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
        return editor;
    }

    protected void configureTransaction(CDOTransaction transaction) {
        CDOModelEditorOpener.addConflictResolver(transaction);
    }

    private IEditorPart openEditor(IWorkbenchPage page, CDOView view, String resourcePath, CDOID objectID) {
        try {
            IEditorReference[] references;
            String editorID = CDOEditorUtil.getEditorID();
            IEditorReference[] iEditorReferenceArray = references = CDOEditorUtil.findEditor((IWorkbenchPage)page, (CDOView)view, (String)resourcePath);
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                if (editorID.equals(reference.getId())) {
                    IEditorPart editor = references[0].getEditor(true);
                    page.activate((IWorkbenchPart)editor);
                    return editor;
                }
                ++n2;
            }
            CDOEditorInput input = CDOEditorUtil.createCDOEditorInput((CDOView)view, (String)resourcePath, (boolean)false);
            ((CDOEditorInputImpl)input).setObjectID(objectID);
            return page.openEditor((IEditorInput)input, editorID);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            return null;
        }
    }

    public static void addConflictResolver(CDOTransaction transaction) {
        if (INTERACTIVE_CONFLICT_RESOLUTION) {
            CDOHandlingConflictResolver conflictResolver = new CDOHandlingConflictResolver();
            conflictResolver.setConflictHandlerSelector((CDOHandlingConflictResolver.ConflictHandlerSelector)new InteractiveConflictHandlerSelector());
            transaction.options().addConflictResolver((CDOConflictResolver)conflictResolver);
        } else {
            transaction.options().addConflictResolver((CDOConflictResolver)new CDOMergingConflictResolver());
        }
    }
}

