/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.git.ext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.connector.git.EMFDiffMergeGitConnectorPlugin;
import org.eclipse.emf.diffmerge.connector.git.Messages;
import org.eclipse.emf.diffmerge.connector.git.ext.GitHelper;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.history.IFileRevision;

public abstract class AbstractGitURIConverter
extends ExtensibleURIConverterImpl {
    private static Method __inCommitEGit5Method = null;
    private static Method __inCommitLegacyMethod = null;
    private final Repository _repository;

    public AbstractGitURIConverter(Repository repository_p) {
        this._repository = repository_p;
    }

    public AbstractGitURIConverter(List<URIHandler> uriHandlers_p, List<ContentHandler> contentHandlers_p, Repository repository_p) {
        super(uriHandlers_p, contentHandlers_p);
        this._repository = repository_p;
    }

    private static void checkEGitMethod() {
        if (__inCommitEGit5Method == null && __inCommitLegacyMethod == null) {
            String inCommitMethodName = "inCommit";
            String egit5ParameterClassName = "CheckoutMetadata";
            Class<?> egit5ParameterClass = null;
            Class<?>[] classArray = DirCacheCheckout.class.getDeclaredClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> nested = classArray[n2];
                if ("CheckoutMetadata".equals(nested.getSimpleName())) {
                    egit5ParameterClass = nested;
                    break;
                }
                ++n2;
            }
            if (egit5ParameterClass != null) {
                try {
                    __inCommitEGit5Method = GitFileRevision.class.getMethod("inCommit", Repository.class, RevCommit.class, String.class, ObjectId.class, egit5ParameterClass);
                }
                catch (NoSuchMethodException nested) {
                    // empty catch block
                }
            }
            if (__inCommitEGit5Method == null) {
                try {
                    __inCommitLegacyMethod = GitFileRevision.class.getMethod("inCommit", Repository.class, RevCommit.class, String.class, ObjectId.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public InputStream createInputStream(URI uri_p, Map<?, ?> options_p) throws IOException {
        Repository repo = this._repository;
        if (repo != null && this.isSupportedURI(uri_p)) {
            String pathRepresentation = this.getURIPathRepresentation(uri_p);
            IPath newPath = new Path(repo.getWorkTree().getAbsolutePath()).append(pathRepresentation);
            File target = newPath.toFile();
            if (target != null && target.exists()) {
                try {
                    String gitPath = pathRepresentation.substring(1);
                    return this.getGitFileRevision(gitPath).getStorage((IProgressMonitor)new NullProgressMonitor()).getContents();
                }
                catch (CoreException e) {
                    EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
                }
            } else {
                EMFDiffMergeGitConnectorPlugin.getDefault().getLog().log((IStatus)new Status(4, EMFDiffMergeGitConnectorPlugin.getDefault().getPluginId(), String.format(Messages.AbstractGitURIConverter_CannotFindResource, newPath)));
            }
        }
        return super.createInputStream(uri_p, options_p);
    }

    protected abstract IFileRevision getGitFileRevision(String var1);

    protected Repository getRepository() {
        return this._repository;
    }

    protected String getURIPathRepresentation(URI uri_p) {
        return uri_p.devicePath();
    }

    protected GitFileRevision inCommit(Repository db_p, RevCommit commit_p, String path_p, ObjectId blobId_p) {
        AbstractGitURIConverter.checkEGitMethod();
        Object returned = null;
        try {
            if (__inCommitEGit5Method != null) {
                returned = __inCommitEGit5Method.invoke(null, db_p, commit_p, path_p, blobId_p, null);
            } else if (__inCommitLegacyMethod != null) {
                returned = __inCommitLegacyMethod.invoke(null, db_p, commit_p, path_p, blobId_p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GitFileRevision result = returned instanceof GitFileRevision ? (GitFileRevision)returned : null;
        return result;
    }

    protected GitFileRevision inIndex(Repository db_p, String path_p) {
        return GitFileRevision.inIndex((Repository)db_p, (String)path_p);
    }

    protected GitFileRevision inIndex(Repository db_p, String path_p, int stage_p) {
        return GitFileRevision.inIndex((Repository)db_p, (String)path_p, (int)stage_p);
    }

    protected boolean isSupportedURI(URI uri_p) {
        return GitHelper.INSTANCE.getGitSchemes().contains(uri_p.scheme());
    }
}

