/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.driver;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventThreadQueuer
implements IEventThreadQueuer {
    private static AutServerLogger log = new AutServerLogger(DefaultEventThreadQueuer.class);

    @Override
    public <V> V invokeAndWait(String name, IRunnable<V> runnable) throws StepExecutionException {
        return runnable.run();
    }

    @Override
    public void invokeLater(String name, Runnable runnable) throws StepExecutionException {
        new Thread(runnable, name).start();
    }

    @Override
    public <V> V invokeAndWait(String name, Callable<V> callable, long timeout) throws StepExecutionException, TimeoutException {
        FutureTask<V> task = new FutureTask<V>(callable);
        new Thread(task, name).start();
        try {
            return task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            log.error(ie);
            throw new StepExecutionException(ie);
        }
        catch (ExecutionException ee) {
            Throwable thrown = ee.getCause();
            if (thrown instanceof StepExecutionException) {
                if (log.isInfoEnabled()) {
                    log.info(ee);
                }
                throw (StepExecutionException)((Object)thrown);
            }
            log.error("exception thrown by '" + name + "':", thrown);
            throw new StepExecutionException(thrown);
        }
    }
}

