/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.docker.ui.wizards.ImageSearch;
import org.eclipse.linuxtools.internal.docker.core.RegistryInfo;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.utils.IRunnableWithResult;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageNameValidator;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunNetworkModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RunImageMainTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "RunMainTab.name";
    private static final int COLUMNS = 3;
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunSelectionModel model;
    private final ImageRunResourceVolumesVariablesModel volumesModel;
    private final ImageRunNetworkModel networkModel;

    public RunImageMainTab(ImageRunSelectionModel model, ImageRunResourceVolumesVariablesModel volumesModel, ImageRunNetworkModel networkModel) {
        this.model = model;
        this.volumesModel = volumesModel;
        this.networkModel = networkModel;
    }

    public ImageRunSelectionModel getModel() {
        return this.model;
    }

    public String getName() {
        return LaunchMessages.getString(TAB_NAME);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        if (this.model == null) {
            this.setErrorMessage(LaunchMessages.getString("NoConnectionError.msg"));
            return;
        }
        this.setErrorMessage(null);
        this.setDefaultValues();
        this.createImageSettingsSection(container);
        this.createSectionSeparator(container, true);
        this.createRunOptionsSection(container);
        IObservableValue connectionSelectionObservable = BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedConnectionName").observe((Object)this.model);
        connectionSelectionObservable.addValueChangeListener(this.onConnectionSelectionChange());
        IObservableValue imageSelectionObservable = BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageName").observe((Object)this.model);
        imageSelectionObservable.addValueChangeListener(this.onImageSelectionChange());
        this.setControl((Control)container);
    }

    private void setDefaultValues() {
        IDockerImage selectedImage = this.model.getSelectedImage();
        if (selectedImage == null) {
            return;
        }
        this.findImageInfo(selectedImage);
    }

    private void createSectionSeparator(Composite container, boolean separator) {
        int SECTION_INDENT = 10;
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).indent(-1, 10).applyTo((Control)new Label(container, separator ? 258 : 0));
    }

    private void createImageSettingsSection(Composite container) {
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)new Label(container, 0));
        Label connectionSelectionLabel = new Label(container, 0);
        connectionSelectionLabel.setText(WizardMessages.getString("Connection.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)connectionSelectionLabel);
        Combo connectionSelectionCombo = new Combo(container, 2048);
        connectionSelectionCombo.setToolTipText(LaunchMessages.getString("RunMainTabSelectConnection.tooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)connectionSelectionCombo);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        new ControlDecoration((Control)connectionSelectionCombo, 16512);
        ComboViewer connectionSelectionComboViewer = new ComboViewer(connectionSelectionCombo);
        connectionSelectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        connectionSelectionComboViewer.setInput((Object)DockerConnectionManager.getInstance().getConnectionNames().toArray());
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)connectionSelectionCombo), BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedConnectionName").observe((Object)this.model));
        Label imageSelectionLabel = new Label(container, 0);
        imageSelectionLabel.setText(WizardMessages.getString("Image.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        Combo imageSelectionCombo = new Combo(container, 2048);
        ComboViewer imageSelectionComboViewer = new ComboViewer(imageSelectionCombo);
        imageSelectionCombo.setToolTipText(WizardMessages.getString("ImageRunSelectionPage.selectTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)imageSelectionCombo);
        new ControlDecoration((Control)imageSelectionCombo, 16512);
        new ContentProposalAdapter((Control)imageSelectionCombo, (IControlContentAdapter)new ComboContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Combo combo = (Combo)control;
                Point selection = combo.getSelection();
                combo.setText(text);
                selection.y = selection.x = text.length();
                combo.setSelection(selection);
            }
        }, this.getImageNameContentProposalProvider(imageSelectionCombo), null, null);
        Button searchImageButton = new Button(container, 0);
        searchImageButton.setText(WizardMessages.getString("ImageRunSelectionPage.search"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).hint(LaunchConfigurationUtils.getButtonWidthHint(searchImageButton), -1).applyTo((Control)searchImageButton);
        searchImageButton.addSelectionListener(this.onSearchImage());
        imageSelectionComboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.dbc.bindList((IObservableList)WidgetProperties.items().observe((Widget)imageSelectionCombo), BeanProperties.list(ImageRunSelectionModel.class, (String)"imageNames").observe((Object)this.model));
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)imageSelectionCombo), BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageName").observe((Object)this.model));
        Label containerNameLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        containerNameLabel.setText(WizardMessages.getString("ImageRunSelectionPage.containerName"));
        Text containerNameText = new Text(container, 2048);
        containerNameText.setToolTipText(WizardMessages.getString("ImageRunSelectionPage.containerTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)containerNameText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)containerNameText), BeanProperties.value(ImageRunSelectionModel.class, (String)"containerName").observe((Object)this.model));
        Label entrypointLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        entrypointLabel.setText(WizardMessages.getString("ImageRunSelectionPage.entrypoint"));
        Text entrypointText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)entrypointText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)entrypointText), BeanProperties.value(ImageRunSelectionModel.class, (String)"entrypoint").observe((Object)this.model));
        Label commandLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        commandLabel.setText(WizardMessages.getString("ImageRunSelectionPage.command"));
        Text commandText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)commandText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)commandText), BeanProperties.value(ImageRunSelectionModel.class, (String)"command").observe((Object)this.model));
    }

    private IContentProposalProvider getImageNameContentProposalProvider(Combo imageSelectionCombo) {
        return (contents, position) -> {
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            String[] stringArray = imageSelectionCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String imageName = stringArray[n2];
                if (imageName.contains(contents)) {
                    proposals.add(new ContentProposal(imageName, imageName, imageName, position));
                }
                ++n2;
            }
            return proposals.toArray(new IContentProposal[0]);
        };
    }

    private IValueChangeListener onImageSelectionChange() {
        return event -> {
            IDockerImage selectedImage = this.model.getSelectedImage();
            if (selectedImage == null) {
                this.model.setExposedPorts(new ArrayList<ImageRunSelectionModel.ExposedPortModel>());
                return;
            }
            this.findImageInfo(selectedImage);
            this.volumesModel.setSelectedImage(selectedImage);
        };
    }

    private IValueChangeListener onConnectionSelectionChange() {
        return event -> {
            this.networkModel.setConnection(this.model.getSelectedConnection());
            IDockerImage selectedImage = this.model.getSelectedImage();
            if (selectedImage == null) {
                List<String> imageNames = this.model.getImageNames();
                if (imageNames.size() > 0) {
                    this.model.setSelectedImageName(imageNames.get(0));
                    selectedImage = this.model.getSelectedImage();
                } else {
                    this.model.setExposedPorts(new ArrayList<ImageRunSelectionModel.ExposedPortModel>());
                    return;
                }
            }
            this.findImageInfo(selectedImage);
            this.volumesModel.setSelectedImage(selectedImage);
        };
    }

    private void findImageInfo(IDockerImage selectedImage) {
        try {
            FindImageInfoRunnable findImageInfoRunnable = new FindImageInfoRunnable(selectedImage);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(true, true, (IRunnableWithProgress)findImageInfoRunnable);
            IDockerImageInfo selectedImageInfo = findImageInfoRunnable.getResult();
            Set exposedPortInfos = selectedImageInfo.config().exposedPorts();
            ArrayList<ImageRunSelectionModel.ExposedPortModel> availablePorts = new ArrayList<ImageRunSelectionModel.ExposedPortModel>();
            if (exposedPortInfos != null) {
                for (String exposedPortInfo : exposedPortInfos) {
                    String privatePort = exposedPortInfo.substring(0, exposedPortInfo.indexOf(47));
                    String type = exposedPortInfo.substring(exposedPortInfo.indexOf(47));
                    ImageRunSelectionModel.ExposedPortModel exposedPort = new ImageRunSelectionModel.ExposedPortModel(privatePort, type, "", privatePort);
                    availablePorts.add(exposedPort);
                }
            }
            this.model.setExposedPorts(availablePorts);
            this.model.setEntrypoint(selectedImageInfo.config().entrypoint());
            this.model.setCommand(selectedImageInfo.config().cmd());
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    private void createRunOptionsSection(Composite container) {
        Button interactiveButton = new Button(container, 32);
        interactiveButton.setText(WizardMessages.getString("ImageRunSelectionPage.openStdin"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)interactiveButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)interactiveButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"interactiveMode").observe((Object)this.model));
        Button allocatePseudoTTY = new Button(container, 32);
        allocatePseudoTTY.setText(WizardMessages.getString("ImageRunSelectionPage.tty"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)allocatePseudoTTY);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)allocatePseudoTTY), BeanProperties.value(ImageRunSelectionModel.class, (String)"allocatePseudoTTY").observe((Object)this.model));
        Button removeWhenExitsButton = new Button(container, 32);
        removeWhenExitsButton.setText(WizardMessages.getString("ImageRunSelectionPage.autoRemove"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)removeWhenExitsButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)removeWhenExitsButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"removeWhenExits").observe((Object)this.model));
        Button privilegedButton = new Button(container, 32);
        privilegedButton.setText(WizardMessages.getString("ImageRunSelectionPage.privileged"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)privilegedButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)privilegedButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"privileged").observe((Object)this.model));
    }

    private SelectionListener onSearchImage() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ImageSearch imageSearchWizard = new ImageSearch(this.model.getSelectedConnection(), this.model.getSelectedImageName(), (IRegistry)new RegistryInfo("https://index.docker.io", true));
            boolean completed = CommandUtils.openWizard((IWizard)imageSearchWizard, this.getShell());
            if (completed) {
                this.model.setSelectedImageName(imageSearchWizard.getSelectedImage());
            }
        });
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.linuxtools.docker.ui.main_tab.gif");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.model == null) {
            return;
        }
        try {
            String defaultConnectionName = DockerConnectionManager.getInstance().getAllConnections().stream().filter(connection -> connection.isOpen()).map(connection -> connection.getName()).findFirst().orElse("");
            if (defaultConnectionName.equals("")) {
                this.setErrorMessage(WizardMessages.getString("ErrorNoActiveConnection.msg"));
            }
            String connectionName = configuration.getAttribute("connectionName", defaultConnectionName);
            this.model.setSelectedConnectionName(connectionName);
            String imageName = configuration.getAttribute("imageName", "");
            this.model.setSelectedImageName(imageName);
            String entryPoint = configuration.getAttribute("entryPoint", "");
            this.model.setEntrypoint(entryPoint);
            String command = configuration.getAttribute("command", "");
            this.model.setCommand(command);
            String containerName = configuration.getAttribute("containerName", "");
            this.model.setContainerName(containerName);
            boolean removeContainer = configuration.getAttribute("autoRemove", false);
            this.model.setRemoveWhenExits(removeContainer);
            boolean interactive = configuration.getAttribute("interactive", false);
            this.model.setInteractiveMode(interactive);
            boolean useTTY = configuration.getAttribute("allocatePseudoTTY", false);
            this.model.setAllocatePseudoTTY(useTTY);
            boolean privileged = configuration.getAttribute("privileged", false);
            this.model.setPrivileged(privileged);
        }
        catch (CoreException e) {
            Activator.logErrorMessage(LaunchMessages.getString("RunDockerImageLaunchConfiguration.load.failure"), e);
        }
        this.model.addPropertyChangeListener(new LaunchConfigurationChangeListener());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.model == null) {
            return;
        }
        configuration.setAttribute("connectionName", this.model.getSelectedConnectionName());
        if (this.model.getSelectedImage() != null) {
            configuration.setAttribute("imageId", this.model.getSelectedImage().id());
            configuration.setAttribute("imageName", this.model.getSelectedImageName());
        }
        configuration.setAttribute("command", this.model.getCommand());
        configuration.setAttribute("entryPoint", "".equals(this.model.getEntrypoint()) ? null : this.model.getEntrypoint());
        configuration.setAttribute("containerName", "".equals(this.model.getContainerName()) ? null : this.model.getContainerName());
        configuration.setAttribute("allocatePseudoTTY", this.model.isAllocatePseudoTTY());
        configuration.setAttribute("autoRemove", this.model.isRemoveWhenExits());
        configuration.setAttribute("interactive", this.model.isInteractiveMode());
        configuration.setAttribute("privileged", this.model.isPrivileged());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block12: {
            block11: {
                block10: {
                    String connectionName;
                    block9: {
                        block8: {
                            if (this.model != null) break block8;
                            return false;
                        }
                        connectionName = launchConfig.getAttribute("connectionName", "");
                        if (!connectionName.isEmpty()) break block9;
                        return false;
                    }
                    IDockerConnection connection = DockerConnectionManager.getInstance().findConnection(connectionName);
                    if (connection != null && connection.isOpen()) break block10;
                    this.setErrorMessage(WizardMessages.getFormattedString("ErrorInactiveConnection.msg", connectionName));
                    return false;
                }
                IStatus imageSelectionValidationStatus = new ImageSelectionValidator().validate(this.model.getSelectedImageName());
                if (imageSelectionValidationStatus.isOK()) break block11;
                this.setErrorMessage(imageSelectionValidationStatus.getMessage());
                return false;
            }
            IStatus imageNameValidationStatus = new ImageNameValidator().validate(this.model.getSelectedImageName());
            if (imageNameValidationStatus.isOK()) break block12;
            this.setErrorMessage(imageNameValidationStatus.getMessage());
            return false;
        }
        try {
            IStatus containerNameValidationStatus = new ContainerNameValidator().validate(this.model.getContainerName());
            if (!containerNameValidationStatus.isOK()) {
                this.setErrorMessage(containerNameValidationStatus.getMessage());
                return false;
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        this.setErrorMessage(null);
        return true;
    }

    private class ContainerNameValidator
    implements IValidator {
        private ContainerNameValidator() {
        }

        public IStatus validate(Object value) {
            String containerName = (String)value;
            for (IDockerContainer container : RunImageMainTab.this.model.getSelectedConnection().getContainers()) {
                if (!container.name().equals(containerName)) continue;
                return ValidationStatus.error((String)WizardMessages.getString("ImageRunSelectionPage.containerWithSameName"));
            }
            return ValidationStatus.ok();
        }
    }

    private static final class FindImageInfoRunnable
    implements IRunnableWithResult<IDockerImageInfo> {
        private final IDockerImage selectedImage;
        private IDockerImageInfo selectedImageInfo;

        private FindImageInfoRunnable(IDockerImage selectedImage) {
            this.selectedImage = selectedImage;
        }

        public void run(IProgressMonitor monitor) {
            this.selectedImageInfo = this.selectedImage.getConnection().getImageInfo(this.selectedImage.id());
        }

        @Override
        public IDockerImageInfo getResult() {
            return this.selectedImageInfo;
        }
    }

    private class ImageSelectionValidator
    implements IValidator {
        private ImageSelectionValidator() {
        }

        public IStatus validate(Object value) {
            String selectedImageName = (String)value;
            if (selectedImageName.isEmpty()) {
                RunImageMainTab.this.model.setSelectedImageNeedsPulling(false);
                return ValidationStatus.error((String)WizardMessages.getString("ImageRunSelectionPage.specifyImageMsg"));
            }
            if (RunImageMainTab.this.model.getSelectedImage() != null) {
                RunImageMainTab.this.model.setSelectedImageNeedsPulling(false);
                return ValidationStatus.ok();
            }
            RunImageMainTab.this.model.setSelectedImageNeedsPulling(true);
            return ValidationStatus.warning((String)WizardMessages.getFormattedString("ImageRunSelectionPage.imageNotFoundMessage", selectedImageName));
        }
    }

    private class LaunchConfigurationChangeListener
    implements PropertyChangeListener {
        private LaunchConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunImageMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

