/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.utils;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.AndMatcher;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.direct.project.Project;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.swt.condition.ShellHasChildrenOrIsNotAvailable;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.AbstractShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class DeleteUtils {
    private static final Logger log = Logger.getLogger(DeleteUtils.class);

    public static void handleDeletion(org.eclipse.reddeer.swt.api.Shell deleteShell) {
        DeleteUtils.handleDeletion(deleteShell, TimePeriod.VERY_LONG);
    }

    public static void handleDeletion(org.eclipse.reddeer.swt.api.Shell deleteShell, TimePeriod timeout) {
        block8: {
            new WaitUntil((WaitCondition)new ShellHasChildrenOrIsNotAvailable(deleteShell), timeout);
            int childShells = 0;
            try {
                try {
                    childShells = ShellLookup.getInstance().getShells((Shell)deleteShell.getSWTWidget()).length;
                }
                catch (RedDeerException redDeerException) {
                    log.debug("Delete shell is disposed.");
                    TimePeriod remainingTimeout = timeout;
                    if (childShells == 1) {
                        ShellWithButton s = new ShellWithButton("Delete.*", "Continue");
                        new PushButton("Continue").click();
                        remainingTimeout = new GroupWait(timeout, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable((org.eclipse.reddeer.swt.api.Shell)s)), WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable(deleteShell))}).getRemainingTimeout();
                    }
                    new WaitWhile((WaitCondition)new JobIsRunning(), remainingTimeout);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                TimePeriod remainingTimeout = timeout;
                if (childShells == 1) {
                    ShellWithButton s = new ShellWithButton("Delete.*", "Continue");
                    new PushButton("Continue").click();
                    remainingTimeout = new GroupWait(timeout, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable((org.eclipse.reddeer.swt.api.Shell)s)), WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable(deleteShell))}).getRemainingTimeout();
                }
                new WaitWhile((WaitCondition)new JobIsRunning(), remainingTimeout);
                throw throwable;
            }
            TimePeriod remainingTimeout = timeout;
            if (childShells == 1) {
                ShellWithButton s = new ShellWithButton("Delete.*", "Continue");
                new PushButton("Continue").click();
                remainingTimeout = new GroupWait(timeout, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable((org.eclipse.reddeer.swt.api.Shell)s)), WaitProvider.waitWhile((WaitCondition)new ShellIsAvailable(deleteShell))}).getRemainingTimeout();
            }
            new WaitWhile((WaitCondition)new JobIsRunning(), remainingTimeout);
        }
    }

    public static void forceProjectDeletion(DefaultProject project, boolean deleteFromFileSystem) {
        try {
            project.delete(deleteFromFileSystem);
        }
        catch (RedDeerException redDeerException) {
            log.debug("Delete project '" + project.getName() + "' via Eclipse API ");
            Project.delete((String)project.getName(), (boolean)deleteFromFileSystem, (boolean)true);
        }
    }

    private static Shell lookForShellWithButton(String title, final String buttonLabel) {
        WithTextMatcher titleMatcher = new WithTextMatcher((Matcher)new RegexMatcher(title));
        BaseMatcher<String> buttonMatcher = new BaseMatcher<String>(){

            public boolean matches(Object obj) {
                if (obj instanceof Control) {
                    final Control control = (Control)obj;
                    ReferencedComposite ref = new ReferencedComposite(){

                        public Control getControl() {
                            return control;
                        }
                    };
                    try {
                        new PushButton(ref, buttonLabel);
                        return true;
                    }
                    catch (CoreLayerException coreLayerException) {}
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("containing button '" + buttonLabel + "'");
            }
        };
        AndMatcher matcher = new AndMatcher(new Matcher[]{titleMatcher, buttonMatcher});
        return ShellLookup.getInstance().getShell(new Matcher[]{matcher});
    }

    private static class ShellWithButton
    extends AbstractShell {
        public ShellWithButton(String title, String buttonLabel) {
            super(DeleteUtils.lookForShellWithButton(title, buttonLabel));
            this.setFocus();
            log.debug("Shell with title '" + title + "' and button '" + buttonLabel + "' found");
        }
    }
}

